/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.descriptors;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.api.tools.internal.descriptors.NamedElementDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IResourceDescriptor;

public class ResourceDescriptorImpl
extends NamedElementDescriptorImpl
implements IResourceDescriptor {
    private IResource fResourceHandle = null;

    public ResourceDescriptorImpl(IResource resource) {
        super(resource.getName());
        this.fResourceHandle = resource;
    }

    public IElementDescriptor[] getPath() {
        ArrayList<ResourceDescriptorImpl> paths = new ArrayList<ResourceDescriptorImpl>();
        IProject project = this.fResourceHandle.getProject();
        if (project != null) {
            IPath path = this.fResourceHandle.getProjectRelativePath();
            IResource res = null;
            int i = 1;
            while (i < path.segmentCount() + 1) {
                res = project.findMember(path.uptoSegment(i));
                if (res == null) {
                    paths.clear();
                    break;
                }
                paths.add(new ResourceDescriptorImpl(res));
                ++i;
            }
        }
        return paths.toArray(new IElementDescriptor[paths.size()]);
    }

    public IElementDescriptor getParent() {
        return new ResourceDescriptorImpl((IResource)this.fResourceHandle.getParent());
    }

    public int getElementType() {
        return 7;
    }

    public String toString() {
        return this.getName();
    }

    public int getResourceType() {
        return this.fResourceHandle.getType();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IResourceDescriptor) {
            return ((IResourceDescriptor)obj).getName().equals(this.getName());
        }
        return super.equals(obj);
    }
}

