/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.ApiProfile;
import org.eclipse.pde.api.tools.internal.ApiProfileManager;
import org.eclipse.pde.api.tools.internal.descriptors.PackageDescriptorImpl;
import org.eclipse.pde.api.tools.internal.descriptors.ResourceDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IResourceDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchCriteria;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchEngine;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.search.SearchCriteria;
import org.eclipse.pde.api.tools.internal.search.SearchEngine;
import org.eclipse.pde.api.tools.internal.search.SearchScope;
import org.eclipse.pde.api.tools.internal.search.TypeScope;
import org.eclipse.pde.api.tools.internal.util.Util;

public class Factory {
    public static IApiProfile newApiProfile(String name) {
        return new ApiProfile(name);
    }

    public static IApiProfile newApiProfile(String name, File eeDescription) throws CoreException {
        return new ApiProfile(name, eeDescription);
    }

    public static IPackageDescriptor packageDescriptor(String packageName) {
        return new PackageDescriptorImpl(packageName);
    }

    public static IResourceDescriptor resourceDescriptor(IResource resource) {
        return new ResourceDescriptorImpl(resource);
    }

    public static IReferenceTypeDescriptor typeDescriptor(String fullyQualifiedName) {
        String packageName = Util.getPackageName(fullyQualifiedName);
        String typeName = Util.getTypeName(fullyQualifiedName);
        return Factory.packageDescriptor(packageName).getType(typeName);
    }

    public static IMethodDescriptor methodDescriptor(String typename, String name, String signature) {
        IReferenceTypeDescriptor type = Factory.typeDescriptor(typename);
        return type.getMethod(name, signature);
    }

    public static IFieldDescriptor fieldDescriptor(String typename, String name) {
        IReferenceTypeDescriptor type = Factory.typeDescriptor(typename);
        return type.getField(name);
    }

    public static IApiSearchScope newScope(IApiComponent[] components) {
        SearchScope scope = new SearchScope();
        int i = 0;
        while (i < components.length) {
            scope.addComponent(components[i]);
            ++i;
        }
        return scope;
    }

    public static IApiSearchScope newScope(IApiComponent component, IElementDescriptor[] elements) {
        SearchScope scope = new SearchScope();
        int i = 0;
        while (i < elements.length) {
            scope.addElement(component, elements[i]);
            ++i;
        }
        return scope;
    }

    public static IApiSearchScope newTypeScope(IApiComponent component, IReferenceTypeDescriptor[] types) {
        return new TypeScope(component, types);
    }

    public static IApiSearchEngine newSearchEngine() {
        return new SearchEngine();
    }

    public static IApiProfile createProfile(InputStream descriptionStream) throws CoreException {
        return ApiProfileManager.restoreProfile(descriptionStream);
    }

    public static IApiSearchCriteria newSearchCriteria() {
        return new SearchCriteria();
    }
}

