/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.stubs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class Converter {
    static final String STUB_MARKER_NAME = "StubMarker";
    static final int DEFAULT = 0;
    static final int ABORT = 1;
    static final int PROCESS_CLASS_FILES = 2;
    static final int PROCESS_ARCHIVES = 4;
    public static final int REPORT_REFS = 8;
    static final int PROCESS_SUB = 16;
    static final int PROCESS_ALL = 32;
    static final int COMPRESS_RESULTING_ARCHIVES = 128;
    static final int IGNORE_CLASS_FILE = 256;
    public static final int MODIFIER_PRIVATE = 512;
    public static final int MODIFIER_PUBLIC = 1024;
    public static final int MODIFIER_PROTECTED = 2048;
    public static final int MODIFIER_PACKAGE = 4096;
    public static final int MODIFIER_SYNTHETIC = 8192;
    public static final int MODIFIER_MASK = 15872;
    static final int VERBOSE_MODE = 16384;
    static final int RESOURCES_FILES = 32768;
    static final int IS_STUB_CLASS_FILE = 65536;
    static final CRC32 CRC32 = new CRC32();
    int bits;
    private String input;
    private String output;

    public static void main(String[] args) {
        Converter converter = new Converter();
        converter.configure(args);
        if (converter.isVerbose()) {
            long time = System.currentTimeMillis();
            converter.process();
            System.out.println(System.currentTimeMillis() - time + "ms spent");
        } else {
            converter.process();
        }
    }

    public static byte[] createStub(IClassFile classFile) throws CoreException, IOException {
        return Converter.createStub(classFile, 15872);
    }

    public static byte[] createStub(IClassFile classFile, int options) throws CoreException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new ByteArrayInputStream(classFile.getContents()));
            byte[] byArray = Converter.process(inputStream, options);
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
    }

    private boolean isVerbose() {
        return (this.bits & 0x4000) != 0;
    }

    private static void writeZipFileEntry(ZipOutputStream outputStream, String entryName, byte[] bytes, CRC32 crc32, int bits) throws IOException {
        crc32.reset();
        int byteArraySize = bytes.length;
        crc32.update(bytes, 0, byteArraySize);
        ZipEntry entry = new ZipEntry(entryName);
        entry.setMethod((bits & 0x80) != 0 ? 8 : 0);
        entry.setSize(byteArraySize);
        entry.setCrc(crc32.getValue());
        outputStream.putNextEntry(entry);
        outputStream.write(bytes, 0, byteArraySize);
        outputStream.closeEntry();
    }

    private void configure(String[] args) {
        this.bits |= 0xBE00;
        int mode = 0;
        int i = 0;
        int max = args.length;
        while (i < max) {
            String currentArg = args[i];
            switch (mode) {
                case 0: {
                    if ("-input".equals(currentArg)) {
                        mode = 1;
                        break;
                    }
                    if ("-output".equals(currentArg)) {
                        mode = 2;
                        break;
                    }
                    if ("-s".equals(currentArg)) {
                        this.bits |= 0x10;
                        break;
                    }
                    if ("-all".equals(currentArg)) {
                        if ((this.bits & 0x26) != 0) {
                            this.bits |= 1;
                            return;
                        }
                        this.bits |= 0x20;
                        break;
                    }
                    if ("-archives".equals(currentArg)) {
                        if ((this.bits & 0x26) != 0) {
                            this.bits |= 1;
                            return;
                        }
                        this.bits |= 4;
                        break;
                    }
                    if ("-classfiles".equals(currentArg)) {
                        if ((this.bits & 0x26) != 0) {
                            this.bits |= 1;
                            return;
                        }
                        this.bits |= 2;
                        break;
                    }
                    if ("-refs".equals(currentArg)) {
                        this.bits |= 8;
                        break;
                    }
                    if ("-compress".equals(currentArg)) {
                        this.bits |= 0x80;
                        break;
                    }
                    if (currentArg.startsWith("-keep:")) {
                        this.bits &= 0xFFFFC1FF;
                        String keepOption = currentArg;
                        int length = keepOption.length();
                        if (length <= 6) {
                            System.err.println("Unknown option : " + currentArg);
                            break;
                        }
                        StringTokenizer tokenizer = new StringTokenizer(keepOption.substring(6, length), ",");
                        int tokenCounter = 0;
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            ++tokenCounter;
                            if ("private".equals(token)) {
                                this.bits |= 0x200;
                                continue;
                            }
                            if ("public".equals(token)) {
                                this.bits |= 0x400;
                                continue;
                            }
                            if ("protected".equals(token)) {
                                this.bits |= 0x800;
                                continue;
                            }
                            if ("synthetic".equals(token)) {
                                this.bits |= 0x2000;
                                continue;
                            }
                            if ("package".equals(token)) {
                                this.bits |= 0x1000;
                                continue;
                            }
                            if ("all".equals(token)) {
                                this.bits |= 0x3E00;
                                continue;
                            }
                            if (!"none".equals(token) || (this.bits & 0x3E00) == 0) continue;
                            System.err.println("none option cannot be used with other visibility check : " + currentArg);
                        }
                        if (tokenCounter != 0) break;
                        System.err.println("Unknown option : " + currentArg);
                        break;
                    }
                    if ("-verbose".equals(currentArg) || "-v".equals(currentArg)) {
                        this.bits |= 0x4000;
                        break;
                    }
                    if ("-skipresourcefiles".equals(currentArg)) {
                        this.bits &= 0xFFFF7FFF;
                        break;
                    }
                    System.err.println("Unknown option : " + currentArg);
                    break;
                }
                case 1: {
                    this.input = currentArg;
                    mode = 0;
                    break;
                }
                case 2: {
                    this.output = currentArg;
                    mode = 0;
                }
            }
            ++i;
        }
        if (this.input == null || this.output == null) {
            this.bits |= 1;
            return;
        }
        File outputFile = new File(this.output);
        if (!outputFile.exists()) {
            if (!outputFile.mkdirs()) {
                this.bits |= 1;
            }
        } else if (!outputFile.isDirectory()) {
            this.bits |= 1;
        }
        if ((this.bits & 0x26) != 0) {
            this.bits |= 0x20;
        }
    }

    private void process() {
        if (this.shouldAbort()) {
            this.printUsage();
            return;
        }
        File root = new File(this.input);
        if (root.isDirectory()) {
            final boolean processSubDirectories = (this.bits & 0x10) != 0;
            File[] allFiles = Util.getAllFiles(root, new FileFilter(){

                public boolean accept(File path) {
                    String pathName = path.getAbsolutePath();
                    if ((Converter.this.bits & 0x20) != 0) {
                        if (Util.isArchive(pathName) || Util.isClassFile(pathName) || processSubDirectories && path.isDirectory()) {
                            return true;
                        }
                        if (path.isFile() && (Converter.this.bits & 0x8000) != 0) {
                            return true;
                        }
                        if ((Converter.this.bits & 0x4000) != 0) {
                            System.out.println("Skip resource file : " + pathName);
                        }
                        return false;
                    }
                    if ((Converter.this.bits & 2) != 0) {
                        return Util.isClassFile(pathName) || processSubDirectories && path.isDirectory();
                    }
                    if ((Converter.this.bits & 4) != 0) {
                        return Util.isArchive(pathName) || processSubDirectories && path.isDirectory();
                    }
                    return false;
                }
            });
            if (allFiles == null) {
                return;
            }
            String rootAbsolutePath = root.getAbsolutePath();
            int i = 0;
            int max = allFiles.length;
            while (i < max) {
                File inputFile = allFiles[i];
                File outputFile = new File(this.output, inputFile.getAbsolutePath().substring(rootAbsolutePath.length()));
                Converter.processSingleEntry(inputFile.getAbsolutePath(), outputFile, this.bits);
                ++i;
            }
        } else {
            File inputFile = new File(this.input);
            File outputFile = new File(this.output, inputFile.getName());
            Converter.processSingleEntry(this.input, outputFile, this.bits);
        }
    }

    private void printUsage() {
        String usage = "-input [file or folder name] -output [folder name] [options]\n\nRequired arguments:\n-input: If a directory, -s, -classfiles and -archives are considered\n-output: directory where to put the converted files\n\nRecognized options:\n-verbose, -v: verbose mode (default: off)\n-s : process all subdirectories (default: off)\n-all : process .class and archive files (default)\n-refs : preserve references (default: off)\n-classfiles : process only .class files\n-archives : process only archive files (.jar/.zip)\n-compress: compress resulting archives (default no)\n-keep:private,protected,public,package,synthetic,all,none (default all)\n-skipresourcefiles (default: off)";
        System.err.println(usage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processSingleEntry(String inputFileName, File outputFile, int flags) {
        byte[] bytes;
        block68: {
            File parentFile = outputFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                System.err.println("Could not create " + outputFile);
                return;
            }
            if (Util.isArchive(inputFileName)) {
                if ((flags & 0x4000) != 0) {
                    System.out.println("Process " + inputFileName);
                }
                ZipInputStream inputStream = null;
                ZipOutputStream zipOutputStream = null;
                try {
                    zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                }
                catch (FileNotFoundException e) {
                    ApiPlugin.log(e);
                }
                if (zipOutputStream == null) {
                    System.err.println("Could not create the output file : " + outputFile);
                    return;
                }
                try {
                    try {
                        inputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(inputFileName)));
                        Converter.processArchiveEntry(inputStream, zipOutputStream, flags);
                    }
                    catch (IOException e) {
                        ApiPlugin.log(e);
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if ((flags & 0x4000) != 0) {
                            System.out.println("Dumping " + outputFile);
                        }
                        try {
                            zipOutputStream.flush();
                            zipOutputStream.close();
                            return;
                        }
                        catch (IOException iOException) {}
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if ((flags & 0x4000) != 0) {
                        System.out.println("Dumping " + outputFile);
                    }
                    try {
                        zipOutputStream.flush();
                        zipOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if ((flags & 0x4000) != 0) {
                    System.out.println("Dumping " + outputFile);
                }
                try {
                    zipOutputStream.flush();
                    zipOutputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            InputStream inputStream = null;
            bytes = null;
            try {
                if (Util.isClassFile(inputFileName)) {
                    if ((flags & 0x4000) != 0) {
                        System.out.println("Process " + inputFileName);
                    }
                    inputStream = new BufferedInputStream(new FileInputStream(inputFileName));
                    bytes = Converter.process(inputStream, flags);
                } else if ((flags & 0x8000) != 0) {
                    if ((flags & 0x4000) != 0) {
                        System.out.println("Process resource file : " + inputFileName);
                    }
                    inputStream = new BufferedInputStream(new FileInputStream(inputFileName));
                    bytes = Util.getInputStreamAsByteArray(inputStream, -1);
                } else if ((flags & 0x4000) != 0) {
                    System.out.println("Skip resource file : " + inputFileName);
                }
            }
            catch (FileNotFoundException e) {
                ApiPlugin.log(e);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        ApiPlugin.log(e2);
                    }
                }
                break block68;
            }
            catch (IOException e) {
                try {
                    ApiPlugin.log(e);
                    break block68;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e3) {
                            ApiPlugin.log(e3);
                        }
                    }
                }
            }
            if (inputStream == null) break block68;
            try {
                inputStream.close();
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
        }
        if (bytes == null) return;
        if ((flags & 0x4000) != 0) {
            System.out.println("Dumping " + outputFile);
        }
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
            outputStream.write(bytes);
            outputStream.flush();
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            ApiPlugin.log(e);
            if (outputStream == null) return;
            try {
                outputStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            try {
                ApiPlugin.log(e);
                if (outputStream == null) return;
            }
            catch (Throwable throwable) {
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                outputStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private static void processArchiveEntry(ZipInputStream inputStream, ZipOutputStream zipOutputStream, int flags) throws IOException {
        byte[] bytes = null;
        ZipEntry zipEntry = inputStream.getNextEntry();
        while (zipEntry != null) {
            String name = zipEntry.getName();
            if (Util.isClassFile(name)) {
                if ((flags & 0x4000) != 0) {
                    System.out.println("Process entry : " + name);
                }
                bytes = Converter.process(inputStream, flags);
            } else if (Util.isArchive(name)) {
                if ((flags & 0x4000) != 0) {
                    System.out.println("Process entry : " + name);
                }
                ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ZipOutputStream zipOutputStream2 = new ZipOutputStream(new BufferedOutputStream(byteArrayOutputStream));
                Converter.processArchiveEntry(zipInputStream, zipOutputStream2, flags);
                zipOutputStream2.flush();
                zipOutputStream2.close();
                bytes = byteArrayOutputStream.toByteArray();
            } else if ((flags & 0x8000) != 0) {
                if ((flags & 0x4000) != 0) {
                    System.out.println("Process entry : " + name);
                }
                bytes = Util.getInputStreamAsByteArray(inputStream, (int)zipEntry.getSize());
            } else if ((flags & 0x4000) != 0) {
                System.out.println("Skip entry : " + name);
            }
            if (bytes != null) {
                if ((flags & 0x4000) != 0) {
                    System.out.println("Dump entry : " + name);
                }
                Converter.writeZipFileEntry(zipOutputStream, name, bytes, CRC32, flags);
            }
            inputStream.closeEntry();
            zipEntry = inputStream.getNextEntry();
        }
    }

    private static byte[] process(InputStream inputStream, int flags) throws IOException {
        byte[] contents = Util.getInputStreamAsByteArray(inputStream, -1);
        ClassReader classReader = new ClassReader(contents);
        ClassWriter classWriter = new ClassWriter(0);
        LineNumberMergerClassAdapter classWriter2 = new LineNumberMergerClassAdapter((ClassVisitor)classWriter);
        StubClassAdapter visitor = new StubClassAdapter((ClassVisitor)classWriter2, flags);
        classReader.accept((ClassVisitor)visitor, 4);
        if (visitor.isStub()) {
            return contents;
        }
        if (visitor.shouldIgnore()) {
            return null;
        }
        return classWriter.toByteArray();
    }

    private boolean shouldAbort() {
        return (this.bits & 1) != 0;
    }

    static class LineNumberMergerClassAdapter
    extends ClassAdapter {
        public LineNumberMergerClassAdapter(ClassVisitor visitor) {
            super(visitor);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor visitMethod = super.visitMethod(access, name, desc, signature, exceptions);
            return new LineNumberMergerMethodAdapter(visitMethod);
        }
    }

    static class LineNumberMergerMethodAdapter
    extends MethodAdapter {
        int lastOffset = -1;

        public LineNumberMergerMethodAdapter(MethodVisitor visitor) {
            super(visitor);
        }

        public void visitLineNumber(int line, Label start) {
            int offset = start.getOffset();
            if (offset != this.lastOffset) {
                this.mv.visitLineNumber(line, start);
                this.lastOffset = offset;
            }
        }
    }

    static class ReferencesStubMethodAdapter
    extends MethodNode {
        private final ClassVisitor cv;
        String stringLiteral;
        int line;
        Label label;
        int lastLine = -1;
        boolean hasRefs;

        public ReferencesStubMethodAdapter(ClassVisitor cv, int accessFlags, String methodName, String desc, String signature, String[] exceptions) {
            super(accessFlags, methodName, desc, signature, exceptions);
            this.cv = cv;
            this.hasRefs = false;
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.insertLineEntry();
            super.visitMultiANewArrayInsn(desc, dims);
            this.hasRefs = true;
        }

        public void visitInsn(int opcode) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.insertLineEntry();
            super.visitFieldInsn(opcode, owner, name, desc);
            this.hasRefs = true;
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.insertLineEntry();
            super.visitTypeInsn(opcode, desc);
            this.hasRefs = true;
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                this.insertLineEntry();
                super.visitLdcInsn(cst);
                this.hasRefs = true;
            } else if (cst instanceof String) {
                this.stringLiteral = (String)cst;
            }
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitVarInsn(int opcode, int var) {
            switch (opcode) {
                case 58: {
                    this.insertLineEntry();
                    super.visitVarInsn(opcode, var);
                    this.hasRefs = true;
                }
            }
        }

        public void visitFrame(int type, int local, Object[] local2, int stack, Object[] stack2) {
        }

        protected String processName(String name) {
            String newname = name;
            Type type = Type.getObjectType((String)name);
            if (type != null && type.getSort() == 10) {
                newname = type.getInternalName();
            }
            return newname.replaceAll("/", ".");
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            switch (opcode) {
                case 184: {
                    if (!name.equals("forName") || !this.processName(owner).equals("java.lang.Class") || this.stringLiteral == null) break;
                    super.visitLdcInsn((Object)this.stringLiteral);
                }
            }
            this.stringLiteral = null;
            this.insertLineEntry();
            super.visitMethodInsn(opcode, owner, name, desc);
            this.hasRefs = true;
        }

        private void insertLineEntry() {
            if (this.lastLine != this.line && this.label != null) {
                super.visitLineNumber(this.line, this.label);
                this.lastLine = this.line;
            }
        }

        public void visitLineNumber(int line, Label start) {
            this.line = line;
            this.label = start;
        }

        public void visitEnd() {
            if (this.hasRefs) {
                MethodVisitor mv = this.cv.visitMethod(this.access, this.name, this.desc, this.signature, this.exceptions.toArray(new String[this.exceptions.size()]));
                if (mv != null) {
                    this.accept(mv);
                }
            } else {
                MethodVisitor mv = this.cv.visitMethod(this.access | 0x100, this.name, this.desc, this.signature, this.exceptions.toArray(new String[this.exceptions.size()]));
                if (mv != null) {
                    mv.visitEnd();
                }
            }
        }
    }

    static class StubClassAdapter
    extends ClassAdapter {
        int flags;
        String name;

        public StubClassAdapter(ClassVisitor visitor, int flags) {
            super(visitor);
            this.flags = flags;
        }

        public void visit(int version, int access, String className, String signature, String superName, String[] interfaces) {
            this.name = className;
            this.cv.visit(version, access, className, signature, superName, interfaces);
            this.cv.visitAttribute((Attribute)new StubMarkerAttribute());
        }

        public FieldVisitor visitField(int access, String fieldName, String desc, String signature, Object value) {
            if ((this.flags & 0x200) == 0 && (access & 2) != 0) {
                return null;
            }
            if ((this.flags & 0x400) == 0 && (access & 1) != 0) {
                return null;
            }
            if ((this.flags & 0x800) == 0 && (access & 4) != 0) {
                return null;
            }
            if ((this.flags & 0x1000) == 0 && access == 0) {
                return null;
            }
            if ((this.flags & 0x2000) == 0 && (access & 0x1000) != 0) {
                return null;
            }
            return super.visitField(access, fieldName, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
            boolean reportRefs;
            boolean bl = reportRefs = (this.flags & 8) != 0;
            int accessFlags = (access & 0x400) == 0 ? (reportRefs ? access : access | 0x100) : access;
            if (!reportRefs && "<clinit>".equals(methodName)) {
                return null;
            }
            if ((this.flags & 0x200) == 0 && (access & 2) != 0) {
                return null;
            }
            if ((this.flags & 0x400) == 0 && (access & 1) != 0) {
                return null;
            }
            if ((this.flags & 0x800) == 0 && (access & 4) != 0) {
                return null;
            }
            if ((this.flags & 0x1000) == 0 && access == 0) {
                return null;
            }
            if ((this.flags & 0x2000) == 0 && (access & 0x1000) != 0) {
                return null;
            }
            if (reportRefs) {
                return new ReferencesStubMethodAdapter(this.cv, accessFlags, methodName, desc, signature, exceptions);
            }
            MethodVisitor visitor = super.visitMethod(accessFlags, methodName, desc, signature, exceptions);
            if (visitor != null) {
                visitor.visitEnd();
            }
            return null;
        }

        public void visitInnerClass(String innerClassName, String outerName, String innerName, int access) {
            if ((this.flags & 8) != 0 || outerName != null && innerName != null) {
                super.visitInnerClass(innerClassName, outerName, innerName, access);
            } else if (this.name.equals(innerClassName) && (outerName == null || innerName == null)) {
                this.flags |= 0x100;
            }
        }

        public void visitAttribute(Attribute attr) {
            if ((this.flags & 0x4000) != 0) {
                System.out.println(attr.type);
            }
            if ("Synthetic".equals(attr.type)) {
                this.flags |= 0x100;
            }
            if (Converter.STUB_MARKER_NAME.equals(attr.type)) {
                this.flags |= 0x10000;
            }
            super.visitAttribute(attr);
        }

        public boolean shouldIgnore() {
            return (this.flags & 0x100) != 0;
        }

        public boolean isStub() {
            return (this.flags & 0x10000) != 0;
        }
    }

    static class StubMarkerAttribute
    extends Attribute {
        public StubMarkerAttribute() {
            super(Converter.STUB_MARKER_NAME);
        }

        public boolean isUnknown() {
            return false;
        }

        protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
            return new StubMarkerAttribute();
        }

        protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
            return new ByteVector();
        }
    }
}

