/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.search.ClassFileVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassFileScanner {
    private List references = null;
    private static ClassFileScanner scanner = null;

    private ClassFileScanner() {
    }

    public static ClassFileScanner newScanner() {
        if (scanner == null) {
            scanner = new ClassFileScanner();
        }
        return scanner;
    }

    public List getReferenceListing() {
        if (this.references == null || this.references.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(this.references.size());
        result.addAll(this.references);
        this.references.clear();
        return result;
    }

    public void scan(IApiComponent component, IClassFile classfile, int referenceKinds) throws CoreException {
        if (this.references == null || this.references == Collections.EMPTY_LIST) {
            this.references = new ArrayList(100);
        } else {
            this.references.clear();
        }
        ClassReader reader = new ClassReader(classfile.getContents());
        reader.accept((ClassVisitor)new ClassFileVisitor(component, this.references, referenceKinds), 4);
    }
}

