/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchCriteria;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchEngine;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchResult;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.provisional.search.IReference;
import org.eclipse.pde.api.tools.internal.search.ApiSearchResult;
import org.eclipse.pde.api.tools.internal.search.ClassFileScanner;
import org.eclipse.pde.api.tools.internal.search.LRUMap;
import org.eclipse.pde.api.tools.internal.search.MethodExtractor;
import org.eclipse.pde.api.tools.internal.search.Reference;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class SearchEngine
implements IApiSearchEngine {
    private static boolean DEBUG = Util.DEBUG;
    private static final IApiSearchResult[] EMPTY_RESULT = new IApiSearchResult[0];
    private ClassFileScanner fScanner;
    private MultiStatus fStatus;
    private List[] fPotentialMatches = null;
    private LRUMap fCache = new LRUMap(300);
    private int fHits = 0;
    private int fMiss = 0;
    private IApiSearchCriteria[] fConditions = null;
    private int fAllReferenceKinds = 0;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    private void extractReferences(IApiSearchScope scope, IProgressMonitor monitor) throws CoreException {
        this.fStatus = new MultiStatus("org.eclipse.pde.api.tools", 0, SearchMessages.SearchEngine_1, null);
        this.fScanner = ClassFileScanner.newScanner();
        String[] packageNames = scope.getPackageNames();
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)packageNames.length);
        Visitor visitor = new Visitor((IProgressMonitor)localMonitor);
        long start = System.currentTimeMillis();
        try {
            scope.accept(visitor);
        }
        catch (CoreException e) {
            this.fStatus.add(e.getStatus());
        }
        long end = System.currentTimeMillis();
        if (!this.fStatus.isOK()) {
            throw new CoreException((IStatus)this.fStatus);
        }
        localMonitor.done();
        if (DEBUG) {
            int size = 0;
            int i = 0;
            while (i < this.fPotentialMatches.length) {
                size += this.fPotentialMatches[i].size();
                ++i;
            }
            System.out.println("Search: extracted " + size + " references in " + (end - start) + "ms");
        }
    }

    private String createSignatureKey(ILocation source, ILocation target) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(source.getApiComponent().getId());
        buffer.append("#");
        buffer.append(target.getType().getQualifiedName());
        IMemberDescriptor member = target.getMember();
        if (!(member instanceof IReferenceTypeDescriptor)) {
            buffer.append("#");
            buffer.append(member.getName());
            buffer.append("#");
            if (member instanceof IMethodDescriptor) {
                buffer.append(((IMethodDescriptor)member).getSignature());
            }
        }
        return buffer.toString();
    }

    private void resolveReferences(List[] referenceLists, IProgressMonitor monitor) throws CoreException {
        this.fHits = 0;
        this.fMiss = 0;
        HashMap<String, ArrayList<IReference>> sigtoref = new HashMap<String, ArrayList<IReference>>(50);
        ArrayList<IReference> refs = null;
        IReference ref = null;
        String key = null;
        ArrayList<IReference> methodDecls = new ArrayList<IReference>(1000);
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < referenceLists.length) {
            Iterator references = referenceLists[i].iterator();
            while (references.hasNext()) {
                ref = (IReference)references.next();
                if (ref.getReferenceKind() == 0x10000000) {
                    methodDecls.add(ref);
                    continue;
                }
                key = this.createSignatureKey(ref.getSourceLocation(), ref.getReferencedLocation());
                refs = (ArrayList<IReference>)sigtoref.get(key);
                if (refs == null) {
                    refs = new ArrayList<IReference>(20);
                    sigtoref.put(key, refs);
                }
                refs.add(ref);
            }
            ++i;
        }
        if (monitor.isCanceled()) {
            return;
        }
        long end = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("Search: split into " + methodDecls.size() + " method overrides and " + sigtoref.size() + " unique references (" + (end - start) + "ms)");
        }
        start = System.currentTimeMillis();
        this.resolveReferenceSets(sigtoref, monitor);
        end = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("Search: resolved unique references in " + (end - start) + "ms");
        }
        start = System.currentTimeMillis();
        Iterator iterator = methodDecls.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            reference.resolve(this);
        }
        end = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("Search: resolved method overrides in " + (end - start) + "ms");
            System.out.println("Search: class file method info cache hits: " + this.fHits + " misses: " + this.fMiss);
        }
        this.fCache.clear();
    }

    MethodExtractor getExtraction(IClassFile file) throws CoreException {
        MethodExtractor extractor = (MethodExtractor)this.fCache.get(file.getTypeName());
        if (extractor == null) {
            extractor = new MethodExtractor();
            ClassReader reader = new ClassReader(file.getContents());
            reader.accept((ClassVisitor)extractor, 5);
            this.fCache.put(file.getTypeName(), extractor);
            ++this.fMiss;
        } else {
            ++this.fHits;
        }
        return extractor;
    }

    private void resolveReferenceSets(Map map, IProgressMonitor monitor) throws CoreException {
        Iterator types = map.keySet().iterator();
        String key = null;
        List refs = null;
        IReference ref = null;
        while (types.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            key = (String)types.next();
            refs = (List)map.get(key);
            ref = (IReference)refs.get(0);
            ((Reference)ref).resolve(this);
            IApiAnnotations resolved = ref.getResolvedAnnotations();
            if (resolved == null) continue;
            Iterator iterator = refs.iterator();
            while (iterator.hasNext()) {
                Reference ref2 = (Reference)iterator.next();
                ref2.setResolution(resolved, ref.getResolvedLocation());
            }
        }
    }

    public IApiSearchResult[] search(IApiSearchScope sourceScope, IApiSearchCriteria[] conditions, IProgressMonitor monitor) throws CoreException {
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.SearchEngine_2, (int)3);
        this.fConditions = conditions;
        this.fPotentialMatches = new List[this.fConditions.length];
        int i = 0;
        while (i < conditions.length) {
            IApiSearchCriteria condition = conditions[i];
            this.fAllReferenceKinds |= condition.getReferenceKinds();
            this.fPotentialMatches[i] = new LinkedList();
            ++i;
        }
        localMonitor.subTask(SearchMessages.SearchEngine_3);
        this.extractReferences(sourceScope, (IProgressMonitor)localMonitor);
        localMonitor.worked(1);
        if (localMonitor.isCanceled()) {
            return EMPTY_RESULT;
        }
        localMonitor.subTask(SearchMessages.SearchEngine_3);
        this.resolveReferences(this.fPotentialMatches, (IProgressMonitor)localMonitor);
        localMonitor.worked(1);
        if (localMonitor.isCanceled()) {
            return EMPTY_RESULT;
        }
        localMonitor.subTask(SearchMessages.SearchEngine_3);
        int emptyrefs = 0;
        int i2 = 0;
        while (i2 < this.fPotentialMatches.length) {
            List references = this.fPotentialMatches[i2];
            if (!references.isEmpty()) {
                IApiSearchCriteria condition = this.fConditions[i2];
                this.applyConditions(references, condition);
                if (references.isEmpty()) {
                    ++emptyrefs;
                }
            } else {
                ++emptyrefs;
            }
            if (localMonitor.isCanceled()) {
                return EMPTY_RESULT;
            }
            ++i2;
        }
        int size = this.fPotentialMatches.length - emptyrefs;
        if (size <= 0) {
            return EMPTY_RESULT;
        }
        IApiSearchResult[] results = new IApiSearchResult[size];
        int index = 0;
        int i3 = 0;
        while (i3 < this.fPotentialMatches.length) {
            List references = this.fPotentialMatches[i3];
            if (!references.isEmpty()) {
                results[index++] = new ApiSearchResult(this.fConditions[i3], references.toArray(new IReference[references.size()]));
                references.clear();
            }
            ++i3;
        }
        this.fCache.clear();
        this.fPotentialMatches = null;
        localMonitor.worked(1);
        localMonitor.done();
        return results;
    }

    private void applyConditions(List references, IApiSearchCriteria condition) {
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            IReference ref = (IReference)iterator.next();
            if (condition.isMatch(ref)) continue;
            iterator.remove();
        }
    }

    public void resolveReferences(IReference[] references, IProgressMonitor monitor) throws CoreException {
        ArrayList<IReference> list = new ArrayList<IReference>(references.length);
        int i = 0;
        while (i < references.length) {
            list.add(references[i]);
            ++i;
        }
        this.resolveReferences(new List[]{list}, monitor);
    }

    class Visitor
    extends ClassFileContainerVisitor {
        private IApiComponent fCurrentComponent = null;
        private IProgressMonitor fMonitor = null;

        public Visitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void end(IApiComponent component) {
            this.fCurrentComponent = null;
        }

        public boolean visit(IApiComponent component) {
            this.fCurrentComponent = component;
            return true;
        }

        public boolean visitPackage(String packageName) {
            this.fMonitor.subTask(MessageFormat.format((String)SearchMessages.SearchEngine_0, (Object[])new String[]{packageName}));
            return true;
        }

        public void endVisitPackage(String packageName) {
            this.fMonitor.worked(1);
        }

        public void visit(String packageName, IClassFile classFile) {
            if (!this.fMonitor.isCanceled()) {
                try {
                    SearchEngine.this.fScanner.scan(this.fCurrentComponent, classFile, SearchEngine.this.fAllReferenceKinds);
                    List references = SearchEngine.this.fScanner.getReferenceListing();
                    Iterator iterator = references.iterator();
                    while (iterator.hasNext()) {
                        IReference ref = (IReference)iterator.next();
                        int i = 0;
                        while (i < SearchEngine.this.fConditions.length) {
                            if (SearchEngine.this.fConditions[i].isPotentialMatch(ref)) {
                                SearchEngine.this.fPotentialMatches[i].add(ref);
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    SearchEngine.this.fStatus.add(e.getStatus());
                }
            }
        }
    }
}

