/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.provisional.search.IReference;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLFactory {
    public static final String ATTR_METHOD_SIGNATURE = "methodSignature";
    public static final String ATTR_METHOD = "method";
    public static final String ATTR_FIELD = "field";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_PACKAGE = "package";
    public static final String ATTR_LINE_NUMBER = "lineNumber";
    public static final String ATTR_RESTRICTIONS = "restrictions";
    public static final String ATTR_VISIBILITY = "visibility";
    public static final String ATTR_COMPONENT = "component";
    public static final String ELEMENT_TARGET = "target";
    public static final String ELEMENT_ORIGIN = "origin";
    public static final String ELEMENT_REFERNCES = "references";
    public static final String ELEMENT_REFERNCE = "reference";
    public static final String ATTR_KIND = "kind";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Element serializeElement(IReference reference, Document document) {
        Element element = document.createElement(ELEMENT_REFERNCE);
        int n = reference.getReferenceKind();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.api.tools.internal.provisional.search.ReferenceModifiers");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        element.setAttribute(ATTR_KIND, XMLFactory.toString(n, clazz, null));
        ILocation origin = reference.getSourceLocation();
        Element child = XMLFactory.serializeLocation(ELEMENT_ORIGIN, origin.getApiComponent().getId(), origin.getMember(), origin.getLineNumber(), null, document);
        element.appendChild(child);
        ILocation target = reference.getResolvedLocation();
        child = XMLFactory.serializeLocation(ELEMENT_TARGET, target.getApiComponent().getId(), target.getMember(), -1, reference.getResolvedAnnotations(), document);
        element.appendChild(child);
        return element;
    }

    private static Element serializeLocation(String nodeName, String componentId, IMemberDescriptor element, int lineNumber, IApiAnnotations annotation, Document document) {
        Element node = document.createElement(nodeName);
        if (componentId != null) {
            node.setAttribute(ATTR_COMPONENT, componentId);
        }
        if (annotation != null) {
            int n = annotation.getVisibility();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            node.setAttribute(ATTR_VISIBILITY, XMLFactory.toString(n, clazz, null));
            int n2 = annotation.getRestrictions();
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            node.setAttribute(ATTR_RESTRICTIONS, XMLFactory.toString(n2, clazz2, "NO_RESTRICTIONS"));
        }
        if (lineNumber >= 0) {
            node.setAttribute(ATTR_LINE_NUMBER, Integer.toString(lineNumber));
        }
        node.setAttribute(ATTR_PACKAGE, element.getPackage().getName());
        if (element instanceof IReferenceTypeDescriptor) {
            node.setAttribute(ATTR_TYPE, ((IReferenceTypeDescriptor)element).getName());
        } else {
            node.setAttribute(ATTR_TYPE, element.getEnclosingType().getName());
            if (element instanceof IFieldDescriptor) {
                node.setAttribute(ATTR_FIELD, element.getName());
            } else if (element instanceof IMethodDescriptor) {
                node.setAttribute(ATTR_METHOD, element.getName());
                node.setAttribute(ATTR_METHOD_SIGNATURE, ((IMethodDescriptor)element).getSignature());
            }
        }
        return node;
    }

    private static String toString(int modifiers, Class clazz, String emptyValue) {
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException e) {
            ApiPlugin.log(e);
        }
        catch (IllegalAccessException e) {
            ApiPlugin.log(e);
        }
        StringBuffer buffer = new StringBuffer();
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (Modifier.isPublic(field.getModifiers()) && field.getType() == Integer.TYPE) {
                try {
                    int flag = field.getInt(obj);
                    if (flag != 0 && (flag & modifiers) == flag) {
                        XMLFactory.append(buffer, field.getName());
                    }
                }
                catch (IllegalArgumentException e) {
                    ApiPlugin.log(e);
                }
                catch (IllegalAccessException e) {
                    ApiPlugin.log(e);
                }
            }
            ++i;
        }
        if (buffer.length() == 0 && emptyValue != null) {
            return emptyValue;
        }
        return buffer.toString();
    }

    private static void append(StringBuffer buffer, String modifier) {
        if (buffer.length() > 0) {
            buffer.append(',');
        }
        buffer.append(modifier);
    }

    public static Document serializeReferences(IReference[] references) throws CoreException {
        Document document = Util.newDocument();
        Element root = document.createElement(ELEMENT_REFERNCES);
        document.appendChild(root);
        int i = 0;
        while (i < references.length) {
            Element child = XMLFactory.serializeElement(references[i], document);
            root.appendChild(child);
            ++i;
        }
        return document;
    }
}

