/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.tools.ApiExtractorAdapter;
import org.eclipse.pde.api.tools.internal.tools.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JREApiCollector {
    private static boolean DEBUG = false;
    private static final String PROFILE = "-profile";
    private static final String JRE_LOCATION = "-jre";
    private static final String OUTPUT = "-output";
    private static final String PACKAGE_PROPERTY = "org.osgi.framework.system.packages";
    String jreLocation;
    String jreProfile;
    String output;

    static {
        DEBUG = DEBUG || System.getProperty("DEBUG") != null;
    }

    public static void main(String[] args) {
        JREApiCollector apiCollector = new JREApiCollector();
        apiCollector.configure(args);
        apiCollector.run();
    }

    public void configure(String[] args) {
        int mode = 0;
        int i = 0;
        int max = args.length;
        while (i < max) {
            String currentArg = args[i];
            switch (mode) {
                case 0: {
                    if (PROFILE.equals(currentArg)) {
                        mode = 1;
                        break;
                    }
                    if (JRE_LOCATION.equals(currentArg)) {
                        mode = 2;
                        break;
                    }
                    if (OUTPUT.equals(currentArg)) {
                        mode = 3;
                        break;
                    }
                    System.err.println("Unknown option : " + currentArg);
                    break;
                }
                case 1: {
                    if (this.jreProfile != null) {
                        throw new IllegalArgumentException("Cannot set the jre profile value more than once");
                    }
                    this.jreProfile = currentArg;
                    mode = 0;
                    break;
                }
                case 3: {
                    if (this.output != null) {
                        throw new IllegalArgumentException("Cannot set the output value more than once");
                    }
                    this.output = currentArg;
                    mode = 0;
                    break;
                }
                case 2: {
                    if (this.jreLocation != null) {
                        throw new IllegalArgumentException("Cannot set the jre location value more than once");
                    }
                    this.jreLocation = currentArg;
                    mode = 0;
                }
            }
            ++i;
        }
        if (this.jreProfile == null || this.jreLocation == null || this.output == null) {
            this.printUsage();
            throw new IllegalArgumentException("Missing arguments");
        }
    }

    private void printUsage() {
        System.out.println("Usage: JREApiCollector -profile <path> -jre <path to jre home directory -output <path to output file>");
    }

    private void run() {
        File profileFile = new File(this.jreProfile);
        if (!profileFile.exists()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.noProfile, (Object)this.jreProfile));
        }
        File outputFile = new File(this.output);
        if (outputFile.exists()) {
            if (!outputFile.delete()) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.cannotDeleteOutputFile, (Object)this.output));
            }
        } else {
            File parent = outputFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.cannotCreateOutputFileParent, (Object)parent.getAbsolutePath()));
            }
        }
        Properties properties = new Properties();
        try {
            FileInputStream stream = new FileInputStream(profileFile);
            properties.load(stream);
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String property = properties.getProperty(PACKAGE_PROPERTY);
        if (property == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.cannotCreateOutputFileParent, (Object)PACKAGE_PROPERTY));
        }
        if (DEBUG) {
            System.out.println(property);
        }
        HashSet<String> packagesNames = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(property, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            packagesNames.add(token.trim());
        }
        File jreHome = new File(this.jreLocation);
        if (!jreHome.exists()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.noJRELocation, (Object)this.jreLocation));
        }
        File[] files = Util.getAllFiles(jreHome, new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || Util.isArchive(pathname.getName());
            }
        });
        if (files != null && files.length != 0) {
            HashSet collector;
            block24: {
                collector = new HashSet();
                int i = 0;
                int max = files.length;
                while (i < max) {
                    this.collectClassFiles(files[i], packagesNames, collector);
                    ++i;
                }
                ArrayList list = new ArrayList();
                list.addAll(collector);
                Collections.sort(list);
                FileWriter fileWriter = null;
                PrintWriter writer = null;
                try {
                    try {
                        fileWriter = new FileWriter(this.output);
                        writer = new PrintWriter(fileWriter);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            writer.println(iterator.next());
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (writer != null) {
                            writer.close();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        writer.close();
                    }
                    throw throwable;
                }
                if (writer != null) {
                    writer.close();
                }
            }
            HashSet set = new HashSet();
            set.addAll(collector);
            if (DEBUG) {
                System.out.println(NLS.bind((String)Messages.numberOfElements, (Object)Integer.toString(collector.size())));
                System.out.println(NLS.bind((String)Messages.numberOfUniqueElements, (Object)Integer.toString(set.size())));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void collectClassFiles(File file, Set packagesNames, Set collector) {
        if (DEBUG) {
            System.out.println(file.getAbsolutePath());
        }
        ZipInputStream inputStream = null;
        try {
            try {
                inputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.processArchiveEntry(inputStream, packagesNames, collector);
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void processArchiveEntry(ZipInputStream inputStream, Set packageNames, Set collector) throws IOException {
        ZipEntry zipEntry = inputStream.getNextEntry();
        while (zipEntry != null) {
            String name = zipEntry.getName();
            String packageName = this.getPackageName(name);
            if (Util.isClassFile(name) && this.includesPackage(packageNames, packageName)) {
                this.extractApis(inputStream, collector);
            }
            inputStream.closeEntry();
            zipEntry = inputStream.getNextEntry();
        }
    }

    private boolean includesPackage(Set packageNames, String packageName) {
        return packageNames.contains(packageName) || packageName.startsWith("java.");
    }

    private void extractApis(InputStream inputStream, Set collector) throws IOException {
        byte[] contents = Util.getInputStreamAsByteArray(inputStream, -1);
        ClassReader classReader = new ClassReader(contents);
        ApiExtractorAdapter visitor = new ApiExtractorAdapter(collector);
        classReader.accept((ClassVisitor)visitor, 7);
    }

    private String getPackageName(String name) {
        int index = name.lastIndexOf(47);
        if (index != -1) {
            return name.substring(0, index).replace('/', '.');
        }
        return "";
    }
}

