/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.AbstractModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;

public class ExternalModelManager
extends AbstractModelManager {
    private IPluginModelBase[] fModels = new IPluginModelBase[0];

    protected IPluginModelBase[] getAllModels() {
        return this.fModels;
    }

    protected void initializeModels(IPluginModelBase[] models) {
        block4: {
            String saved;
            block3: {
                this.fModels = models;
                Preferences pref = PDECore.getDefault().getPluginPreferences();
                saved = pref.getString("checkedPlugins");
                if (!saved.equals("[savedAll]")) break block3;
                int i = 0;
                while (i < this.fModels.length) {
                    this.fModels[i].setEnabled(true);
                    ++i;
                }
                break block4;
            }
            if (saved.equals("[savedNone]")) break block4;
            Vector<String> result = new Vector<String>();
            StringTokenizer stok = new StringTokenizer(saved);
            while (stok.hasMoreTokens()) {
                result.add(stok.nextToken());
            }
            int i = 0;
            while (i < this.fModels.length) {
                this.fModels[i].setEnabled(!result.contains(this.fModels[i].getPluginBase().getId()));
                ++i;
            }
        }
    }

    public void setModels(IPluginModelBase[] models) {
        this.fModels = models;
    }

    protected URL[] getPluginPaths() {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        URL[] base = PluginPathFinder.getPluginPaths(pref.getString("platform_path"));
        String value = pref.getString("additional_locations");
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() == 0) {
            return base;
        }
        File[] extraLocations = new File[tokenizer.countTokens()];
        int i = 0;
        while (i < extraLocations.length) {
            String location = tokenizer.nextToken();
            File dir = new File(location, "plugins");
            if (!dir.exists() || !dir.isDirectory()) {
                dir = new File(location);
            }
            extraLocations[i] = dir;
            ++i;
        }
        URL[] additional = PluginPathFinder.scanLocations(extraLocations);
        if (additional.length == 0) {
            return base;
        }
        URL[] result = new URL[base.length + additional.length];
        System.arraycopy(base, 0, result, 0, base.length);
        System.arraycopy(additional, 0, result, base.length, additional.length);
        return result;
    }
}

