/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.plugin.PluginBase;

public class P2Utils {
    private static final String SRC_BUNDLE_TXT_FOLDER = "org.eclipse.equinox.source";
    private static final String BUNDLE_TXT_FOLDER = "org.eclipse.equinox.simpleconfigurator";
    private static final String SRC_BUNDLE_TXT_PATH = "org.eclipse.equinox.source" + File.separator + "source.info";
    private static final String BUNDLE_TXT_PATH = "org.eclipse.equinox.simpleconfigurator" + File.separator + "bundles.info";
    public static final String P2_FLAVOR_DEFAULT = "tooling";

    public static URL[] readBundlesTxt(String platformHome, URL configurationArea) {
        List bundles;
        Path basePath;
        block7: {
            URL bundlesTxt;
            block6: {
                basePath = new Path(platformHome);
                if (configurationArea == null) {
                    return null;
                }
                try {
                    bundlesTxt = new URL(configurationArea.getProtocol(), configurationArea.getHost(), configurationArea.getFile().concat(BUNDLE_TXT_PATH));
                    File file = P2Utils.toFile(bundlesTxt);
                    if (file != null && file.exists()) break block6;
                    return null;
                }
                catch (MalformedURLException e) {
                    PDECore.log(e);
                    return null;
                }
            }
            bundles = P2Utils.getBundlesFromFile(bundlesTxt, basePath);
            if (bundles != null) break block7;
            return null;
        }
        URL srcBundlesTxt = new URL(configurationArea.getProtocol(), configurationArea.getHost(), configurationArea.getFile().concat(SRC_BUNDLE_TXT_PATH));
        List srcBundles = P2Utils.getBundlesFromFile(srcBundlesTxt, basePath);
        if (srcBundles != null) {
            bundles.addAll(srcBundles);
        }
        return bundles.toArray(new URL[bundles.size()]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List getBundlesFromFile(URL fileURL, Path basePath) {
        bundles = new ArrayList<URL>();
        try {
            r = new BufferedReader(new InputStreamReader(fileURL.openStream()));
            try {
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0 || line.startsWith("org.eclipse.equinox.simpleconfigurator.baseUrl=")) continue;
                    tok = new StringTokenizer(line, ",", true);
                    symbolicName = tok.nextToken();
                    if (symbolicName.equals(",")) {
                        symbolicName = null;
                    } else {
                        tok.nextToken();
                    }
                    version = tok.nextToken();
                    if (version.equals(",")) {
                        version = null;
                    } else {
                        tok.nextToken();
                    }
                    urlSt = tok.nextToken();
                    if (urlSt.equals(",")) {
                        urlSt = symbolicName != null && version != null ? String.valueOf(symbolicName) + "_" + version + ".jar" : null;
                    } else {
                        tok.nextToken();
                    }
                    try {
                        bundleUrl = new URL(urlSt);
                        path = new Path(bundleUrl.getFile());
                        if (!path.isAbsolute()) {
                            urlSt = basePath.append((IPath)path).toOSString();
                            bundleUrl = new URL("file:" + urlSt);
                        }
                        bundles.add(bundleUrl);
                    }
                    catch (MalformedURLException v0) {}
                    ** GOTO lbl-1000
                    tok.nextToken();
                    tok.nextToken();
                    tok.nextToken();
                }
                try {
                    r.close();
                    return bundles;
                }
                catch (IOException v1) {
                    return null;
                }
lbl-1000:
                // 2 sources

                {
                    while (true) {
                        try {
                            r.close();
                            return null;
                        }
                        catch (IOException v2) {
                            return null;
                        }
                        break;
                    }
                }
            }
            catch (IOException v3) {
                ** continue;
            }
            catch (Throwable var11_13) {
                try {
                    r.close();
                    throw var11_13;
                }
                catch (IOException v4) {
                    return null;
                }
            }
        }
        catch (MalformedURLException e) {
            PDECore.log(e);
            return null;
        }
        catch (IOException e) {
            PDECore.log(e);
            return null;
        }
    }

    public static URL writeBundlesTxt(Map bundles, int defaultStartLevel, boolean defaultAutoStart, File directory) {
        if (bundles.size() == 0) {
            return null;
        }
        File bundlesTxt = new File(directory, BUNDLE_TXT_PATH);
        File srcBundlesTxt = new File(directory, SRC_BUNDLE_TXT_PATH);
        BufferedWriter out = null;
        BufferedWriter srcOut = null;
        try {
            try {
                new File(directory, SRC_BUNDLE_TXT_FOLDER).mkdirs();
                new File(directory, BUNDLE_TXT_FOLDER).mkdirs();
                bundlesTxt.createNewFile();
                srcBundlesTxt.createNewFile();
                out = new BufferedWriter(new FileWriter(bundlesTxt));
                srcOut = new BufferedWriter(new FileWriter(srcBundlesTxt));
                Iterator iterator = bundles.keySet().iterator();
                while (iterator.hasNext()) {
                    String auto;
                    File location;
                    String installLocation;
                    String modelName;
                    IPluginModelBase currentModel = (IPluginModelBase)iterator.next();
                    IPluginBase base = currentModel.getPluginBase();
                    if (base instanceof PluginBase && ((PluginBase)base).getBundleSourceEntry() != null) {
                        modelName = base.getId();
                        srcOut.write(modelName);
                        srcOut.write(44);
                        srcOut.write(base.getVersion());
                        srcOut.write(44);
                        installLocation = currentModel.getInstallLocation();
                        if (installLocation != null) {
                            location = new File(installLocation);
                            try {
                                srcOut.write(location.toURL().toString());
                            }
                            catch (MalformedURLException e) {
                                PDECore.log(e);
                            }
                        } else {
                            PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", "While creating source.info, could not find the bundle location for bundle " + currentModel));
                        }
                        srcOut.write(",-1,false");
                        srcOut.newLine();
                        continue;
                    }
                    if (base == null) continue;
                    modelName = base.getId();
                    out.write(modelName);
                    out.write(44);
                    out.write(base.getVersion());
                    out.write(44);
                    installLocation = currentModel.getInstallLocation();
                    if (installLocation != null) {
                        location = new File(installLocation);
                        try {
                            out.write(location.toURL().toString());
                        }
                        catch (MalformedURLException e) {
                            PDECore.log(e);
                        }
                    } else {
                        PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", "While creating bundles.info, could not find the bundle location for bundle " + currentModel));
                    }
                    out.write(44);
                    String currentLevel = (String)bundles.get(currentModel);
                    int index = currentLevel.indexOf(58);
                    String level = index > 0 ? currentLevel.substring(0, index) : "default";
                    String string = auto = index > 0 && index < currentLevel.length() - 1 ? currentLevel.substring(index + 1) : "default";
                    if ("default".equals(auto)) {
                        auto = Boolean.toString(defaultAutoStart);
                    }
                    if ("default".equals(level)) {
                        level = Integer.toString(defaultStartLevel);
                    }
                    out.write(level);
                    out.write(44);
                    out.write(auto);
                    out.newLine();
                }
                out.flush();
                out.close();
                srcOut.flush();
                srcOut.close();
            }
            catch (IOException e) {
                PDECore.logException(e);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (srcOut != null) {
                    try {
                        srcOut.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (srcOut != null) {
                try {
                    srcOut.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        if (srcOut != null) {
            try {
                srcOut.close();
            }
            catch (IOException iOException) {}
        }
        if (!bundlesTxt.exists()) {
            return null;
        }
        try {
            return bundlesTxt.toURL();
        }
        catch (MalformedURLException e) {
            PDECore.logException(e);
            return null;
        }
    }

    public static URL writeBundlesTxt(Collection bundles, String osgiBundleList, File directory) {
        HashMap<String, String> osgiStartLevels = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(osgiBundleList, ",");
        while (tokenizer.hasMoreTokens()) {
            String auto;
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            if (index == -1) continue;
            String modelName = token.substring(0, index);
            String startData = token.substring(index + 1);
            String level = (index = startData.indexOf(58)) > 0 ? startData.substring(0, index) : "default";
            String string = auto = index > 0 && index < startData.length() - 1 ? startData.substring(index + 1) : "default";
            if ("start".equals(auto)) {
                auto = "true";
            }
            osgiStartLevels.put(modelName, String.valueOf(level) + ':' + auto);
        }
        String defaultAppend = "default:default";
        HashMap bundleMap = new HashMap(bundles.size());
        Iterator iterator = bundles.iterator();
        while (iterator.hasNext()) {
            IPluginModelBase currentModel = (IPluginModelBase)iterator.next();
            BundleDescription desc = currentModel.getBundleDescription();
            if (desc == null) continue;
            String modelName = desc.getSymbolicName();
            if (modelName != null && osgiStartLevels.containsKey(modelName)) {
                bundleMap.put(currentModel, osgiStartLevels.get(modelName));
                continue;
            }
            if (BUNDLE_TXT_FOLDER.equals(modelName)) {
                bundleMap.put(currentModel, "1:true");
                continue;
            }
            if ("org.eclipse.equinox.common".equals(modelName)) {
                bundleMap.put(currentModel, "2:true");
                continue;
            }
            if ("org.eclipse.osgi".equals(modelName)) {
                bundleMap.put(currentModel, "-1:true");
                continue;
            }
            if ("org.eclipse.update.configurator".equals(modelName)) {
                bundleMap.put(currentModel, "3:true");
                continue;
            }
            if ("org.eclipse.core.runtime".equals(modelName)) {
                if (TargetPlatformHelper.getTargetVersion() > 3.1) {
                    bundleMap.put(currentModel, "default:true");
                    continue;
                }
                bundleMap.put(currentModel, "2:true");
                continue;
            }
            bundleMap.put(currentModel, defaultAppend);
        }
        return P2Utils.writeBundlesTxt(bundleMap, 4, false, directory);
    }

    public static File toFile(URL url) {
        block3: {
            try {
                if ("file".equalsIgnoreCase(url.getProtocol())) break block3;
                return null;
            }
            catch (Exception exception) {
                return new File(url.getFile());
            }
        }
        return new File(new URI(url.toExternalForm()));
    }
}

