/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.exports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.w3c.dom.Element;

public class ProductExportOperation
extends FeatureExportOperation {
    private String fFeatureLocation;
    private String fRoot;
    private IProduct fProduct;

    public ProductExportOperation(FeatureExportInfo info, IProduct product, String root) {
        super(info);
        this.fProduct = product;
        this.fRoot = root;
    }

    /*
     * Exception decompiling
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String[] getPaths() {
        String[] paths = super.getPaths();
        String[] all = new String[paths.length + 1];
        all[0] = String.valueOf(this.fFeatureLocation) + File.separator + "feature.xml";
        System.arraycopy(paths, 0, all, 1, paths.length);
        return all;
    }

    private void createBuildPropertiesFile(String featureLocation, String[] config) {
        IJREInfo jreInfo;
        File vm;
        File file = new File(featureLocation);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        boolean hasLaunchers = PDECore.getDefault().getFeatureModelManager().getDeltaPackFeature() != null;
        Properties properties = new Properties();
        properties.put("root", this.getRootFileLocations(hasLaunchers));
        if (!hasLaunchers) {
            properties.put("root.permissions.755", this.getLauncherName());
            if (TargetPlatform.getWS().equals("motif") && TargetPlatform.getOS().equals("linux")) {
                properties.put("root.linux.motif.x86.permissions.755", "libXm.so.2");
            } else if (TargetPlatform.getOS().equals("macosx")) {
                properties.put("root.macosx.carbon.ppc.permissions.755", "${launcherName}.app/Contents/MacOS/${launcherName}");
            }
        }
        File file2 = vm = (jreInfo = this.fProduct.getJREInfo()) != null ? jreInfo.getJVMLocation(config[0]) : null;
        if (vm != null) {
            properties.put("root." + config[0] + "." + config[1] + "." + config[2] + ".folder.jre", "absolute:" + vm.getAbsolutePath());
            String perms = (String)properties.get("root.permissions.755");
            if (perms != null) {
                StringBuffer buffer = new StringBuffer(perms);
                buffer.append(",");
                buffer.append("jre/bin/java");
                properties.put("root.permissions.755", buffer.toString());
            }
        }
        this.save(new File(file, "build.properties"), properties, "Build Configuration");
    }

    private String getRootFileLocations(boolean hasLaunchers) {
        StringBuffer buffer = new StringBuffer();
        File homeDir = new File(TargetPlatform.getLocation());
        if (!hasLaunchers && homeDir.exists() && homeDir.isDirectory()) {
            this.appendAbsolutePath(buffer, new File(homeDir, "startup.jar"));
            if (!TargetPlatform.getOS().equals("macosx")) {
                File file = null;
                if (System.getProperties().get("eclipse.launcher") != null) {
                    String launcherPath = System.getProperties().get("eclipse.launcher").toString();
                    file = new File(launcherPath);
                    if (file.exists() && !file.isDirectory()) {
                        this.appendAbsolutePath(buffer, file);
                    } else {
                        this.appendEclipsePath(buffer, homeDir);
                    }
                } else {
                    this.appendEclipsePath(buffer, homeDir);
                }
                file = new File(homeDir, "libXm.so.2");
                if (file.exists()) {
                    this.appendAbsolutePath(buffer, file);
                }
            }
        }
        return buffer.toString();
    }

    private void appendEclipsePath(StringBuffer buffer, File homeDir) {
        File file = null;
        file = new File(homeDir, "eclipse");
        if (file.exists()) {
            this.appendAbsolutePath(buffer, file);
        }
        if ((file = new File(homeDir, "eclipse.exe")).exists()) {
            this.appendAbsolutePath(buffer, file);
        }
    }

    private void appendAbsolutePath(StringBuffer buffer, File file) {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append("absolute:file:");
        buffer.append(file.getAbsolutePath());
    }

    protected HashMap createAntBuildProperties(String os, String ws, String arch) {
        HashMap properties = super.createAntBuildProperties(os, ws, arch);
        properties.put("launcherName", this.getLauncherName());
        ILauncherInfo info = this.fProduct.getLauncherInfo();
        if (info != null) {
            String images = null;
            if (os.equals("win32")) {
                images = this.getWin32Images(info);
            } else if (os.equals("solaris")) {
                images = this.getSolarisImages(info);
            } else if (os.equals("linux")) {
                images = this.getExpandedPath(info.getIconPath("linuxIcon"));
            } else if (os.equals("macosx")) {
                images = this.getExpandedPath(info.getIconPath("macosxIcon"));
            }
            if (images != null && images.length() > 0) {
                properties.put("launcherIcons", images);
            }
        }
        this.fAntBuildProperties.put("collectingFolder", this.fRoot);
        this.fAntBuildProperties.put("archivePrefix", this.fRoot);
        return properties;
    }

    protected void setP2MetaDataProperties(Map map) {
        if (this.fInfo.exportMetadata) {
            map.put("generate.p2.metadata", "true");
            map.put("p2.flavor", "tooling");
            map.put("p2.publish.artifacts", "true");
            try {
                map.put("p2.metadata.repo", new File(String.valueOf(this.fInfo.destinationDirectory) + "/repository").toURL().toString());
                map.put("p2.artifact.repo", new File(String.valueOf(this.fInfo.destinationDirectory) + "/repository").toURL().toString());
            }
            catch (MalformedURLException e) {
                PDECore.log(e);
            }
        }
    }

    private String getLauncherName() {
        String name;
        ILauncherInfo info = this.fProduct.getLauncherInfo();
        if (info != null && (name = info.getLauncherName()) != null && name.length() > 0) {
            if ((name = name.trim()).endsWith(".exe")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
        return "eclipse";
    }

    private String getWin32Images(ILauncherInfo info) {
        StringBuffer buffer = new StringBuffer();
        if (info.usesWinIcoFile()) {
            this.append(buffer, info.getIconPath("icoFile"));
        } else {
            this.append(buffer, info.getIconPath("winSmallLow"));
            this.append(buffer, info.getIconPath("winSmallHigh"));
            this.append(buffer, info.getIconPath("winMediumHigh"));
            this.append(buffer, info.getIconPath("winMediumLow"));
            this.append(buffer, info.getIconPath("winLargeHigh"));
            this.append(buffer, info.getIconPath("winLargeLow"));
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    private String getSolarisImages(ILauncherInfo info) {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer, info.getIconPath("solarisLarge"));
        this.append(buffer, info.getIconPath("solarisMedium"));
        this.append(buffer, info.getIconPath("solarisSmall"));
        this.append(buffer, info.getIconPath("solarisTiny"));
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    private void append(StringBuffer buffer, String path) {
        if ((path = this.getExpandedPath(path)) != null) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(path);
        }
    }

    private String getExpandedPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        IResource resource = PDECore.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (resource != null) {
            IPath fullPath = resource.getLocation();
            return fullPath == null ? null : fullPath.toOSString();
        }
        return null;
    }

    private void save(File file, Properties properties, String header) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            properties.store(stream, header);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    protected void setupGenerator(BuildScriptGenerator generator, String featureID, String versionId, String os, String ws, String arch, String featureLocation) throws CoreException {
        super.setupGenerator(generator, featureID, versionId, os, ws, arch, featureLocation);
        generator.setGenerateVersionsList(true);
        if (this.fProduct != null) {
            generator.setProduct(this.fProduct.getModel().getInstallLocation());
        }
    }

    /*
     * Exception decompiling
     */
    private void createMacScript(String[] config, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setAdditionalAttributes(Element plugin, BundleDescription bundle) {
        HostSpecification host = bundle.getHost();
        boolean unpack = host != null && host.getName().equals("org.eclipse.equinox.launcher") ? true : CoreUtility.guessUnpack(bundle);
        plugin.setAttribute("unpack", Boolean.toString(unpack));
    }
}

