/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.exports;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Map;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.FeatureBasedExportOperation;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.isite.ISiteModel;

public class SiteBuildOperation
extends FeatureBasedExportOperation {
    private ISiteModel fSiteModel;

    public SiteBuildOperation(FeatureExportInfo info, ISiteModel siteModel) {
        super(info);
        this.fSiteModel = siteModel;
    }

    protected void createPostProcessingFiles() {
        this.createPostProcessingFile(new File(this.fFeatureLocation, FEATURE_POST_PROCESSING));
        this.createPostProcessingFile(new File(this.fFeatureLocation, PLUGIN_POST_PROCESSING));
    }

    protected void setP2MetaDataProperties(Map map) {
        if (this.fInfo.toDirectory) {
            ISiteDescription description;
            map.put("generate.p2.metadata", "true");
            map.put("p2.flavor", "tooling");
            map.put("p2.publish.artifacts", "false");
            map.put("p2.final.mode.override", "true");
            if (this.fSiteModel != null && (description = this.fSiteModel.getSite().getDescription()) != null && description.getName() != null && description.getName().length() > 0) {
                map.put("p2.metadata.repo.name", description.getName());
                map.put("p2.artifact.repo.name", description.getName());
            }
            try {
                map.put("p2.metadata.repo", new File(this.fInfo.destinationDirectory).toURL().toString());
                map.put("p2.artifact.repo", new File(this.fInfo.destinationDirectory).toURL().toString());
            }
            catch (MalformedURLException e) {
                PDECore.log(e);
            }
        }
    }
}

