/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.toc;

import org.eclipse.core.resources.IFile;
import org.eclipse.pde.internal.core.text.DocumentNodeFactory;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentNodeFactory;
import org.eclipse.pde.internal.core.text.toc.Toc;
import org.eclipse.pde.internal.core.text.toc.TocAnchor;
import org.eclipse.pde.internal.core.text.toc.TocLink;
import org.eclipse.pde.internal.core.text.toc.TocModel;
import org.eclipse.pde.internal.core.text.toc.TocTopic;

public class TocDocumentFactory
extends DocumentNodeFactory
implements IDocumentNodeFactory {
    private TocModel fModel;

    public TocDocumentFactory(TocModel model) {
        this.fModel = model;
    }

    public IDocumentElementNode createDocumentNode(String name, IDocumentElementNode parent) {
        if (this.isToc(name)) {
            return this.createToc();
        }
        if (this.isTopic(name)) {
            return this.createTocTopic();
        }
        if (this.isLink(name)) {
            return this.createTocLink();
        }
        if (this.isAnchor(name)) {
            return this.createTocAnchor();
        }
        return super.createDocumentNode(name, parent);
    }

    private boolean isTocElement(String name, String elementName) {
        return name.equals(elementName);
    }

    private boolean isToc(String name) {
        return this.isTocElement(name, "toc");
    }

    private boolean isAnchor(String name) {
        return this.isTocElement(name, "anchor");
    }

    private boolean isTopic(String name) {
        return this.isTocElement(name, "topic");
    }

    private boolean isLink(String name) {
        return this.isTocElement(name, "link");
    }

    public Toc createToc() {
        return new Toc(this.fModel);
    }

    public TocTopic createTocTopic() {
        return new TocTopic(this.fModel);
    }

    public TocLink createTocLink() {
        return new TocLink(this.fModel);
    }

    public TocTopic createTocTopic(IFile file) {
        return new TocTopic(this.fModel, file);
    }

    public TocLink createTocLink(IFile file) {
        return new TocLink(this.fModel, file);
    }

    public TocAnchor createTocAnchor() {
        return new TocAnchor(this.fModel);
    }
}

