/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.internal.databinding.beans.JavaBeanObservableList;
import org.eclipse.core.internal.databinding.beans.JavaBeanObservableMap;
import org.eclipse.core.internal.databinding.beans.JavaBeanObservableSet;
import org.eclipse.core.internal.databinding.beans.JavaBeanObservableValue;
import org.eclipse.core.internal.databinding.beans.JavaBeanPropertyObservableMap;
import org.eclipse.core.runtime.Assert;

public final class BeansObservables {
    public static final boolean DEBUG = true;
    static /* synthetic */ Class class$0;

    public static IObservableValue observeValue(Object bean, String propertyName) {
        return BeansObservables.observeValue(Realm.getDefault(), bean, propertyName);
    }

    public static IObservableValue observeValue(Realm realm, Object bean, String propertyName) {
        PropertyDescriptor descriptor = BeansObservables.getPropertyDescriptor(bean.getClass(), propertyName);
        return new JavaBeanObservableValue(realm, bean, descriptor);
    }

    public static IObservableMap observeMap(IObservableSet domain, Class beanClass, String propertyName) {
        PropertyDescriptor descriptor = BeansObservables.getPropertyDescriptor(beanClass, propertyName);
        return new JavaBeanObservableMap(domain, descriptor);
    }

    public static IObservableMap observeMap(Realm realm, Object bean, String propertyName) {
        PropertyDescriptor descriptor = BeansObservables.getPropertyDescriptor(bean.getClass(), propertyName);
        return new JavaBeanPropertyObservableMap(realm, bean, descriptor);
    }

    public static IObservableMap observeMap(Object bean, String propertyName) {
        return BeansObservables.observeMap(Realm.getDefault(), bean, propertyName);
    }

    static PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < propertyDescriptors.length) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            if (descriptor.getName().equals(propertyName)) {
                return descriptor;
            }
            ++i;
        }
        throw new BindingException("Could not find property with name " + propertyName + " in class " + beanClass);
    }

    public static IObservableMap[] observeMaps(IObservableSet domain, Class beanClass, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = BeansObservables.observeMap(domain, beanClass, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static IObservableList observeList(Realm realm, Object bean, String propertyName) {
        return BeansObservables.observeList(realm, bean, propertyName, null);
    }

    public static IObservableList observeList(Object bean, String propertyName) {
        return BeansObservables.observeList(Realm.getDefault(), bean, propertyName);
    }

    public static IObservableList observeList(Realm realm, Object bean, String propertyName, Class elementType) {
        PropertyDescriptor propertyDescriptor = BeansObservables.getPropertyDescriptor(bean.getClass(), propertyName);
        elementType = BeansObservables.getCollectionElementType(elementType, propertyDescriptor);
        return new JavaBeanObservableList(realm, bean, propertyDescriptor, elementType);
    }

    public static IObservableList observeList(Object bean, String propertyName, Class elementType) {
        return BeansObservables.observeList(Realm.getDefault(), bean, propertyName, elementType);
    }

    public static IObservableSet observeSet(Realm realm, Object bean, String propertyName) {
        return BeansObservables.observeSet(realm, bean, propertyName, null);
    }

    public static IObservableSet observeSet(Object bean, String propertyName) {
        return BeansObservables.observeSet(Realm.getDefault(), bean, propertyName);
    }

    public static IObservableFactory valueFactory(final Realm realm, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeValue(realm, target, propertyName);
            }
        };
    }

    public static IObservableFactory valueFactory(String propertyName) {
        return BeansObservables.valueFactory(Realm.getDefault(), propertyName);
    }

    public static IObservableFactory listFactory(final Realm realm, final String propertyName, final Class elementType) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeList(realm, target, propertyName, elementType);
            }
        };
    }

    public static IObservableFactory listFactory(String propertyName, Class elementType) {
        return BeansObservables.listFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static IObservableFactory setFactory(final Realm realm, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeSet(realm, target, propertyName);
            }
        };
    }

    public static IObservableFactory setFactory(String propertyName) {
        return BeansObservables.setFactory(Realm.getDefault(), propertyName);
    }

    public static IObservableValue observeDetailValue(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableValue value = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)BeansObservables.valueFactory(realm, propertyName), (Object)propertyType);
        BeanObservableValueDecorator decorator = new BeanObservableValueDecorator(value, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableValue observeDetailValue(IObservableValue master, String propertyName, Class propertyType) {
        return BeansObservables.observeDetailValue(Realm.getDefault(), master, propertyName, propertyType);
    }

    public static IObservableValue observeDetailValue(Realm realm, IObservableValue master, Class masterType, String propertyName, Class propertyType) {
        Assert.isNotNull((Object)masterType, (String)"masterType cannot be null");
        IObservableValue value = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)BeansObservables.valueFactory(realm, propertyName), (Object)propertyType);
        BeanObservableValueDecorator decorator = new BeanObservableValueDecorator(value, BeansObservables.getPropertyDescriptor(masterType, propertyName));
        return decorator;
    }

    public static IObservableValue observeDetailValue(IObservableValue master, Class masterType, String propertyName, Class propertyType) {
        return BeansObservables.observeDetailValue(Realm.getDefault(), master, masterType, propertyName, propertyType);
    }

    public static IObservableList observeDetailList(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableList observableList = MasterDetailObservables.detailList((IObservableValue)master, (IObservableFactory)BeansObservables.listFactory(realm, propertyName, propertyType), (Object)propertyType);
        BeanObservableListDecorator decorator = new BeanObservableListDecorator(observableList, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableList observeDetailList(IObservableValue master, String propertyName, Class propertyType) {
        return BeansObservables.observeDetailList(Realm.getDefault(), master, propertyName, propertyType);
    }

    public static IObservableSet observeDetailSet(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableSet observableSet = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)BeansObservables.setFactory(realm, propertyName, propertyType), (Object)propertyType);
        BeanObservableSetDecorator decorator = new BeanObservableSetDecorator(observableSet, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableSet observeDetailSet(IObservableValue master, String propertyName, Class propertyType) {
        return BeansObservables.observeDetailSet(Realm.getDefault(), master, propertyName, propertyType);
    }

    public static IObservableMap observeDetailMap(Realm realm, IObservableValue master, String propertyName) {
        IObservableMap observableMap = MasterDetailObservables.detailMap((IObservableValue)master, (IObservableFactory)BeansObservables.mapPropertyFactory(realm, propertyName));
        BeanObservableMapDecorator decorator = new BeanObservableMapDecorator(observableMap, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableMap observeDetailMap(IObservableValue master, String propertyName) {
        return BeansObservables.observeDetailMap(Realm.getDefault(), master, propertyName);
    }

    public static IObservableSet observeSet(Realm realm, Object bean, String propertyName, Class elementType) {
        PropertyDescriptor propertyDescriptor = BeansObservables.getPropertyDescriptor(bean.getClass(), propertyName);
        elementType = BeansObservables.getCollectionElementType(elementType, propertyDescriptor);
        return new JavaBeanObservableSet(realm, bean, propertyDescriptor, elementType);
    }

    public static IObservableSet observeSet(Object bean, String propertyName, Class elementType) {
        return BeansObservables.observeSet(Realm.getDefault(), bean, propertyName, elementType);
    }

    public static IObservableFactory setFactory(final Realm realm, final String propertyName, final Class elementType) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeSet(realm, target, propertyName, elementType);
            }
        };
    }

    public static IObservableFactory setFactory(String propertyName, Class elementType) {
        return BeansObservables.setFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static IObservableFactory setToMapFactory(final Class beanClass, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeMap((IObservableSet)target, beanClass, propertyName);
            }
        };
    }

    public static IObservableFactory mapPropertyFactory(final Realm realm, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeMap(realm, target, propertyName);
            }
        };
    }

    public static IObservableFactory mapPropertyFactory(String propertyName) {
        return BeansObservables.mapPropertyFactory(Realm.getDefault(), propertyName);
    }

    static Class getCollectionElementType(Class elementType, PropertyDescriptor propertyDescriptor) {
        if (elementType == null) {
            Class<?> clazz;
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            if (propertyType.isArray()) {
                clazz = propertyType.getComponentType();
            } else {
                clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }
            elementType = clazz;
        }
        return elementType;
    }

    static PropertyDescriptor getValueTypePropertyDescriptor(IObservableValue observable, String propertyName) {
        return observable.getValueType() != null ? BeansObservables.getPropertyDescriptor((Class)observable.getValueType(), propertyName) : null;
    }
}

