/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.internal.databinding.beans.JavaBeanObservableList;
import org.eclipse.core.internal.databinding.beans.JavaBeanObservableMap;
import org.eclipse.core.internal.databinding.beans.JavaBeanObservableSet;
import org.eclipse.core.internal.databinding.beans.JavaBeanObservableValue;
import org.eclipse.core.internal.databinding.beans.JavaBeanPropertyObservableMap;

public final class PojoObservables {
    public static IObservableValue observeValue(Object pojo, String propertyName) {
        return PojoObservables.observeValue(Realm.getDefault(), pojo, propertyName);
    }

    public static IObservableValue observeValue(Realm realm, Object pojo, String propertyName) {
        PropertyDescriptor descriptor = BeansObservables.getPropertyDescriptor(pojo.getClass(), propertyName);
        return new JavaBeanObservableValue(realm, pojo, descriptor, false);
    }

    public static IObservableMap observeMap(IObservableSet domain, Class pojoClass, String propertyName) {
        PropertyDescriptor descriptor = BeansObservables.getPropertyDescriptor(pojoClass, propertyName);
        return new JavaBeanObservableMap(domain, descriptor, false);
    }

    public static IObservableMap[] observeMaps(IObservableSet domain, Class pojoClass, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = PojoObservables.observeMap(domain, pojoClass, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static IObservableMap observeMap(Realm realm, Object pojo, String propertyName) {
        PropertyDescriptor descriptor = BeansObservables.getPropertyDescriptor(pojo.getClass(), propertyName);
        return new JavaBeanPropertyObservableMap(realm, pojo, descriptor, false);
    }

    public static IObservableMap observeMap(Object pojo, String propertyName) {
        return PojoObservables.observeMap(Realm.getDefault(), pojo, propertyName);
    }

    public static IObservableList observeList(Realm realm, Object pojo, String propertyName) {
        return PojoObservables.observeList(realm, pojo, propertyName, null);
    }

    public static IObservableList observeList(Object pojo, String propertyName) {
        return PojoObservables.observeList(Realm.getDefault(), pojo, propertyName);
    }

    public static IObservableList observeList(Realm realm, Object pojo, String propertyName, Class elementType) {
        PropertyDescriptor propertyDescriptor = BeansObservables.getPropertyDescriptor(pojo.getClass(), propertyName);
        elementType = BeansObservables.getCollectionElementType(elementType, propertyDescriptor);
        return new JavaBeanObservableList(realm, pojo, propertyDescriptor, elementType, false);
    }

    public static IObservableList observeList(Object pojo, String propertyName, Class elementType) {
        return PojoObservables.observeList(Realm.getDefault(), pojo, propertyName, elementType);
    }

    public static IObservableSet observeSet(Realm realm, Object pojo, String propertyName) {
        return PojoObservables.observeSet(realm, pojo, propertyName, null);
    }

    public static IObservableSet observeSet(Object pojo, String propertyName) {
        return PojoObservables.observeSet(Realm.getDefault(), pojo, propertyName);
    }

    public static IObservableSet observeSet(Realm realm, Object pojo, String propertyName, Class elementType) {
        PropertyDescriptor propertyDescriptor = BeansObservables.getPropertyDescriptor(pojo.getClass(), propertyName);
        elementType = BeansObservables.getCollectionElementType(elementType, propertyDescriptor);
        return new JavaBeanObservableSet(realm, pojo, propertyDescriptor, elementType, false);
    }

    public static IObservableSet observeSet(Object pojo, String propertyName, Class elementType) {
        return PojoObservables.observeSet(Realm.getDefault(), pojo, propertyName, elementType);
    }

    public static IObservableFactory valueFactory(final Realm realm, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return PojoObservables.observeValue(realm, target, propertyName);
            }
        };
    }

    public static IObservableFactory valueFactory(String propertyName) {
        return PojoObservables.valueFactory(Realm.getDefault(), propertyName);
    }

    public static IObservableFactory listFactory(final Realm realm, final String propertyName, final Class elementType) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return PojoObservables.observeList(realm, target, propertyName, elementType);
            }
        };
    }

    public static IObservableFactory listFactory(String propertyName, Class elementType) {
        return PojoObservables.listFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static IObservableFactory setFactory(final Realm realm, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return PojoObservables.observeSet(realm, target, propertyName);
            }
        };
    }

    public static IObservableFactory setFactory(String propertyName) {
        return PojoObservables.setFactory(Realm.getDefault(), propertyName);
    }

    public static IObservableFactory setFactory(final Realm realm, final String propertyName, final Class elementType) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return PojoObservables.observeSet(realm, target, propertyName, elementType);
            }
        };
    }

    public static IObservableFactory setFactory(String propertyName, Class elementType) {
        return PojoObservables.setFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static IObservableFactory mapPropertyFactory(final Realm realm, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return PojoObservables.observeMap(realm, target, propertyName);
            }
        };
    }

    public static IObservableFactory mapPropertyFactory(String propertyName) {
        return PojoObservables.mapPropertyFactory(Realm.getDefault(), propertyName);
    }

    public static IObservableValue observeDetailValue(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableValue value = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)PojoObservables.valueFactory(realm, propertyName), (Object)propertyType);
        BeanObservableValueDecorator decorator = new BeanObservableValueDecorator(value, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableValue observeDetailValue(IObservableValue master, String propertyName, Class propertyType) {
        return PojoObservables.observeDetailValue(Realm.getDefault(), master, propertyName, propertyType);
    }

    public static IObservableList observeDetailList(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableList observableList = MasterDetailObservables.detailList((IObservableValue)master, (IObservableFactory)PojoObservables.listFactory(realm, propertyName, propertyType), (Object)propertyType);
        BeanObservableListDecorator decorator = new BeanObservableListDecorator(observableList, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableList observeDetailList(IObservableValue master, String propertyName, Class propertyType) {
        return PojoObservables.observeDetailList(Realm.getDefault(), master, propertyName, propertyType);
    }

    public static IObservableSet observeDetailSet(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableSet observableSet = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)PojoObservables.setFactory(realm, propertyName, propertyType), (Object)propertyType);
        BeanObservableSetDecorator decorator = new BeanObservableSetDecorator(observableSet, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableSet observeDetailSet(IObservableValue master, String propertyName, Class propertyType) {
        return PojoObservables.observeDetailSet(Realm.getDefault(), master, propertyName, propertyType);
    }

    public static IObservableMap observeDetailMap(Realm realm, IObservableValue master, String propertyName) {
        IObservableMap observableMap = MasterDetailObservables.detailMap((IObservableValue)master, (IObservableFactory)PojoObservables.mapPropertyFactory(realm, propertyName));
        BeanObservableMapDecorator decorator = new BeanObservableMapDecorator(observableMap, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableMap observeDetailMap(IObservableValue master, String propertyName) {
        return PojoObservables.observeDetailMap(Realm.getDefault(), master, propertyName);
    }
}

