/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.model;

import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.swt.widgets.Shell;

public class ElementUtils {
    public static void updateRepositoryUsingElements(final MetadataRepositoryElement[] elements, Shell shell) {
        Job job = new Job("Updating Repository Information"){

            public IStatus run(IProgressMonitor monitor) {
                ProvUI.startBatchOperation();
                try {
                    try {
                        URL[] currentlyEnabled = ProvisioningUtil.getMetadataRepositories(0);
                        URL[] currentlyDisabled = ProvisioningUtil.getMetadataRepositories(8);
                        int i = 0;
                        while (i < elements.length) {
                            URL location = elements[i].getLocation();
                            if (elements[i].isEnabled()) {
                                if (ElementUtils.containsURL(currentlyDisabled, location)) {
                                    ProvisioningUtil.setColocatedRepositoryEnablement(location, true);
                                } else if (!ElementUtils.containsURL(currentlyEnabled, location)) {
                                    ProvisioningUtil.addMetadataRepository(location);
                                    ProvisioningUtil.addArtifactRepository(location);
                                }
                            } else if (ElementUtils.containsURL(currentlyEnabled, location)) {
                                ProvisioningUtil.setColocatedRepositoryEnablement(location, false);
                            } else if (!ElementUtils.containsURL(currentlyDisabled, location)) {
                                ProvisioningUtil.addMetadataRepository(location);
                                ProvisioningUtil.addArtifactRepository(location);
                                ProvisioningUtil.setColocatedRepositoryEnablement(location, false);
                            }
                            ++i;
                        }
                    }
                    catch (ProvisionException e) {
                        IStatus iStatus = e.getStatus();
                        ProvUI.endBatchOperation();
                        return iStatus;
                    }
                }
                finally {
                    ProvUI.endBatchOperation();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    static boolean containsURL(URL[] locations, URL url) {
        int i = 0;
        while (i < locations.length) {
            if (locations[i].toExternalForm().equals(url.toExternalForm())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

