/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text.rules;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.sse.core.internal.ltk.parser.IBlockedStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.rules.IStructuredRegion;
import org.eclipse.wst.sse.core.internal.text.rules.IStructuredTypedRegion;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredTypedRegion;

public class StructuredTextPartitioner
implements IDocumentPartitioner,
IStructuredTextPartitioner {
    private CachedComputedPartitions cachedPartitions = new CachedComputedPartitions(-1, -1, null);
    protected String[] fSupportedTypes = null;
    protected IStructuredTypedRegion internalReusedTempInstance = new SimpleStructuredTypedRegion(0, 0, "org.eclipse.wst.sse.ST_DEFAULT");
    protected IStructuredDocument fStructuredDocument;

    public ITypedRegion[] computePartitioning(int offset, int length) {
        if (this.fStructuredDocument == null) {
            throw new IllegalStateException("document partitioner is not connected");
        }
        ITypedRegion[] results = null;
        if (!this.cachedPartitions.isInValid && offset == this.cachedPartitions.fOffset && length == this.cachedPartitions.fLength) {
            results = this.cachedPartitions.fPartitions;
        } else {
            if (length == 0) {
                results = new ITypedRegion[]{this.getPartition(offset)};
            } else {
                ArrayList<IStructuredTypedRegion> list = new ArrayList<IStructuredTypedRegion>();
                int endPos = offset + length;
                if (endPos > this.fStructuredDocument.getLength()) {
                    return new ITypedRegion[]{this.createPartition(offset, length, this.getUnknown())};
                }
                int currentPos = offset;
                IStructuredTypedRegion previousPartition = null;
                while (currentPos < endPos) {
                    this.internalGetPartition(currentPos, false);
                    currentPos += this.internalReusedTempInstance.getLength();
                    if (previousPartition != null && this.internalReusedTempInstance.getType().equals(previousPartition.getType())) {
                        previousPartition.setLength(previousPartition.getLength() + this.internalReusedTempInstance.getLength());
                        continue;
                    }
                    IStructuredTypedRegion partition = this.createNewPartitionInstance();
                    list.add(partition);
                    previousPartition = partition;
                }
                results = new ITypedRegion[list.size()];
                list.toArray(results);
            }
            if (results.length > 0) {
                int lastEnd;
                if (results[0].getOffset() < offset && results[0] instanceof IStructuredRegion) {
                    ((IStructuredRegion)results[0]).setOffset(offset);
                }
                if ((lastEnd = results[results.length - 1].getOffset() + results[results.length - 1].getLength()) > offset + length && results[results.length - 1] instanceof IStructuredRegion) {
                    ((IStructuredRegion)results[results.length - 1]).setLength(offset + length - results[results.length - 1].getOffset());
                }
            }
            this.cachedPartitions.fLength = length;
            this.cachedPartitions.fOffset = offset;
            this.cachedPartitions.fPartitions = results;
            this.cachedPartitions.isInValid = false;
        }
        return results;
    }

    public synchronized void connect(IDocument document) {
        if (!(document instanceof IStructuredDocument)) {
            throw new IllegalArgumentException("This class and API are for Structured Documents only");
        }
        this.cachedPartitions.isInValid = true;
        this.fStructuredDocument = (IStructuredDocument)document;
    }

    protected boolean containsEmbeddedRegion(IStructuredDocumentRegion container) {
        boolean containsEmbeddedRegion = false;
        ITextRegionList regions = container.getRegions();
        int i = 0;
        while (i < regions.size()) {
            ITextRegion region = regions.get(i);
            if (region instanceof ITextRegionContainer) {
                containsEmbeddedRegion = true;
                break;
            }
            ++i;
        }
        return containsEmbeddedRegion;
    }

    private IStructuredTypedRegion createNewPartitionInstance() {
        return new SimpleStructuredTypedRegion(this.internalReusedTempInstance.getOffset(), this.internalReusedTempInstance.getLength(), this.internalReusedTempInstance.getType());
    }

    public IStructuredTypedRegion createPartition(int offset, int length, String type) {
        return new SimpleStructuredTypedRegion(offset, length, type);
    }

    public synchronized void disconnect() {
        this.cachedPartitions.isInValid = true;
        this.fStructuredDocument = null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.cachedPartitions.isInValid = true;
    }

    public boolean documentChanged(DocumentEvent event) {
        boolean result = false;
        if (event instanceof StructuredDocumentRegionsReplacedEvent) {
            result = true;
        }
        return result;
    }

    protected boolean doParserSpecificCheck(int offset, boolean partitionFound, IStructuredDocumentRegion sdRegion, IStructuredDocumentRegion previousStructuredDocumentRegion, ITextRegion next, ITextRegion previousStart) {
        return false;
    }

    public String getContentType(int offset) {
        return this.getPartition(offset).getType();
    }

    public String getDefaultPartitionType() {
        return "org.eclipse.wst.sse.ST_DEFAULT";
    }

    public String[] getLegalContentTypes() {
        if (this.fSupportedTypes == null) {
            this.initLegalContentTypes();
        }
        return this.fSupportedTypes;
    }

    public ITypedRegion getPartition(int offset) {
        this.internalGetPartition(offset, true);
        return this.createNewPartitionInstance();
    }

    protected String getPartitionFromBlockedText(ITextRegion region, int offset, String result) {
        return result;
    }

    protected String getPartitionType(ForeignRegion region, int offset) {
        String tagname = region.getSurroundingTag();
        String result = null;
        result = tagname != null ? "BLOCK:" + tagname.toUpperCase(Locale.ENGLISH) : "BLOCK";
        return result;
    }

    protected String getPartitionType(IBlockedStructuredDocumentRegion blockedStructuredDocumentRegion, int offset) {
        String result = null;
        ITextRegionList regions = blockedStructuredDocumentRegion.getRegions();
        if (regions != null && regions.size() > 0) {
            if (regions.size() == 1) {
                ITextRegion blockedRegion = regions.get(0);
                if (blockedRegion instanceof ForeignRegion) {
                    result = this.getPartitionType((ForeignRegion)blockedRegion, offset);
                }
            } else {
                result = this.getReleventRegionType(blockedStructuredDocumentRegion, offset);
            }
        }
        return result;
    }

    private String getPartitionType(ITextRegion region) {
        return this.getDefaultPartitionType();
    }

    public String getPartitionType(ITextRegion region, int offset) {
        String result = this.getDefaultPartitionType();
        if (region instanceof ITextRegionContainer) {
            result = this.getPartitionType((ITextRegionContainer)region, offset);
        }
        result = this.getPartitionFromBlockedText(region, offset, result);
        return result;
    }

    protected String getPartitionType(ITextRegionContainer region, int offset) {
        ITextRegionContainer coreRegion;
        String result = null;
        result = region != null ? ((coreRegion = region) instanceof ITextRegionContainer ? this.getPartitionType(coreRegion, coreRegion.getRegions(), offset) : this.getPartitionType(region)) : this.getPartitionType((ITextRegion)region, offset);
        return result;
    }

    private String getPartitionType(ITextRegionContainer coreRegion, ITextRegionList regions, int offset) {
        String result = null;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion region = regions.get(i);
            if (coreRegion.containsOffset(region, offset)) {
                result = this.getPartitionType(region, offset);
                break;
            }
            ++i;
        }
        return result;
    }

    public String getPartitionTypeBetween(IStructuredDocumentRegion previousNode, IStructuredDocumentRegion nextNode) {
        return this.getDefaultPartitionType();
    }

    private String getReleventRegionType(IStructuredDocumentRegion flatNode, int offset) {
        ITextRegion resultRegion = null;
        if (this.containsEmbeddedRegion(flatNode)) {
            resultRegion = flatNode.getRegionAtCharacterOffset(offset);
            if (resultRegion instanceof ITextRegionContainer) {
                resultRegion = flatNode.getRegionAtCharacterOffset(offset);
                ITextRegionList regions = ((ITextRegionContainer)resultRegion).getRegions();
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if (flatNode.getStartOffset(region) <= offset && offset < flatNode.getEndOffset(region)) {
                        resultRegion = region;
                        break;
                    }
                    ++i;
                }
            }
        } else {
            resultRegion = flatNode;
        }
        return resultRegion.getType();
    }

    protected String getUnknown() {
        return "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
    }

    protected void initLegalContentTypes() {
        this.fSupportedTypes = new String[]{"org.eclipse.wst.sse.ST_DEFAULT", "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE"};
    }

    private void internalGetPartition(int offset, boolean checkBetween) {
        ITextRegion resultRegion;
        IStructuredDocumentRegion previousStructuredDocumentRegion;
        if (this.fStructuredDocument == null) {
            throw new IllegalStateException("document partitioner is not connected");
        }
        boolean partitionFound = false;
        int docLength = this.fStructuredDocument.getLength();
        IStructuredDocumentRegion structuredDocumentRegion = this.fStructuredDocument.getRegionAtCharacterOffset(offset);
        if (structuredDocumentRegion == null) {
            if (docLength == 0) {
                this.setInternalPartition(offset, 0, this.getDefaultPartitionType());
                partitionFound = true;
            } else {
                this.setInternalPartition(offset, 1, this.getUnknown());
                partitionFound = true;
            }
        } else if (checkBetween && structuredDocumentRegion.getStartOffset() == offset && (previousStructuredDocumentRegion = structuredDocumentRegion.getPrevious()) != null) {
            ITextRegion next = structuredDocumentRegion.getRegionAtCharacterOffset(offset);
            ITextRegion previousStart = previousStructuredDocumentRegion.getRegionAtCharacterOffset(previousStructuredDocumentRegion.getStartOffset());
            partitionFound = this.doParserSpecificCheck(offset, partitionFound, structuredDocumentRegion, previousStructuredDocumentRegion, next, previousStart);
        }
        if (!partitionFound && structuredDocumentRegion != null && !(partitionFound = this.isDocumentRegionBasedPartition(structuredDocumentRegion, resultRegion = structuredDocumentRegion.getRegionAtCharacterOffset(offset), offset))) {
            if (resultRegion != null && resultRegion instanceof ITextRegionContainer) {
                ITextRegionContainer containerRegion = (ITextRegionContainer)resultRegion;
                ITextRegion deepRegion = containerRegion.getRegionAtCharacterOffset(offset);
                int endOffset = containerRegion.getEndOffset(deepRegion);
                String type = this.getPartitionType(deepRegion, endOffset);
                this.setInternalPartition(offset, endOffset - offset, type);
            } else if (resultRegion != null) {
                String type = this.getPartitionType(resultRegion, offset);
                this.setInternalPartition(offset, structuredDocumentRegion.getEndOffset(resultRegion) - offset, type);
            } else {
                this.setInternalPartition(offset, 1, this.getDefaultPartitionType());
            }
        }
    }

    protected boolean isDocumentRegionBasedPartition(IStructuredDocumentRegion structuredDocumentRegion, ITextRegion containedChildRegion, int offset) {
        return false;
    }

    public IDocumentPartitioner newInstance() {
        return new StructuredTextPartitioner();
    }

    protected void setInternalPartition(int offset, int length, String type) {
        this.internalReusedTempInstance.setOffset(offset);
        this.internalReusedTempInstance.setLength(length);
        this.internalReusedTempInstance.setType(type);
    }

    static class CachedComputedPartitions {
        int fLength;
        int fOffset;
        ITypedRegion[] fPartitions;
        boolean isInValid;

        CachedComputedPartitions(int offset, int length, ITypedRegion[] partitions) {
            this.fOffset = offset;
            this.fLength = length;
            this.fPartitions = partitions;
            this.isInValid = true;
        }
    }
}

