/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.eval.CodeSnippetScope;
import org.eclipse.jdt.internal.eval.EvaluationConstants;
import org.eclipse.jdt.internal.eval.EvaluationContext;

public class CodeSnippetFieldReference
extends FieldReference
implements ProblemReasons,
EvaluationConstants {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetFieldReference(char[] source, long pos, EvaluationContext evaluationContext) {
        super(source, pos);
        this.evaluationContext = evaluationContext;
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        if (this.codegenBinding.canBeSeenBy(this.receiverType, this, currentScope)) {
            this.receiver.generateCode(currentScope, codeStream, !this.codegenBinding.isStatic());
            assignment.expression.generateCode(currentScope, codeStream, true);
            this.fieldStore(codeStream, this.codegenBinding, null, valueRequired);
        } else {
            codeStream.generateEmulationForField(this.codegenBinding);
            this.receiver.generateCode(currentScope, codeStream, !this.codegenBinding.isStatic());
            if (this.codegenBinding.isStatic()) {
                codeStream.aconst_null();
            }
            assignment.expression.generateCode(currentScope, codeStream, true);
            if (valueRequired) {
                if (this.codegenBinding.type == TypeBinding.LONG || this.codegenBinding.type == TypeBinding.DOUBLE) {
                    codeStream.dup2_x2();
                } else {
                    codeStream.dup_x2();
                }
            }
            codeStream.generateEmulatedWriteAccessForField(this.codegenBinding);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (valueRequired) {
                Constant fieldConstant = this.codegenBinding.constant();
                if (fieldConstant == Constant.NotAConstant) {
                    if (this.codegenBinding.declaringClass == null) {
                        codeStream.arraylength();
                    } else if (this.codegenBinding.canBeSeenBy(this.receiverType, this, currentScope)) {
                        if (isStatic) {
                            codeStream.getstatic(this.codegenBinding);
                        } else {
                            codeStream.getfield(this.codegenBinding);
                        }
                    } else {
                        if (isStatic) {
                            codeStream.aconst_null();
                        }
                        codeStream.generateEmulatedReadAccessForField(this.codegenBinding);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else {
                    if (!isStatic) {
                        codeStream.invokeObjectGetClass();
                        codeStream.pop();
                    }
                    codeStream.generateConstant(fieldConstant, this.implicitConversion);
                }
            } else if (!isStatic) {
                codeStream.invokeObjectGetClass();
                codeStream.pop();
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        if (this.codegenBinding.canBeSeenBy(this.receiverType, this, currentScope)) {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (isStatic) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.dup();
                codeStream.getfield(this.codegenBinding);
            }
            int operationTypeID = (this.implicitConversion & 0xFF) >> 4;
            switch (operationTypeID) {
                case 0: 
                case 1: 
                case 11: {
                    codeStream.generateStringConcatenationAppend(currentScope, null, expression);
                    break;
                }
                default: {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    if (expression == IntLiteral.One) {
                        codeStream.generateConstant(expression.constant, this.implicitConversion);
                    } else {
                        expression.generateCode(currentScope, codeStream, true);
                    }
                    codeStream.sendOperator(operator, operationTypeID);
                    codeStream.generateImplicitConversion(assignmentImplicitConversion);
                }
            }
            this.fieldStore(codeStream, this.codegenBinding, null, valueRequired);
        } else {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (isStatic) {
                codeStream.generateEmulationForField(this.codegenBinding);
                codeStream.aconst_null();
                codeStream.aconst_null();
                codeStream.generateEmulatedReadAccessForField(this.codegenBinding);
            } else {
                codeStream.generateEmulationForField(this.binding);
                this.receiver.generateCode(currentScope, codeStream, !isStatic);
                codeStream.dup();
                codeStream.generateEmulatedReadAccessForField(this.codegenBinding);
            }
            int operationTypeID = (this.implicitConversion & 0xFF) >> 4;
            if (operationTypeID == 11) {
                codeStream.generateStringConcatenationAppend(currentScope, null, expression);
            } else {
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(currentScope, codeStream, true);
                }
                codeStream.sendOperator(operator, operationTypeID);
                codeStream.generateImplicitConversion(assignmentImplicitConversion);
            }
            if (valueRequired) {
                if (this.codegenBinding.type == TypeBinding.LONG || this.codegenBinding.type == TypeBinding.DOUBLE) {
                    codeStream.dup2_x2();
                } else {
                    codeStream.dup_x2();
                }
            }
            codeStream.generateEmulatedWriteAccessForField(this.codegenBinding);
        }
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        if (this.codegenBinding.canBeSeenBy(this.receiverType, this, currentScope)) {
            super.generatePostIncrement(currentScope, codeStream, postIncrement, valueRequired);
        } else {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (isStatic) {
                codeStream.aconst_null();
            }
            codeStream.dup();
            codeStream.generateEmulatedReadAccessForField(this.codegenBinding);
            if (valueRequired) {
                if (this.codegenBinding.type == TypeBinding.LONG || this.codegenBinding.type == TypeBinding.DOUBLE) {
                    codeStream.dup2_x1();
                } else {
                    codeStream.dup_x1();
                }
            }
            if (this.codegenBinding.type == TypeBinding.LONG || this.codegenBinding.type == TypeBinding.DOUBLE) {
                codeStream.dup2_x1();
                codeStream.pop2();
            } else {
                codeStream.dup_x1();
                codeStream.pop();
            }
            codeStream.generateEmulationForField(this.codegenBinding);
            codeStream.swap();
            if (this.codegenBinding.type == TypeBinding.LONG || this.codegenBinding.type == TypeBinding.DOUBLE) {
                codeStream.dup2_x2();
            } else {
                codeStream.dup2_x1();
            }
            codeStream.pop2();
            codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
            codeStream.sendOperator(postIncrement.operator, this.codegenBinding.type.id);
            codeStream.generateImplicitConversion(postIncrement.preAssignImplicitConversion);
            codeStream.generateEmulatedWriteAccessForField(this.codegenBinding);
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo, boolean isReadAccess) {
        TypeBinding someReceiverType;
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        if (this.binding instanceof ParameterizedFieldBinding) {
            ParameterizedFieldBinding parameterizedField = (ParameterizedFieldBinding)this.binding;
            this.codegenBinding = parameterizedField.originalField;
            if (this.codegenBinding.type.isTypeVariable()) {
                TypeVariableBinding variableReturnType = (TypeVariableBinding)this.codegenBinding.type;
                if (variableReturnType.firstBound != parameterizedField.type) {
                    this.genericCast = parameterizedField.type.erasure();
                }
            }
        } else {
            this.codegenBinding = this.binding;
        }
        TypeBinding typeBinding = someReceiverType = this.delegateThis != null ? this.delegateThis.type : this.receiverType;
        if (this.binding.declaringClass != someReceiverType && !someReceiverType.isArrayType() && this.binding.declaringClass != null && this.binding.constant() == Constant.NotAConstant) {
            CompilerOptions options = currentScope.compilerOptions();
            if (!((options.targetJDK < 0x2E0000L || options.complianceLevel < 0x300000L && this.receiver.isImplicitThis() && this.codegenBinding.isStatic() || this.binding.declaringClass.id == 1) && this.binding.declaringClass.canBeSeenBy(currentScope))) {
                this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(this.codegenBinding, (ReferenceBinding)someReceiverType.erasure());
            }
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.receiverType = this.receiver.resolveType(scope);
        if (this.receiverType == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        this.codegenBinding = this.binding = scope.getField(this.receiverType, this.token, this);
        FieldBinding firstAttempt = this.binding;
        boolean isNotVisible = false;
        if (!this.binding.isValidBinding() && this.binding instanceof ProblemFieldBinding && ((ProblemFieldBinding)this.binding).problemId() == 2) {
            isNotVisible = true;
            if (this.evaluationContext.declaringTypeName != null) {
                this.delegateThis = scope.getField(scope.enclosingSourceType(), DELEGATE_THIS, this);
                if (this.delegateThis == null) {
                    this.constant = Constant.NotAConstant;
                    scope.problemReporter().invalidField(this, this.receiverType);
                    return null;
                }
            } else {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidField(this, this.receiverType);
                return null;
            }
            CodeSnippetScope localScope = new CodeSnippetScope(scope);
            this.codegenBinding = this.binding = localScope.getFieldForCodeSnippet(this.delegateThis.type, this.token, this);
        }
        if (!this.binding.isValidBinding()) {
            this.constant = Constant.NotAConstant;
            if (isNotVisible) {
                this.codegenBinding = this.binding = firstAttempt;
            }
            scope.problemReporter().invalidField(this, this.receiverType);
            return null;
        }
        if (this.isFieldUseDeprecated(this.binding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().deprecatedField(this.binding, this);
        }
        Constant constant = this.constant = this.receiver.isImplicitThis() ? this.binding.constant() : Constant.NotAConstant;
        if (!this.receiver.isThis()) {
            this.constant = Constant.NotAConstant;
        }
        this.resolvedType = this.binding.type;
        return this.resolvedType;
    }
}

