/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.parameter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.ScalarParameterBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.parameter.ScalarParameterFragment;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.DataUtil;

public class ComboBoxParameterFragment
extends ScalarParameterFragment {
    public ComboBoxParameterFragment(ParameterDefinition parameter) {
        super(parameter);
    }

    protected void prepareParameterBean(HttpServletRequest request, IViewerReportService service, ScalarParameterBean parameterBean, Locale locale, TimeZone timeZone) throws ReportServiceException {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        Collection selectionList = null;
        ParameterDefinition paramDef = parameterBean.getParameter();
        if (paramDef.getGroup() != null && paramDef.getGroup().cascade()) {
            HashMap paramValues = attrBean.getParameters();
            selectionList = this.getParameterSelectionListForCascadingGroup(attrBean.getReportDesignHandle(request), service, paramValues, options);
            parameterBean.setCascade(true);
        } else {
            selectionList = service.getParameterSelectionList(attrBean.getReportDesignHandle(request), options, this.parameter.getName());
            parameterBean.setCascade(false);
        }
        parameterBean.setValueInList(false);
        if (selectionList != null) {
            boolean isDisplayTextInList = false;
            for (ParameterSelectionChoice selectionItem : selectionList) {
                String displayValue;
                Object value = selectionItem.getValue();
                try {
                    value = DataUtil.convert(value, paramDef.getDataType());
                }
                catch (Exception e) {
                    value = null;
                }
                if ((displayValue = DataUtil.getDisplayValue(value, timeZone)) == null) continue;
                String label = selectionItem.getLabel();
                if (label == null || label.length() <= 0) {
                    label = DataUtil.getDisplayValue(null, paramDef.getPattern(), value, locale, timeZone);
                }
                if (label == null) continue;
                selectionItem.setLabel(label);
                selectionItem.setValue(displayValue);
                parameterBean.getSelectionList().add(selectionItem);
                if (!paramDef.isMultiValue() && displayValue.equals(parameterBean.getValue())) {
                    parameterBean.setValueInList(true);
                    if (!label.equals(parameterBean.getDisplayText())) {
                        if (parameterBean.getParameter().isDistinct() && parameterBean.isDisplayTextInReq()) {
                            selectionItem.setLabel(parameterBean.getDisplayText());
                            isDisplayTextInList = true;
                        }
                    } else {
                        isDisplayTextInList = true;
                    }
                }
                if (!displayValue.equals(parameterBean.getDefaultValue())) continue;
                parameterBean.setDefaultValueInList(true);
            }
            if (parameterBean.isValueInList() && parameterBean.isDisplayTextInReq() && !isDisplayTextInList) {
                parameterBean.getSelectionList().add(new ParameterSelectionChoice(parameterBean.getDisplayText(), parameterBean.getValue()));
                isDisplayTextInList = true;
            }
            parameterBean.setDisplayTextInList(isDisplayTextInList);
        }
    }

    private Collection getParameterSelectionListForCascadingGroup(IViewerReportDesignHandle design, IViewerReportService service, Map paramValues, InputOptions options) throws ReportServiceException {
        ParameterGroupDefinition group = this.parameter.getGroup();
        int index = group.getParameters().indexOf(this.parameter);
        Object[] groupKeys = new Object[index];
        for (int i = 0; i < index; ++i) {
            ParameterDefinition def = (ParameterDefinition)group.getParameters().get(i);
            groupKeys[i] = paramValues.get(def.getName());
        }
        return service.getSelectionListForCascadingGroup(design, group.getName(), groupKeys, options);
    }
}

