/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.parameter;

import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.ScalarParameterBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.parameter.ScalarParameterFragment;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.DataUtil;

public class RadioButtonParameterFragment
extends ScalarParameterFragment {
    public RadioButtonParameterFragment(ParameterDefinition parameter) {
        super(parameter);
    }

    protected void prepareParameterBean(HttpServletRequest request, IViewerReportService service, ScalarParameterBean parameterBean, Locale locale, TimeZone timeZone) throws ReportServiceException {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        Collection selectionList = service.getParameterSelectionList(attrBean.getReportDesignHandle(request), options, parameterBean.getName());
        ParameterDefinition paramDef = parameterBean.getParameter();
        if (selectionList != null) {
            boolean isDisplayTextInList = false;
            for (ParameterSelectionChoice selectionItem : selectionList) {
                String displayValue;
                Object value = selectionItem.getValue();
                try {
                    value = DataUtil.convert(value, paramDef.getDataType());
                }
                catch (Exception e) {
                    value = null;
                }
                if ((displayValue = DataUtil.getDisplayValue(value, timeZone)) == null) continue;
                String label = selectionItem.getLabel();
                if (label == null || label.length() <= 0) {
                    label = DataUtil.getDisplayValue(null, paramDef.getPattern(), value, locale, timeZone);
                }
                if (label == null) continue;
                selectionItem.setLabel(label);
                selectionItem.setValue(displayValue);
                parameterBean.getSelectionList().add(selectionItem);
                if (!displayValue.equals(parameterBean.getValue())) continue;
                if (!label.equals(parameterBean.getDisplayText())) {
                    if (!parameterBean.getParameter().isDistinct() || !parameterBean.isDisplayTextInReq()) continue;
                    selectionItem.setLabel(parameterBean.getDisplayText());
                    isDisplayTextInList = true;
                    continue;
                }
                isDisplayTextInList = true;
            }
            if (parameterBean.isDisplayTextInReq() && !isDisplayTextInList) {
                parameterBean.getSelectionList().add(new ParameterSelectionChoice(parameterBean.getDisplayText(), parameterBean.getValue()));
                isDisplayTextInList = true;
            }
            parameterBean.setDisplayTextInList(isDisplayTextInList);
        }
    }
}

