/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib.component;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.taglib.ITagConstants;
import org.eclipse.birt.report.utility.UrlUtility;

public class ViewerField
implements Serializable,
Cloneable,
ITagConstants {
    private static final long serialVersionUID = 9087611432750518446L;
    private String id;
    private String name;
    private String baseURL;
    private String title;
    private boolean isHostPage = false;
    private boolean isCustom = false;
    private String scrolling = "auto";
    private String position;
    private String style;
    private int height = -1;
    private int width = -1;
    private String left;
    private String top;
    private String frameborder = "no";
    private String reportDesign;
    private String reportDocument;
    private String reportletId;
    private String pattern;
    private String target;
    private String bookmark;
    private String locale;
    private String timeZone;
    private String format;
    private String emitterId;
    private String pageOverflow;
    private String svg;
    private String rtl;
    private long pageNum;
    private String pageRange;
    private String allowMasterPage = "true";
    private String resourceFolder;
    private int maxRowsOfRecords = -1;
    private String forceOverwriteDocument;
    private String showTitle;
    private String showToolBar;
    private String showNavigationBar;
    private String showParameterPage;
    private String isReportlet;
    private String reportContainer = "iframe";
    private Map parameters;
    private boolean documentInUrl = false;
    private IViewerReportDesignHandle reportDesignHandle;
    private Collection parameterDefList = null;

    public String createURI(String iPattern) {
        String uri = iPattern;
        if (uri == null) {
            uri = this.pattern;
        }
        boolean renderReportlet = false;
        if (this.reportDocument != null && (this.reportletId != null || this.bookmark != null && "true".equalsIgnoreCase(this.isReportlet))) {
            renderReportlet = true;
        }
        if (uri == null) {
            uri = "frameset";
            if (renderReportlet) {
                uri = "run";
            }
        }
        boolean usingFrameset = "frameset".equalsIgnoreCase(uri);
        boolean usingParameter = "parameter".equalsIgnoreCase(uri);
        if (this.baseURL != null) {
            uri = this.baseURL + "/" + uri;
        }
        String uriSuffix = "";
        HashMap<String, String> uriParams = new HashMap<String, String>();
        if (this.format != null) {
            uriParams.put("__format", this.format);
        }
        if (this.emitterId != null) {
            uriParams.put("__emitterid", this.emitterId);
        }
        if (this.pageOverflow != null) {
            uriParams.put("__pageoverflow", this.pageOverflow);
        }
        if (this.reportDesign != null) {
            uriParams.put("__report", this.reportDesign);
        }
        if (this.reportDocument != null) {
            uriParams.put("__document", this.reportDocument);
        }
        if (this.reportletId != null) {
            uriParams.put("__instanceid", this.reportletId);
        }
        if (usingFrameset && this.id != null) {
            uriParams.put("__id", this.id);
        }
        if (usingFrameset && this.title != null) {
            uriParams.put("__title", this.title);
        }
        if (usingFrameset && this.showTitle != null) {
            uriParams.put("__showtitle", this.showTitle);
        }
        if (usingParameter && !this.isCustom && this.pattern != null) {
            uriParams.put("__pattern", this.pattern);
        }
        if (usingParameter && !this.isCustom && this.target != null) {
            uriParams.put("__target", this.target);
        }
        if (this.locale != null) {
            uriParams.put("__locale", this.locale);
        }
        if (this.timeZone != null) {
            uriParams.put("__timezone", this.timeZone);
        }
        if (this.svg != null) {
            uriParams.put("__svg", this.svg);
        }
        if (this.rtl != null) {
            uriParams.put("__rtl", this.rtl);
        }
        if (this.pageNum > 0L) {
            uriParams.put("__page", Long.toString(this.pageNum));
        }
        if (this.pageRange != null) {
            uriParams.put("__pagerange", this.pageRange);
        }
        if (this.allowMasterPage != null) {
            uriParams.put("__masterpage", this.allowMasterPage);
        }
        if (this.resourceFolder != null) {
            uriParams.put("__resourceFolder", this.resourceFolder);
        }
        if (this.maxRowsOfRecords >= 0) {
            uriParams.put("__maxrows", Long.toString(this.maxRowsOfRecords));
        }
        if (this.forceOverwriteDocument != null) {
            uriParams.put("__overwrite", this.forceOverwriteDocument);
        }
        if (usingFrameset && this.showToolBar != null) {
            uriParams.put("__toolbar", this.showToolBar);
        }
        if (usingFrameset && this.showNavigationBar != null) {
            uriParams.put("__navigationbar", this.showNavigationBar);
        }
        if (this.showParameterPage != null) {
            uriParams.put("__parameterpage", this.showParameterPage);
        }
        if (this.bookmark != null) {
            if ("preview".equalsIgnoreCase(iPattern) && !"true".equalsIgnoreCase(this.isReportlet)) {
                uriSuffix = uriSuffix + "#" + UrlUtility.urlParamValueEncode(this.bookmark);
            } else {
                uriParams.put("__bookmark", this.bookmark);
            }
        }
        if (this.isReportlet != null) {
            uriParams.put("__isreportlet", this.isReportlet);
        }
        uri = uri + "?" + UrlUtility.makeUriString(uriParams) + uriSuffix;
        return uri;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isHostPage() {
        return this.isHostPage;
    }

    public void setHostPage(boolean isHostPage) {
        this.isHostPage = isHostPage;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setCustom(boolean isCustom) {
        this.isCustom = isCustom;
    }

    public String getScrolling() {
        return this.scrolling;
    }

    public void setScrolling(String scrolling) {
        this.scrolling = scrolling;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getTop() {
        return this.top;
    }

    public void setTop(String top) {
        this.top = top;
    }

    public String getFrameborder() {
        return this.frameborder;
    }

    public void setFrameborder(String frameborder) {
        this.frameborder = frameborder;
    }

    public String getReportDesign() {
        return this.reportDesign;
    }

    public void setReportDesign(String reportDesign) {
        this.reportDesign = reportDesign;
    }

    public String getReportDocument() {
        return this.reportDocument;
    }

    public void setReportDocument(String reportDocument) {
        this.reportDocument = reportDocument;
    }

    public String getReportletId() {
        return this.reportletId;
    }

    public void setReportletId(String reportletId) {
        this.reportletId = reportletId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getEmitterId() {
        return this.emitterId;
    }

    public void setEmitterId(String emitterId) {
        this.emitterId = emitterId;
    }

    public String getPageOverflow() {
        return this.pageOverflow;
    }

    public void setPageOverflow(String pageOverflow) {
        this.pageOverflow = pageOverflow;
    }

    public String getSvg() {
        return this.svg;
    }

    public void setSvg(String svg) {
        this.svg = svg;
    }

    public String getRtl() {
        return this.rtl;
    }

    public void setRtl(String rtl) {
        this.rtl = rtl;
    }

    public long getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(long pageNum) {
        this.pageNum = pageNum;
    }

    public String getPageRange() {
        return this.pageRange;
    }

    public void setPageRange(String pageRange) {
        this.pageRange = pageRange;
    }

    public String getAllowMasterPage() {
        return this.allowMasterPage;
    }

    public void setAllowMasterPage(String allowMasterPage) {
        this.allowMasterPage = allowMasterPage;
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public int getMaxRowsOfRecords() {
        return this.maxRowsOfRecords;
    }

    public void setMaxRowsOfRecords(int maxRowsOfRecords) {
        this.maxRowsOfRecords = maxRowsOfRecords;
    }

    public String getForceOverwriteDocument() {
        return this.forceOverwriteDocument;
    }

    public void setForceOverwriteDocument(String forceOverwriteDocument) {
        this.forceOverwriteDocument = forceOverwriteDocument;
    }

    public String getShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(String showTitle) {
        this.showTitle = showTitle;
    }

    public String getShowToolBar() {
        return this.showToolBar;
    }

    public void setShowToolBar(String showToolBar) {
        this.showToolBar = showToolBar;
    }

    public String getShowNavigationBar() {
        return this.showNavigationBar;
    }

    public void setShowNavigationBar(String showNavigationBar) {
        this.showNavigationBar = showNavigationBar;
    }

    public String getShowParameterPage() {
        return this.showParameterPage;
    }

    public void setShowParameterPage(String showParameterPage) {
        this.showParameterPage = showParameterPage;
    }

    public String getIsReportlet() {
        return this.isReportlet;
    }

    public void setIsReportlet(String isReportlet) {
        this.isReportlet = isReportlet;
    }

    public String getReportContainer() {
        return this.reportContainer;
    }

    public void setReportContainer(String reportContainer) {
        this.reportContainer = reportContainer;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public boolean isDocumentInUrl() {
        return this.documentInUrl;
    }

    public void setDocumentInUrl(boolean documentInUrl) {
        this.documentInUrl = documentInUrl;
    }

    public IViewerReportDesignHandle getReportDesignHandle() {
        return this.reportDesignHandle;
    }

    public void setReportDesignHandle(IViewerReportDesignHandle reportDesignHandle) {
        this.reportDesignHandle = reportDesignHandle;
    }

    public Collection getParameterDefList() {
        return this.parameterDefList;
    }

    public void setParameterDefList(Collection parameterDefList) {
        this.parameterDefList = parameterDefList;
    }
}

