/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingUtil {
    protected static Logger logger = Logger.getLogger(LoggingUtil.class.getName());

    public static void configureLoggers(Map loggers, Level defaultLevel, String directoryName) {
        for (String loggerName : loggers.keySet()) {
            String levelName = (String)loggers.get(loggerName);
            Level level = defaultLevel;
            if (levelName != null && !"".equals(levelName)) {
                try {
                    levelName = levelName.trim();
                    if (!"DEFAULT".equals(levelName)) {
                        level = Level.parse(levelName.trim());
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            LoggingUtil.initFileLogger(loggerName, level, directoryName);
        }
    }

    private static void initFileLogger(String loggerName, Level level, String dirName) {
        Logger theLogger = Logger.getLogger(loggerName);
        theLogger.setLevel(level);
        try {
            FileHandler logFileHandler = new FileHandler(LoggingUtil.generateUniqueLogFileName(loggerName, dirName), true);
            logFileHandler.setFormatter(new SimpleFormatter());
            logFileHandler.setLevel(level);
            theLogger.addHandler(logFileHandler);
            theLogger.setUseParentHandlers(false);
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private static String generateUniqueLogFileName(String loggerName, String directoryName) {
        SimpleDateFormat df = new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss");
        String dateTimeString = df.format(new Date());
        if (directoryName == null) {
            directoryName = "";
        } else if (directoryName.length() > 0) {
            directoryName = directoryName + System.getProperty("file.separator");
        }
        return new String(directoryName + loggerName + dateTimeString + ".log");
    }
}

