/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ConnectionProfileFactory;
import org.eclipse.jpt.db.ConnectionProfileListener;
import org.eclipse.jpt.db.DatabaseFinder;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTPConnectionProfileFactory
implements ConnectionProfileFactory {
    private ProfileManager dtpProfileManager;
    private LocalProfileListener profileListener;
    private static final DTPConnectionProfileFactory INSTANCE = new DTPConnectionProfileFactory();

    public static DTPConnectionProfileFactory instance() {
        return INSTANCE;
    }

    private DTPConnectionProfileFactory() {
    }

    public synchronized void start() {
        this.dtpProfileManager = ProfileManager.getInstance();
        this.profileListener = new LocalProfileListener();
        this.dtpProfileManager.addProfileListener((IProfileListener)this.profileListener);
    }

    public synchronized void stop() {
        this.dtpProfileManager.removeProfileListener((IProfileListener)this.profileListener);
        this.profileListener = null;
        this.dtpProfileManager = null;
    }

    @Override
    public ConnectionProfile buildConnectionProfile(String name, DatabaseFinder finder) {
        IConnectionProfile[] iConnectionProfileArray = this.dtpProfileManager.getProfiles();
        int n = iConnectionProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile dtpProfile = iConnectionProfileArray[n2];
            if (dtpProfile.getName().equals(name)) {
                return new DTPConnectionProfileWrapper(dtpProfile, finder);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ConnectionProfile buildConnectionProfile(String name) {
        return this.buildConnectionProfile(name, DatabaseFinder.Simple.instance());
    }

    @Override
    public Iterator<String> connectionProfileNames() {
        return new TransformationIterator<IConnectionProfile, String>(this.dtpConnectionProfiles()){

            protected String transform(IConnectionProfile dtpProfile) {
                return dtpProfile.getName();
            }
        };
    }

    private Iterator<IConnectionProfile> dtpConnectionProfiles() {
        return new ArrayIterator((Object[])this.dtpProfileManager.getProfiles());
    }

    @Override
    public void addConnectionProfileListener(ConnectionProfileListener listener) {
        this.profileListener.addConnectionProfileListener(listener);
    }

    @Override
    public void removeConnectionProfileListener(ConnectionProfileListener listener) {
        this.profileListener.removeConnectionProfileListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalProfileListener
    implements IProfileListener1 {
        private Vector<ConnectionProfileListener> listeners = new Vector();

        LocalProfileListener() {
        }

        void addConnectionProfileListener(ConnectionProfileListener listener) {
            this.listeners.add(listener);
        }

        void removeConnectionProfileListener(ConnectionProfileListener listener) {
            this.listeners.remove(listener);
        }

        private Iterator<ConnectionProfileListener> listeners() {
            return new CloneIterator(this.listeners);
        }

        public void profileAdded(IConnectionProfile dtpProfile) {
            String name = dtpProfile.getName();
            Iterator<ConnectionProfileListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().connectionProfileAdded(name);
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile, String oldName, String oldDescription, Boolean oldAutoConnect) {
            String newName = dtpProfile.getName();
            if (!newName.equals(oldName)) {
                Iterator<ConnectionProfileListener> stream = this.listeners();
                while (stream.hasNext()) {
                    stream.next().connectionProfileRenamed(oldName, newName);
                }
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile) {
            throw new UnsupportedOperationException();
        }

        public void profileDeleted(IConnectionProfile dtpProfile) {
            String name = dtpProfile.getName();
            Iterator<ConnectionProfileListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().connectionProfileRemoved(name);
            }
        }
    }
}

