/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.MergeResultsAction;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;

public class LocalUpdateSiteAction
implements IPublisherAction {
    protected String source;
    private UpdateSite updateSite;

    protected LocalUpdateSiteAction() {
    }

    public LocalUpdateSiteAction(String source) {
        this.source = source;
    }

    public LocalUpdateSiteAction(UpdateSite updateSite) {
        this.updateSite = updateSite;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        IPublisherAction[] actions = this.createActions();
        int i = 0;
        while (i < actions.length) {
            actions[i].perform(info, results);
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected IPublisherAction[] createActions() {
        this.createAdvice();
        ArrayList<Object> result = new ArrayList<Object>();
        MergeResultsAction action = new MergeResultsAction(new IPublisherAction[]{this.createFeaturesAction(), this.createBundlesAction()}, 2);
        result.add(action);
        result.add(this.createSiteXMLAction());
        return result.toArray(new IPublisherAction[result.size()]);
    }

    private IPublisherAction createSiteXMLAction() {
        if (this.updateSite != null) {
            return new SiteXMLAction(this.updateSite);
        }
        if (this.source != null) {
            try {
                return new SiteXMLAction(new File(this.source, "site.xml").toURL());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    private void createAdvice() {
    }

    protected IPublisherAction createFeaturesAction() {
        return new FeaturesAction(new File[]{new File(this.source, "features")});
    }

    protected IPublisherAction createBundlesAction() {
        return new BundlesAction(new File[]{new File(this.source, "plugins")});
    }
}

