/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.updatesite.RemoteFeaturesAction;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;

public class RemoteUpdateSiteAction
implements IPublisherAction {
    protected String source;
    private UpdateSite updateSite;

    public RemoteUpdateSiteAction(UpdateSite updateSite) {
        this.updateSite = updateSite;
    }

    public RemoteUpdateSiteAction(String source) {
        this.source = source;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        IPublisherAction[] actions = this.createActions();
        int i = 0;
        while (i < actions.length) {
            actions[i].perform(info, results);
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected IPublisherAction[] createActions() {
        try {
            ArrayList<RemoteFeaturesAction> result = new ArrayList<RemoteFeaturesAction>();
            result.add(new RemoteFeaturesAction(this.updateSite.loadFeatures()));
            result.add((RemoteFeaturesAction)this.createSiteXMLAction());
            return result.toArray(new IPublisherAction[result.size()]);
        }
        catch (ProvisionException e) {
            e.printStackTrace();
            return new IPublisherAction[0];
        }
    }

    private IPublisherAction createSiteXMLAction() {
        if (this.updateSite != null) {
            return new SiteXMLAction(this.updateSite);
        }
        if (this.source != null) {
            try {
                return new SiteXMLAction(new URL(String.valueOf(this.source) + "/site.xml"));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }
}

