/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;

public class SiteFeature {
    private String arch;
    private URL base;
    private List categoryNames;
    private String featureId;
    private String featureVersion;
    private String label;
    private String nl;
    private String os;
    private String patch;
    private final boolean resolved = false;
    private SiteModel site;
    private String type;
    private URL url;
    private String urlString;
    private String ws;

    public static boolean sameURL(URL url1, URL url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        if (url1 == url2) {
            return true;
        }
        if (url1.equals(url2)) {
            return true;
        }
        if (!"file".equalsIgnoreCase(url1.getProtocol())) {
            return false;
        }
        if (!"file".equalsIgnoreCase(url2.getProtocol())) {
            return false;
        }
        File file1 = new File(url1.getFile());
        File file2 = new File(url2.getFile());
        if (file1 == null) {
            return false;
        }
        return file1.equals(file2);
    }

    public void addCategoryName(String categoryName) {
        if (this.categoryNames == null) {
            this.categoryNames = new ArrayList();
        }
        if (!this.categoryNames.contains(categoryName)) {
            this.categoryNames.add(categoryName);
        }
    }

    private void delayedResolve() {
        try {
            this.url = new URL(this.base, this.urlString);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getURL() == null) {
            return false;
        }
        if (!(object instanceof SiteFeature)) {
            return false;
        }
        SiteFeature f = (SiteFeature)object;
        return SiteFeature.sameURL(this.getURL(), f.getURL());
    }

    public String[] getCategoryNames() {
        if (this.categoryNames == null) {
            return new String[0];
        }
        return this.categoryNames.toArray(new String[0]);
    }

    public String getFeatureIdentifier() {
        return this.featureId;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelNonLocalized() {
        return this.label;
    }

    public String getNL() {
        return this.nl;
    }

    public String getOS() {
        return this.os;
    }

    public String getOSArch() {
        return this.arch;
    }

    public String getPatch() {
        return this.patch;
    }

    public SiteModel getSiteModel() {
        return this.site;
    }

    public String getType() {
        return this.type;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.url;
    }

    public String getURLString() {
        return this.urlString;
    }

    public String getWS() {
        return this.ws;
    }

    public void resolve(URL resolveBase, URL bundleURL) throws MalformedURLException {
        this.base = resolveBase;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public void setCategoryNames(String[] categoryNames) {
        this.categoryNames = categoryNames == null ? null : new ArrayList<String>(Arrays.asList(categoryNames));
    }

    public void setFeatureIdentifier(String featureId) {
        this.featureId = featureId;
    }

    public void setFeatureVersion(String featureVersion) {
        this.featureVersion = featureVersion;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setNL(String nl) {
        this.nl = nl;
    }

    public void setOS(String os) {
        this.os = os;
    }

    public void setPatch(String patch) {
        this.patch = patch;
    }

    public void setSiteModel(SiteModel site) {
        this.site = site;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setURLString(String urlString) {
        this.urlString = urlString;
        this.url = null;
    }

    public void setWS(String ws) {
        this.ws = ws;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.getClass().toString()) + " :");
        buffer.append(" at ");
        if (this.url != null) {
            buffer.append(this.url.toExternalForm());
        }
        return buffer.toString();
    }
}

