/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class SiteXMLAction
extends AbstractPublisherAction {
    private static final String PROTOCOL_FILE = "file";
    private UpdateSite updateSite;
    private SiteCategory defaultCategory;
    private HashSet defaultCategorySet;

    public SiteXMLAction(URL location) {
        try {
            this.updateSite = UpdateSite.load(location, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            e.printStackTrace();
        }
        this.initialize();
    }

    public SiteXMLAction(UpdateSite updateSite) {
        this.updateSite = updateSite;
        this.initialize();
    }

    private void initialize() {
        this.defaultCategory = new SiteCategory();
        this.defaultCategory.setDescription("Default category for otherwise uncategorized features");
        this.defaultCategory.setLabel("Uncategorized");
        this.defaultCategory.setName("Default");
        this.defaultCategorySet = new HashSet(1);
        this.defaultCategorySet.add(this.defaultCategory);
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        this.generateCategories(info, results);
        return Status.OK_STATUS;
    }

    private void generateCategories(IPublisherInfo info, IPublisherResult results) {
        HashMap<SiteCategory, HashSet<IInstallableUnit>> categoriesToFeatureIUs = new HashMap<SiteCategory, HashSet<IInstallableUnit>>();
        Map featuresToCategories = this.getFeatureToCategoryMappings(info);
        Iterator i = featuresToCategories.keySet().iterator();
        while (i.hasNext()) {
            SiteFeature feature = (SiteFeature)i.next();
            IInstallableUnit iu = this.getFeatureIU(feature, results);
            Set categories = (Set)featuresToCategories.get(feature);
            if (categories == null || categories.isEmpty()) {
                categories = this.defaultCategorySet;
            }
            Iterator it = categories.iterator();
            while (it.hasNext()) {
                SiteCategory category = (SiteCategory)it.next();
                HashSet<IInstallableUnit> featureIUs = (HashSet<IInstallableUnit>)categoriesToFeatureIUs.get(category);
                if (featureIUs == null) {
                    featureIUs = new HashSet<IInstallableUnit>();
                    categoriesToFeatureIUs.put(category, featureIUs);
                }
                featureIUs.add(iu);
            }
        }
        this.generateCategoryIUs(categoriesToFeatureIUs, results);
    }

    private IInstallableUnit getFeatureIU(SiteFeature feature, IPublisherResult results) {
        String id = FeaturesAction.getTransformedId((String)feature.getFeatureIdentifier(), (boolean)false, (boolean)true);
        Version version = new Version(feature.getFeatureVersion());
        Collection ius = results.getIUs(id, null);
        Iterator i = ius.iterator();
        while (i.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)i.next();
            if (!iu.getVersion().equals((Object)version)) continue;
            return iu;
        }
        return null;
    }

    protected Map getFeatureToCategoryMappings(IPublisherInfo info) {
        File siteFile;
        URLEntry[] associatedSites;
        HashMap mappings = new HashMap();
        if (this.updateSite == null) {
            return mappings;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return mappings;
        }
        String mirrors = site.getMirrorsURL();
        if (mirrors != null) {
            int index = mirrors.indexOf("site.xml");
            if (index != -1) {
                mirrors = String.valueOf(mirrors.substring(0, index)) + mirrors.substring(index + "site.xml".length());
            }
            info.getMetadataRepository().setProperty("p2.mirrorsURL", mirrors);
            if (info.getArtifactRepository() != null) {
                info.getArtifactRepository().setProperty("p2.mirrorsURL", mirrors);
            }
        }
        if ((associatedSites = site.getAssociatedSites()) != null) {
            int i = 0;
            while (i < associatedSites.length) {
                this.generateSiteReference(associatedSites[i].getURL(), null, info.getMetadataRepository());
                ++i;
            }
        }
        if (PROTOCOL_FILE.equals(this.updateSite.getLocation().getProtocol()) && (siteFile = new File(this.updateSite.getLocation().getFile())).exists()) {
            String[] keyStrings;
            File siteParent = siteFile.getParentFile();
            List messageKeys = site.getMessageKeys();
            if (siteParent.isDirectory()) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getDirPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            } else if (siteFile.getName().endsWith(".jar")) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getJarPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            }
        }
        SiteFeature[] features = site.getFeatures();
        int i = 0;
        while (i < features.length) {
            String[] categoryNames = features[i].getCategoryNames();
            HashSet<SiteCategory> categories = new HashSet<SiteCategory>();
            mappings.put(features[i], categories);
            int j = 0;
            while (j < categoryNames.length) {
                SiteCategory category = site.getCategory(categoryNames[j]);
                if (category != null) {
                    categories.add(category);
                }
                ++j;
            }
            ++i;
        }
        return mappings;
    }

    private void generateSiteReference(String location, String featureId, IMetadataRepository metadataRepo) {
        try {
            URL associateLocation = new URL(location);
            metadataRepo.addReference(associateLocation, 0, 1);
            metadataRepo.addReference(associateLocation, 1, 1);
        }
        catch (MalformedURLException malformedURLException) {
            String message = "Invalid site reference: " + location;
            if (featureId != null) {
                message = String.valueOf(message) + " in feature: " + featureId;
            }
            LogHelper.log((IStatus)new Status(4, Activator.ID, message));
        }
    }

    protected void generateCategoryIUs(Map categoriesToFeatures, IPublisherResult result) {
        Iterator it = categoriesToFeatures.keySet().iterator();
        while (it.hasNext()) {
            SiteCategory category = (SiteCategory)it.next();
            result.addIU(SiteXMLAction.createCategoryIU(category, (Set)categoriesToFeatures.get(category), null), "non_root");
        }
    }

    public static IInstallableUnit createCategoryIU(SiteCategory category, Set featureIUs, IInstallableUnit parentCategory) {
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = category.getName();
        cat.setId(categoryId);
        cat.setVersion(Version.emptyVersion);
        cat.setProperty("org.eclipse.equinox.p2.name", category.getLabel());
        cat.setProperty("org.eclipse.equinox.p2.description", category.getDescription());
        ArrayList<RequiredCapability> reqsConfigurationUnits = new ArrayList<RequiredCapability>(featureIUs.size());
        Iterator iterator = featureIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (String)iu.getFilter(), (boolean)false, (boolean)false));
        }
        if (parentCategory != null) {
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)parentCategory.getId(), (VersionRange)VersionRange.emptyRange, (String)parentCategory.getFilter(), (boolean)false, (boolean)false));
        }
        cat.setRequiredCapabilities(reqsConfigurationUnits.toArray(new RequiredCapability[reqsConfigurationUnits.size()]));
        ArrayList<ProvidedCapability> providedCapabilities = new ArrayList<ProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)categoryId, (Version)Version.emptyVersion));
        Map localizations = category.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    cat.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability((String)categoryId, (Locale)locale));
            }
        }
        cat.setCapabilities(providedCapabilities.toArray(new ProvidedCapability[providedCapabilities.size()]));
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }
}

