/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite.artifact;

import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.IArtifactRepositoryFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class UpdateSiteArtifactRepositoryFactory
implements IArtifactRepositoryFactory {
    private static final String PROP_ARTIFACT_REFERENCE = "artifact.reference";
    private static final String PROP_FORCE_THREADING = "eclipse.p2.force.threading";
    private static final String PROP_SITE_CHECKSUM = "site.checksum";
    private static final String PROTOCOL_FILE = "file";

    public IArtifactRepository create(URL location, String name, String type, Map properties) {
        return null;
    }

    public IArtifactRepository load(URL location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepository repository = this.loadRepository(location, monitor);
        this.initializeRepository(repository, location, monitor);
        return repository;
    }

    public IArtifactRepository loadRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        URL localRepositoryURL = UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation(location);
        SimpleArtifactRepositoryFactory factory = new SimpleArtifactRepositoryFactory();
        try {
            IArtifactRepository repository = factory.load(localRepositoryURL, null);
            if (!repository.getProperties().get("p2.system").equals(Boolean.TRUE.toString())) {
                repository.setProperty("p2.system", Boolean.TRUE.toString());
            }
            return repository;
        }
        catch (ProvisionException provisionException) {
            String repositoryName = "update site: " + location.toExternalForm();
            Properties props = new Properties();
            props.put("p2.system", Boolean.TRUE.toString());
            return factory.create(localRepositoryURL, repositoryName, null, (Map)props);
        }
    }

    public void initializeRepository(IArtifactRepository repository, URL location, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite = UpdateSite.load(location, null);
        String savedChecksum = (String)repository.getProperties().get(PROP_SITE_CHECKSUM);
        if (savedChecksum != null && savedChecksum.equals(updateSite.getChecksum())) {
            return;
        }
        if (!location.getProtocol().equals(PROTOCOL_FILE)) {
            repository.setProperty(PROP_FORCE_THREADING, "true");
        }
        repository.setProperty(PROP_SITE_CHECKSUM, updateSite.getChecksum());
        repository.removeAll();
        this.generateArtifactDescriptors(updateSite, repository);
    }

    private void generateArtifactDescriptors(UpdateSite updateSite, IArtifactRepository repository) throws ProvisionException {
        Feature[] features = updateSite.loadFeatures();
        HashSet<ArtifactDescriptor> allSiteArtifacts = new HashSet<ArtifactDescriptor>();
        int i = 0;
        while (i < features.length) {
            Feature feature = features[i];
            IArtifactKey featureKey = FeaturesAction.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion());
            ArtifactDescriptor featureArtifactDescriptor = new ArtifactDescriptor(featureKey);
            URL featureURL = updateSite.getFeatureURL(feature.getId(), feature.getVersion());
            featureArtifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, featureURL.toExternalForm());
            allSiteArtifacts.add(featureArtifactDescriptor);
            FeatureEntry[] featureEntries = feature.getEntries();
            int j = 0;
            while (j < featureEntries.length) {
                FeatureEntry entry = featureEntries[j];
                if (entry.isPlugin() && !entry.isRequires()) {
                    IArtifactKey key = PublisherHelper.createBundleArtifactKey((String)entry.getId(), (String)entry.getVersion());
                    ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor(key);
                    URL pluginURL = updateSite.getPluginURL(entry);
                    artifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, pluginURL.toExternalForm());
                    allSiteArtifacts.add(artifactDescriptor);
                }
                ++j;
            }
            ++i;
        }
        IArtifactDescriptor[] descriptors = allSiteArtifacts.toArray(new IArtifactDescriptor[allSiteArtifacts.size()]);
        repository.addDescriptors(descriptors);
    }
}

