/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite.metadata;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.RemoteUpdateSiteAction;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.IMetadataRepositoryFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;

public class UpdateSiteMetadataRepositoryFactory
implements IMetadataRepositoryFactory {
    private static final String PROP_SITE_CHECKSUM = "site.checksum";

    public static URL getLocalRepositoryLocation(URL location) throws ProvisionException {
        URL localRepositoryURL = null;
        try {
            String stateDirName = Integer.toString(location.toExternalForm().hashCode());
            File bundleData = Activator.getBundleContext().getDataFile(null);
            File stateDir = new File(bundleData, stateDirName);
            localRepositoryURL = stateDir.toURL();
        }
        catch (MalformedURLException e) {
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, Messages.ErrorCreatingRepository, (Throwable)e));
        }
        return localRepositoryURL;
    }

    public IMetadataRepository create(URL location, String name, String type, Map properties) {
        return null;
    }

    public IStatus validate(URL location, IProgressMonitor monitor) {
        try {
            UpdateSite.validate(location, monitor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IMetadataRepository load(URL location, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepository repository = this.loadRepository(location, monitor);
        this.initializeRepository(repository, location, monitor);
        return repository;
    }

    public IMetadataRepository loadRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        URL localRepositoryURL = UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation(location);
        SimpleMetadataRepositoryFactory factory = new SimpleMetadataRepositoryFactory();
        try {
            IMetadataRepository repository = factory.load(localRepositoryURL, null);
            if (!repository.getProperties().get("p2.system").equals(Boolean.TRUE.toString())) {
                repository.setProperty("p2.system", Boolean.TRUE.toString());
            }
            return repository;
        }
        catch (ProvisionException provisionException) {
            String repositoryName = "update site: " + location.toExternalForm();
            Properties props = new Properties();
            props.put("p2.system", Boolean.TRUE.toString());
            return factory.create(localRepositoryURL, repositoryName, null, (Map)props);
        }
    }

    public void initializeRepository(IMetadataRepository repository, URL location, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite = UpdateSite.load(location, null);
        String savedChecksum = (String)repository.getProperties().get(PROP_SITE_CHECKSUM);
        if (savedChecksum != null && savedChecksum.equals(updateSite.getChecksum())) {
            return;
        }
        repository.setProperty(PROP_SITE_CHECKSUM, updateSite.getChecksum());
        repository.removeAll();
        this.generateMetadata(updateSite, repository);
    }

    private void generateMetadata(UpdateSite updateSite, IMetadataRepository repository) {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository(repository);
        IPublisherAction[] actions = new IPublisherAction[]{new RemoteUpdateSiteAction(updateSite)};
        Publisher publisher = new Publisher((IPublisherInfo)info);
        publisher.publish(actions);
    }
}

