/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ui.editor.PDEHyperlinkDetector;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.JavaHyperlink;
import org.eclipse.pde.internal.ui.editor.text.ResourceHyperlink;

public class DSHyperlinkDetector
extends PDEHyperlinkDetector {
    public DSHyperlinkDetector(PDESourcePage page) {
        super(page);
    }

    protected IHyperlink[] detectAttributeHyperlink(IDocumentAttributeNode attr) {
        String attrValue = attr.getAttributeValue();
        if (attrValue.length() == 0) {
            return null;
        }
        IDSObject node = (IDSObject)attr.getEnclosingElement();
        if (node == null || !node.getModel().isEditable()) {
            return null;
        }
        Region linkRegion = new Region(attr.getValueOffset(), attr.getValueLength());
        IHyperlink[] link = new IHyperlink[1];
        IDSModel base = node.getModel();
        IResource res = base.getUnderlyingResource();
        if (node instanceof IDSImplementation) {
            link[0] = new JavaHyperlink((IRegion)linkRegion, attrValue, res);
        } else if (node instanceof IDSComponent) {
            if (attr.getAttributeName().equals("factory")) {
                link[0] = new JavaHyperlink((IRegion)linkRegion, attrValue, res);
            }
        } else if (node instanceof IDSReference) {
            if (attr.getAttributeName().equals("interface")) {
                link[0] = new JavaHyperlink((IRegion)linkRegion, attrValue, res);
            }
        } else if (node instanceof IDSProperty) {
            if (attr.getAttributeName().equals("type")) {
                link[0] = new JavaHyperlink((IRegion)linkRegion, attrValue, res);
            }
        } else if (node instanceof IDSProvide) {
            if (attr.getAttributeName().equals("interface")) {
                link[0] = new JavaHyperlink((IRegion)linkRegion, attrValue, res);
            }
        } else if (node instanceof IDSProperties && attr.getAttributeName().equals("entry")) {
            link[0] = new ResourceHyperlink((IRegion)linkRegion, attrValue, res);
        }
        if (link[0] != null) {
            return link;
        }
        return null;
    }

    protected IHyperlink[] detectNodeHyperlink(IDocumentElementNode node) {
        return null;
    }

    protected IHyperlink[] detectTextNodeHyperlink(IDocumentTextNode node) {
        return null;
    }
}

