/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.SharedImages;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.IFormPage;

public class DSLabelProvider
extends LabelProvider {
    public String getText(Object obj) {
        if (obj instanceof IDSObject) {
            return this.getObjectText((IDSObject)obj);
        }
        if (obj instanceof IFormPage) {
            return ((IFormPage)obj).getTitle();
        }
        return super.getText(obj);
    }

    public String getObjectText(IDSObject obj) {
        if (obj.getType() == 4) {
            return Messages.DSService_title;
        }
        return obj.getName();
    }

    public Image getImage(Object obj) {
        if (obj instanceof IDSObject) {
            return this.getObjectImage((IDSObject)obj);
        }
        if (obj instanceof IFormPage) {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PAGE_OBJ);
        }
        return super.getImage(obj);
    }

    private Image getObjectImage(IDSObject obj) {
        if (obj.getType() == 1) {
            return SharedImages.getImage("icons/obj16/class_obj.gif");
        }
        if (obj.getType() == 2) {
            return SharedImages.getImage("icons/obj16/properties_obj.gif");
        }
        if (obj.getType() == 3) {
            return SharedImages.getImage("icons/obj16/property_obj.gif");
        }
        if (obj.getType() == 5) {
            return SharedImages.getImage("icons/obj16/service_obj.gif");
        }
        if (obj.getType() == 6) {
            IDSReference reference = (IDSReference)obj;
            int flags = 0;
            if (reference.getReferencePolicy().equals("dynamic")) {
                flags |= 1;
            }
            if (reference.getReferenceCardinality().equals("0..1")) {
                return SharedImages.getImage("icons/obj16/reference_zero_one_obj.gif", flags);
            }
            if (reference.getReferenceCardinality().equals("0..n")) {
                return SharedImages.getImage("icons/obj16/reference_zero_n_obj.gif", flags);
            }
            if (reference.getReferenceCardinality().equals("1..n")) {
                return SharedImages.getImage("icons/obj16/reference_one_n_obj.gif", flags);
            }
            return SharedImages.getImage("icons/obj16/reference_obj.gif", flags);
        }
        if (obj.getType() == 0) {
            return SharedImages.getImage("icons/obj16/component_obj.gif");
        }
        if (obj.getType() == 4) {
            return SharedImages.getImage("icons/obj16/services_obj.gif");
        }
        return null;
    }
}

