/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.editor.DSInputContext;
import org.eclipse.pde.internal.ds.ui.editor.DSLabelProvider;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.editor.dialogs.DSEditReferenceDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DSReferenceSection
extends TableSection {
    private TableViewer fReferencesTable;
    private Action fRemoveAction;
    private Action fAddAction;
    private Action fEditAction;

    public DSReferenceSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{Messages.DSReferenceSection_add, Messages.DSReferenceSection_remove, Messages.DSReferenceSection_edit});
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(Messages.DSReferenceSection_title);
        section.setDescription(Messages.DSReferenceSection_description);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.isEditable());
        this.createViewerPartControl(container, 65538, 2, toolkit);
        this.fReferencesTable = tablePart.getTableViewer();
        this.fReferencesTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fReferencesTable.setLabelProvider((IBaseLabelProvider)new DSLabelProvider());
        this.makeActions();
        IDSModel model = this.getDSModel();
        if (model != null) {
            this.fReferencesTable.setInput((Object)model);
            model.addModelChangedListener((IModelChangedListener)this);
        }
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        IDSModel model = this.getDSModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
    }

    public void refresh() {
        this.fReferencesTable.refresh();
        this.updateButtons();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleEdit();
            }
        }
    }

    private void handleEdit() {
        int selectionIndex;
        ISelection selection = this.fReferencesTable.getSelection();
        if (selection != null && (selectionIndex = this.fReferencesTable.getTable().getSelectionIndex()) != -1) {
            DSEditReferenceDialog dialog = new DSEditReferenceDialog(Activator.getActiveWorkbenchShell(), (IDSReference)this.fReferencesTable.getElementAt(selectionIndex), this);
            dialog.create();
            dialog.getShell().setSize(500, 400);
            dialog.open();
        }
    }

    private void makeActions() {
        this.fAddAction = new Action(Messages.DSReferenceSection_add){

            public void run() {
                DSReferenceSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(Messages.DSReferenceSection_remove){

            public void run() {
                DSReferenceSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
        this.fEditAction = new Action(Messages.DSReferenceSection_edit){

            public void run() {
                DSReferenceSection.this.handleEdit();
            }
        };
        this.fEditAction.setEnabled(this.isEditable());
    }

    private void updateButtons() {
        Table table = this.fReferencesTable.getTable();
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable() && table.getSelection().length > 0);
        tablePart.setButtonEnabled(2, this.isEditable() && table.getSelection().length > 0);
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fReferencesTable.getSelection();
        if (ssel.size() > 0) {
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof IDSReference)) continue;
                this.getDSModel().getDSComponent().removeReference((IDSReference)object);
            }
        }
    }

    private void handleAdd() {
        this.doOpenSelectionDialog(4);
    }

    private void doOpenSelectionDialog(int scopeType) {
        try {
            String filter = "";
            filter = filter.substring(filter.lastIndexOf(".") + 1);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Activator.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)false, (String)filter);
            dialog.setTitle(Messages.DSReferenceDetails_selectType);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                String fullyQualifiedName = type.getFullyQualifiedName('$');
                this.addReference(fullyQualifiedName);
            }
        }
        catch (CoreException coreException) {}
    }

    private void addReference(String fullyQualifiedName) {
        IDSReference reference = this.getDSModel().getFactory().createReference();
        reference.setReferenceInterface(fullyQualifiedName);
        int index = fullyQualifiedName.lastIndexOf(".");
        if (index != -1) {
            fullyQualifiedName = fullyQualifiedName.substring(index + 1);
        }
        reference.setReferenceName(fullyQualifiedName);
        this.getDSModel().getDSComponent().addReference(reference);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        } else if (e.getChangeType() == 2) {
            Object[] objects = e.getChangedObjects();
            int i = 0;
            while (i < objects.length) {
                Table table = this.fReferencesTable.getTable();
                if (objects[i] instanceof IDSReference) {
                    int index = table.getSelectionIndex();
                    this.fReferencesTable.remove(objects[i]);
                    if (this.canSelect()) {
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                    }
                }
                ++i;
            }
            this.updateButtons();
        } else if (e.getChangeType() == 1) {
            Object[] objects = e.getChangedObjects();
            if (objects.length > 0) {
                this.fReferencesTable.refresh();
                this.fReferencesTable.setSelection((ISelection)new StructuredSelection(objects[objects.length - 1]));
            }
            this.updateButtons();
        } else {
            this.fReferencesTable.refresh();
            this.updateButtons();
        }
    }

    private DSInputContext getDSContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (DSInputContext)manager.findContext("ds-context");
    }

    private IDSModel getDSModel() {
        DSInputContext context = this.getDSContext();
        return context == null ? null : (IDSModel)context.getModel();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDSModel model;
            IDSComponent component;
            if (inputElement instanceof IDSModel && (component = (model = (IDSModel)inputElement).getDSComponent()) != null) {
                return component.getReferences();
            }
            return new Object[0];
        }
    }
}

