/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.SWTUtil;
import org.eclipse.pde.internal.ds.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.parts.FormEntry;
import org.eclipse.pde.internal.ds.ui.wizards.DSNewClassCreationWizard;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DSServiceComponentSection
extends PDESection {
    private IDSComponent fComponent;
    private IDSImplementation fImplementation;
    private FormEntry fClassEntry;
    private FormEntry fNameEntry;
    private IDSModel fModel;
    private Button fImmediateButton;
    private Button fEnabledButton;

    public DSServiceComponentSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.initializeAttributes();
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        section.setText(Messages.DSSection_title);
        section.setDescription(Messages.DSSection_description);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout(3, false));
        client.setLayoutData((Object)new GridData(768));
        this.fNameEntry = new FormEntry(client, toolkit, Messages.DSComponentDetails_nameEntry, 0);
        this.fClassEntry = new FormEntry(client, toolkit, Messages.DSImplementationDetails_classEntry, Messages.DSImplementationDetails_browse, this.isEditable(), 0);
        this.createButtons(client, toolkit);
        this.setListeners();
        this.updateUIFields();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    private void createButtons(Composite parent, FormToolkit toolkit) {
        this.fEnabledButton = toolkit.createButton(parent, Messages.DSServiceComponentSection_enabledButtonMessage, 32);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fEnabledButton.setLayoutData((Object)data);
        this.fEnabledButton.setEnabled(this.isEditable());
        this.fEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSServiceComponentSection.this.fModel.getDSComponent().setEnabled(DSServiceComponentSection.this.fEnabledButton.getSelection());
            }
        });
        this.fImmediateButton = toolkit.createButton(parent, Messages.DSServiceComponentSection_immediateButtonMessage, 32);
        this.fImmediateButton.setLayoutData((Object)data);
        this.fImmediateButton.setEnabled(this.isEditable());
        this.fImmediateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSServiceComponentSection.this.fModel.getDSComponent().setImmediate(DSServiceComponentSection.this.fImmediateButton.getSelection());
            }
        });
    }

    private void initializeAttributes() {
        this.fModel = (IDSModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        this.fComponent = this.fModel.getDSComponent();
        if (this.fComponent != null) {
            this.fImplementation = this.fComponent.getImplementation();
        }
    }

    public void commit(boolean onSave) {
        this.fClassEntry.commit();
        this.fNameEntry.commit();
        super.commit(onSave);
    }

    public void modelChanged(IModelChangedEvent e) {
        this.fComponent = this.fModel.getDSComponent();
        if (this.fComponent != null) {
            this.fImplementation = this.fComponent.getImplementation();
        }
        if (e.getChangeType() == 99) {
            this.markStale();
        }
        if (this.fNameEntry != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DSServiceComponentSection.this.updateUIFields();
                }
            });
        }
    }

    public void updateUIFields() {
        if (this.fComponent != null) {
            if (this.fComponent.getAttributeName() == null) {
                this.fNameEntry.setValue("", true);
            } else {
                this.fNameEntry.setValue(this.fComponent.getAttributeName(), true);
            }
            if (this.fComponent.getEnabled()) {
                this.fEnabledButton.setSelection(true);
            }
            if (this.fComponent.getImmediate()) {
                this.fImmediateButton.setSelection(true);
            }
            this.fNameEntry.setEditable(this.isEditable());
        }
        if (this.fImplementation != null) {
            if (this.fImplementation.getClassName() == null) {
                this.fClassEntry.setValue("", true);
            } else {
                this.fClassEntry.setValue(this.fImplementation.getClassName(), true);
            }
            this.fClassEntry.setEditable(this.isEditable());
        }
    }

    public void setListeners() {
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (DSServiceComponentSection.this.fComponent == null) {
                    return;
                }
                DSServiceComponentSection.this.fComponent.setAttributeName(DSServiceComponentSection.this.fNameEntry.getValue());
            }
        });
        IActionBars actionBars = this.getPage().getEditor().getEditorSite().getActionBars();
        this.fClassEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this, actionBars){

            public void textValueChanged(FormEntry entry) {
                if (DSServiceComponentSection.this.fImplementation == null) {
                    return;
                }
                DSServiceComponentSection.this.fImplementation.setClassName(DSServiceComponentSection.this.fClassEntry.getValue());
            }

            public void linkActivated(HyperlinkEvent e) {
                String value = DSServiceComponentSection.this.fClassEntry.getValue();
                if ((value = DSServiceComponentSection.this.handleLinkActivated(value, false)) != null) {
                    DSServiceComponentSection.this.fClassEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                DSServiceComponentSection.this.doOpenSelectionDialog(2, DSServiceComponentSection.this.fClassEntry);
            }
        });
    }

    private String handleLinkActivated(String value, boolean isInter) {
        IProject project = this.getProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType element = javaProject.findType(value.replace('$', '.'));
                if (element != null) {
                    JavaUI.openInEditor((IJavaElement)element);
                } else {
                    DSNewClassCreationWizard wizard = new DSNewClassCreationWizard(project, isInter, value);
                    WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    if (dialog.open() == 0) {
                        return wizard.getQualifiedName();
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    private void doOpenSelectionDialog(int scopeType, FormEntry entry) {
        try {
            String filter = entry.getValue();
            filter = filter.substring(filter.lastIndexOf(".") + 1);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Activator.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)false, (String)filter);
            dialog.setTitle(Messages.DSImplementationDetails_selectType);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                entry.setValue(type.getFullyQualifiedName('$'));
                entry.commit();
            }
        }
        catch (CoreException coreException) {}
    }
}

