/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class TypeCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension3,
ICompletionProposalExtension5 {
    protected String fReplacementString;
    protected Image fImage;
    protected String fDisplayString;
    protected int fBeginInsertPoint;
    protected int fLength;
    protected String fAdditionalInfo;
    private IInformationControlCreator fCreator;

    public TypeCompletionProposal(String replacementString, Image image, String displayString) {
        this(replacementString, image, displayString, 0, 0);
    }

    public TypeCompletionProposal(String replacementString, Image image, String displayString, int startOffset, int length) {
        Assert.isNotNull((Object)replacementString);
        this.fReplacementString = replacementString;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fBeginInsertPoint = startOffset;
        this.fLength = length;
    }

    public void apply(IDocument document) {
        if (this.fLength == -1) {
            String current = document.get();
            this.fLength = current.length();
        }
        try {
            document.replace(this.fBeginInsertPoint, this.fLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument document) {
        if (this.fReplacementString.equals("\"\"")) {
            return new Point(this.fBeginInsertPoint + 1, 0);
        }
        return new Point(this.fBeginInsertPoint + this.fReplacementString.length(), 0);
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.fAdditionalInfo;
    }

    public void setAdditionalProposalInfo(String info) {
        this.fAdditionalInfo = info;
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (!BrowserInformationControl.isAvailable(null)) {
            return null;
        }
        if (this.fCreator == null) {
            this.fCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    return new BrowserInformationControl(parent, "org.eclipse.jface.dialogfont", EditorsUI.getTooltipAffordanceString());
                }
            };
        }
        return this.fCreator;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.fBeginInsertPoint;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fReplacementString;
    }
}

