/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.wizards;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class DSCreationOperation
extends WorkspaceModifyOperation {
    protected IFile fFile;
    private String fComponentName;
    private String fImplementationClass;

    public DSCreationOperation(IFile file, String componentName, String implementationClass) {
        this.fFile = file;
        this.fComponentName = componentName;
        this.fImplementationClass = implementationClass;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.DSCreationOperation_title, 2);
        this.createContent();
        monitor.worked(1);
        this.openFile();
        this.writeDSPropIntoManifest(this.fFile.getProject(), new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    private void writeDSPropIntoManifest(IProject project, SubProgressMonitor monitor) {
        PDEModelUtility.modifyModel((ModelModification)new ModelModification(project){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    DSCreationOperation.this.updateManifest((IBundlePluginModelBase)model, monitor);
                }
            }
        }, (IProgressMonitor)monitor);
        monitor.done();
    }

    private void updateManifest(IBundlePluginModelBase model, IProgressMonitor monitor) throws CoreException {
        IBundleModel bundleModel = model.getBundleModel();
        String filePath = this.fFile.getFullPath().toOSString();
        int index = (filePath = filePath.substring(1)).indexOf("\\");
        if (index > -1) {
            String dsFilePath = filePath.substring(index + 1);
            bundleModel.getBundle().setHeader("Service-Component", dsFilePath);
        }
    }

    protected void createContent() throws CoreException {
        DSModel model = new DSModel((IDocument)CoreUtility.getTextDocument((InputStream)this.fFile.getContents()), false);
        model.setUnderlyingResource((IResource)this.fFile);
        this.initializeDS(model.getDSComponent(), this.fFile);
        model.save();
        model.dispose();
    }

    protected void initializeDS(IDSComponent component, IFile file) {
        IDSDocumentFactory factory = component.getModel().getFactory();
        IDSImplementation implementation = factory.createImplementation();
        implementation.setClassName(this.fImplementationClass);
        component.setImplementation(implementation);
        component.setAttributeName(this.fComponentName);
        try {
            IProject project = file.getProject();
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals("org.eclipse.pde.ds.core.builder")) {
                    return;
                }
                ++i;
            }
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            ICommand command = description.newCommand();
            command.setBuilderName("org.eclipse.pde.ds.core.builder");
            newCommands[newCommands.length - 1] = command;
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            Activator.logException(e, null, null);
        }
    }

    private void openFile() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = Activator.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null || !DSCreationOperation.this.fFile.exists()) {
                    return;
                }
                IWorkbenchPart focusPart = page.getActivePart();
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)DSCreationOperation.this.fFile);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)DSCreationOperation.this.fFile);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

