/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class DSFileWizardPage
extends WizardNewFileCreationPage {
    public static final String F_PAGE_NAME = "ds";
    private static final String F_FILE_EXTENSION = "xml";
    private Group fGroup;
    private Text fDSComponentNameText;
    private Label fDSComponentNameLabel;
    private Text fDSImplementationClassText;
    private Label fDSImplementationClassLabel;
    private Button fDSImplementationClassButton;
    private Composite fImplementationComposite;

    public DSFileWizardPage(IStructuredSelection selection) {
        super(F_PAGE_NAME, selection);
        this.initialize();
    }

    protected void initialize() {
        this.setTitle(Messages.DSFileWizardPage_title);
        this.setDescription(Messages.DSFileWizardPage_description);
        this.setFileExtension(F_FILE_EXTENSION);
    }

    protected void createAdvancedControls(Composite parent) {
        this.fGroup = new Group(parent, 0);
        this.fGroup.setText(Messages.DSFileWizardPage_group);
        this.fGroup.setLayout((Layout)new GridLayout(2, false));
        this.fGroup.setLayoutData((Object)new GridData(768));
        GridData textGridData = new GridData(768);
        textGridData.widthHint = 20;
        textGridData.horizontalSpan = 1;
        textGridData.horizontalIndent = 3;
        this.fDSComponentNameLabel = new Label((Composite)this.fGroup, 0);
        this.fDSComponentNameLabel.setText(Messages.DSFileWizardPage_component_name);
        this.fDSComponentNameText = new Text((Composite)this.fGroup, 0);
        this.fDSComponentNameText.setLayoutData((Object)textGridData);
        this.fDSComponentNameText.setText("");
        this.fDSComponentNameText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!DSFileWizardPage.this.fDSComponentNameText.getText().equals("")) {
                    return;
                }
                String text = DSFileWizardPage.this.getFileName();
                if (text != null && text != "") {
                    int index = text.lastIndexOf(".");
                    if (index > 0) {
                        DSFileWizardPage.this.fDSComponentNameText.setText(text.substring(0, index));
                    } else {
                        DSFileWizardPage.this.fDSComponentNameText.setText(text);
                    }
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.fDSComponentNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DSFileWizardPage.this.setPageComplete(DSFileWizardPage.this.checkPageComplete());
            }
        });
        this.fImplementationComposite = new Composite((Composite)this.fGroup, 0);
        this.fImplementationComposite.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.fImplementationComposite.setLayoutData((Object)data);
        this.fDSImplementationClassLabel = new Label(this.fImplementationComposite, 0);
        this.fDSImplementationClassLabel.setText(Messages.DSFileWizardPage_implementation_class);
        this.fDSImplementationClassText = new Text(this.fImplementationComposite, 0);
        this.fDSImplementationClassText.setLayoutData((Object)textGridData);
        this.fDSImplementationClassText.setText("");
        this.fDSImplementationClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DSFileWizardPage.this.setPageComplete(DSFileWizardPage.this.checkPageComplete());
            }
        });
        this.fDSImplementationClassButton = new Button(this.fImplementationComposite, 0);
        this.fDSImplementationClassButton.setText(Messages.DSFileWizardPage_browse);
        this.fDSImplementationClassButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                this.doOpenSelectionDialog(2, DSFileWizardPage.this.fDSImplementationClassText);
            }

            private void doOpenSelectionDialog(int scopeType, Text entry) {
                try {
                    String filter = entry.getText();
                    filter = filter.substring(filter.lastIndexOf(".") + 1);
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Activator.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)false, (String)filter);
                    dialog.setTitle(Messages.DSFileWizardPage_selectType);
                    if (dialog.open() == 0) {
                        IType type = (IType)dialog.getResult()[0];
                        entry.setText(type.getFullyQualifiedName('$'));
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    public String getDSComponentNameValue() {
        return this.fDSComponentNameText.getText();
    }

    public String getDSImplementationClassValue() {
        return this.fDSImplementationClassText.getText();
    }

    private boolean checkPageComplete() {
        return this.fDSComponentNameText.getText().length() > 0 && this.fDSImplementationClassText.getText().length() > 0;
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, "org.eclipse.pde.ds.ui", 0, "", null);
    }

    protected void createLinkTarget() {
    }

    public boolean isPageComplete() {
        return this.checkPageComplete();
    }
}

