/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaModel;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.AsynchronousJpaProjectUpdater;
import org.eclipse.jpt.core.internal.SimpleJpaProjectConfig;
import org.eclipse.jpt.core.internal.resource.orm.OrmResourceModelProvider;
import org.eclipse.jpt.core.internal.resource.persistence.PersistenceResourceModelProvider;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaModel
extends AbstractModel
implements JpaModel {
    private final ArrayList<JpaProjectHolder> jpaProjectHolders = new ArrayList();
    private static final boolean DEBUG = false;

    GenericJpaModel() throws CoreException {
        ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)new ResourceProxyVisitor(), 0);
    }

    @Override
    public synchronized JpaProject getJpaProject(IProject project) throws CoreException {
        return this.getJpaProjectHolder(project).jpaProject();
    }

    @Override
    public synchronized boolean containsJpaProject(IProject project) {
        return this.getJpaProjectHolder(project).holdsJpaProjectFor(project);
    }

    @Override
    public synchronized Iterator<JpaProject> jpaProjects() throws CoreException {
        ArrayList<JpaProject> jpaProjects = new ArrayList<JpaProject>(this.jpaProjectHolders.size());
        for (JpaProjectHolder holder : this.jpaProjectHolders) {
            jpaProjects.add(holder.jpaProject());
        }
        return jpaProjects.iterator();
    }

    @Override
    public synchronized int jpaProjectsSize() {
        return this.jpaProjectHolders.size();
    }

    @Override
    public synchronized JpaFile getJpaFile(IFile file) throws CoreException {
        JpaProject jpaProject = this.getJpaProject(file.getProject());
        return jpaProject == null ? null : jpaProject.getJpaFile(file);
    }

    private JpaProjectHolder getJpaProjectHolder(IProject project) {
        for (JpaProjectHolder holder : this.jpaProjectHolders) {
            if (!holder.holdsJpaProjectFor(project)) continue;
            return holder;
        }
        return NullJpaProjectHolder.instance();
    }

    private JpaProject.Config buildJpaProjectConfig(IProject project) {
        SimpleJpaProjectConfig config = new SimpleJpaProjectConfig();
        config.setProject(project);
        config.setJpaPlatform(JptCorePlugin.getJpaPlatform(project));
        config.setConnectionProfileName(JptCorePlugin.getConnectionProfileName(project));
        config.setUserOverrideDefaultSchemaName(JptCorePlugin.getUserOverrideDefaultSchemaName(project));
        config.setDiscoverAnnotatedClasses(JptCorePlugin.discoverAnnotatedClasses(project));
        return config;
    }

    void addJpaProject(IProject project) {
        this.addJpaProject(this.buildJpaProjectConfig(project));
    }

    private void addJpaProject(JpaProject.Config config) {
        GenericJpaModel.dumpStackTrace();
        this.jpaProjectHolders.add(this.getJpaProjectHolder(config.getProject()).buildJpaProjectHolder(this, config));
    }

    private void removeJpaProject(IProject project) {
        GenericJpaModel.dumpStackTrace();
        this.getJpaProjectHolder(project).remove();
    }

    synchronized void projectPreDelete(IProject project) {
        this.removeJpaProject(project);
    }

    synchronized void synchronizeFiles(IProject project, IResourceDelta delta) throws CoreException {
        this.getJpaProjectHolder(project).synchronizeJpaFiles(delta);
    }

    synchronized void checkForTransition(IProject project) {
        boolean jpaFacet = JptCorePlugin.projectHasJpaFacet(project);
        boolean jpaProject = this.containsJpaProject(project);
        if (jpaFacet) {
            if (!jpaProject) {
                this.addJpaProject(project);
            }
        } else if (jpaProject) {
            this.removeJpaProject(project);
        }
    }

    synchronized void jpaFacetedProjectPostInstall(IProjectFacetActionEvent event) {
        IProject project = event.getProject().getProject();
        IDataModel dataModel = (IDataModel)event.getActionConfig();
        boolean buildOrmXml = dataModel.getBooleanProperty("JpaFacetDataModelProperties.CREATE_ORM_XML");
        this.buildProjectXmlJob(project, buildOrmXml).schedule();
        this.addJpaProject(project);
    }

    private Job buildProjectXmlJob(final IProject project, final boolean buildOrmXml) {
        Job job = new Job("Create Project XML files"){

            protected IStatus run(IProgressMonitor monitor) {
                GenericJpaModel.this.createProjectXml(project, buildOrmXml);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        return job;
    }

    void createProjectXml(IProject project, boolean buildOrmXml) {
        this.createPersistenceXml(project);
        if (buildOrmXml) {
            this.createOrmXml(project);
        }
    }

    private void createPersistenceXml(IProject project) {
        PersistenceResourceModelProvider modelProvider = PersistenceResourceModelProvider.getDefaultModelProvider(project);
        try {
            modelProvider.createResource();
        }
        catch (Exception e) {
            JptCorePlugin.log(e);
        }
    }

    private void createOrmXml(IProject project) {
        OrmResourceModelProvider modelProvider = OrmResourceModelProvider.getDefaultModelProvider(project);
        try {
            modelProvider.createResource();
        }
        catch (Exception e) {
            JptCorePlugin.log(e);
        }
    }

    private EList<EObject> getResourceContents(OrmResource resource) {
        return resource.getContents();
    }

    synchronized void jpaFacetedProjectPreUninstall(IProjectFacetActionEvent event) {
        this.removeJpaProject(event.getProject().getProject());
    }

    synchronized void javaElementChanged(ElementChangedEvent event) {
        for (JpaProjectHolder jpaProjectHolder : this.jpaProjectHolders) {
            jpaProjectHolder.javaElementChanged(event);
        }
    }

    synchronized void rebuildJpaProject(IProject project) {
        this.removeJpaProject(project);
        this.addJpaProject(project);
    }

    synchronized void dispose() {
        JpaProjectHolder[] holders;
        JpaProjectHolder[] jpaProjectHolderArray = holders = this.jpaProjectHolders.toArray(new JpaProjectHolder[this.jpaProjectHolders.size()]);
        int n = holders.length;
        int n2 = 0;
        while (n2 < n) {
            JpaProjectHolder holder = jpaProjectHolderArray[n2];
            holder.remove();
            ++n2;
        }
    }

    public void toString(StringBuilder sb) {
        sb.append("JPA projects size: " + this.jpaProjectsSize());
    }

    void jpaProjectBuilt(JpaProject jpaProject) {
        this.fireItemAdded("jpaProjects", jpaProject);
    }

    void jpaProjectRemoved(JpaProject jpaProject) {
        this.fireItemRemoved("jpaProjects", jpaProject);
    }

    void removeJpaProjectHolder(JpaProjectHolder jpaProjectHolder) {
        this.jpaProjectHolders.remove(jpaProjectHolder);
    }

    private static void dumpStackTrace() {
    }

    private static class DefaultJpaProjectHolder
    implements JpaProjectHolder {
        private final GenericJpaModel jpaModel;
        private final JpaProject.Config config;
        private JpaProject jpaProject;

        DefaultJpaProjectHolder(GenericJpaModel jpaModel, JpaProject.Config config) {
            this.jpaModel = jpaModel;
            this.config = config;
        }

        public boolean holdsJpaProjectFor(IProject project) {
            return this.config.getProject().equals((Object)project);
        }

        public JpaProject jpaProject() throws CoreException {
            if (this.jpaProject == null) {
                this.jpaProject = this.buildJpaProject();
                this.jpaModel.jpaProjectBuilt(this.jpaProject);
            }
            return this.jpaProject;
        }

        private JpaProject buildJpaProject() throws CoreException {
            JpaProject jpaProject = this.config.getJpaPlatform().getJpaFactory().buildJpaProject(this.config);
            jpaProject.setUpdater(new AsynchronousJpaProjectUpdater(jpaProject));
            return jpaProject;
        }

        public void synchronizeJpaFiles(IResourceDelta delta) throws CoreException {
            if (this.jpaProject != null) {
                this.jpaProject.synchronizeJpaFiles(delta);
            }
        }

        public void javaElementChanged(ElementChangedEvent event) {
            if (this.jpaProject != null) {
                this.jpaProject.javaElementChanged(event);
            }
        }

        public JpaProjectHolder buildJpaProjectHolder(GenericJpaModel jm, JpaProject.Config c) {
            throw new IllegalArgumentException(c.getProject().getName());
        }

        public void remove() {
            this.jpaModel.removeJpaProjectHolder(this);
            if (this.jpaProject != null) {
                this.jpaModel.jpaProjectRemoved(this.jpaProject);
                this.jpaProject.dispose();
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.config.getProject().getName());
        }
    }

    private static interface JpaProjectHolder {
        public boolean holdsJpaProjectFor(IProject var1);

        public JpaProject jpaProject() throws CoreException;

        public void synchronizeJpaFiles(IResourceDelta var1) throws CoreException;

        public void javaElementChanged(ElementChangedEvent var1);

        public JpaProjectHolder buildJpaProjectHolder(GenericJpaModel var1, JpaProject.Config var2);

        public void remove();
    }

    private static class NullJpaProjectHolder
    implements JpaProjectHolder {
        private static final JpaProjectHolder INSTANCE = new NullJpaProjectHolder();

        static JpaProjectHolder instance() {
            return INSTANCE;
        }

        private NullJpaProjectHolder() {
        }

        public boolean holdsJpaProjectFor(IProject project) {
            return false;
        }

        public JpaProject jpaProject() throws CoreException {
            return null;
        }

        public void synchronizeJpaFiles(IResourceDelta delta) throws CoreException {
        }

        public void javaElementChanged(ElementChangedEvent event) {
        }

        public JpaProjectHolder buildJpaProjectHolder(GenericJpaModel jpaModel, JpaProject.Config config) {
            return new DefaultJpaProjectHolder(jpaModel, config);
        }

        public void remove() {
        }

        public String toString() {
            return ClassTools.shortClassNameForObject((Object)this);
        }
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        ResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) throws CoreException {
            switch (resourceProxy.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    this.checkProject(resourceProxy);
                    return false;
                }
            }
            return false;
        }

        private void checkProject(IResourceProxy resourceProxy) {
            IProject project;
            if (resourceProxy.isAccessible() && JptCorePlugin.projectHasJpaFacet(project = (IProject)resourceProxy.requestResource())) {
                GenericJpaModel.this.addJpaProject(project);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

