/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context;

import java.util.Iterator;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;

public class MappingTools {
    public static String buildJoinTableDefaultName(RelationshipMapping relationshipMapping) {
        if (!relationshipMapping.isRelationshipOwner()) {
            return null;
        }
        if (relationshipMapping.getJpaProject().getDataSource().connectionProfileIsActive()) {
            return MappingTools.buildDbJoinTableDefaultName(relationshipMapping);
        }
        String owningTableName = relationshipMapping.getTypeMapping().getPrimaryTableName();
        if (owningTableName == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        String targetTableName = targetEntity.getPrimaryTableName();
        if (targetTableName == null) {
            return null;
        }
        return String.valueOf(owningTableName) + '_' + targetTableName;
    }

    protected static String buildDbJoinTableDefaultName(RelationshipMapping relationshipMapping) {
        Table owningTable = relationshipMapping.getTypeMapping().getPrimaryDbTable();
        if (owningTable == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        Table targetTable = targetEntity.getPrimaryDbTable();
        if (targetTable == null) {
            return null;
        }
        String name = String.valueOf(owningTable.getName()) + '_' + targetTable.getName();
        return owningTable.getDatabase().convertNameToIdentifier(name);
    }

    public static String buildJoinColumnDefaultName(JoinColumn joinColumn) {
        Column targetColumn;
        JoinColumn.Owner owner = joinColumn.getOwner();
        RelationshipMapping relationshipMapping = owner.getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!relationshipMapping.isRelationshipOwner()) {
            return null;
        }
        if (owner.joinColumnsSize() != 1) {
            return null;
        }
        String prefix = owner.getAttributeName();
        if (prefix == null) {
            Entity targetEntity = owner.getTargetEntity();
            if (targetEntity == null) {
                return null;
            }
            prefix = targetEntity.getName();
        }
        if ((targetColumn = joinColumn.getReferencedDbColumn()) == null) {
            return null;
        }
        String name = String.valueOf(prefix) + '_' + targetColumn.getName();
        return name;
    }

    public static String buildJoinColumnDefaultReferencedColumnName(JoinColumn.Owner joinColumnOwner) {
        RelationshipMapping relationshipMapping = joinColumnOwner.getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!relationshipMapping.isRelationshipOwner()) {
            return null;
        }
        if (joinColumnOwner.joinColumnsSize() != 1) {
            return null;
        }
        Entity targetEntity = joinColumnOwner.getTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        return targetEntity.getPrimaryKeyColumnName();
    }

    public static Embeddable getEmbeddableFor(JavaPersistentAttribute persistentAttribute) {
        String qualifiedTypeName = persistentAttribute.getResourcePersistentAttribute().getQualifiedTypeName();
        if (qualifiedTypeName == null) {
            return null;
        }
        PersistentType persistentType = persistentAttribute.getPersistenceUnit().getPersistentType(qualifiedTypeName);
        if (persistentType == null) {
            return null;
        }
        if (persistentType.getMappingKey() == "embeddable") {
            return (Embeddable)persistentType.getMapping();
        }
        return null;
    }

    public static ColumnMapping getColumnMapping(String attributeName, Embeddable embeddable) {
        if (attributeName == null || embeddable == null) {
            return null;
        }
        Iterator<PersistentAttribute> stream = embeddable.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            PersistentAttribute persAttribute = stream.next();
            if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
            return (ColumnMapping)((Object)persAttribute.getMapping());
        }
        return null;
    }
}

