/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.java.JavaBaseColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.core.resource.java.BaseColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBaseColumn<T extends BaseColumnAnnotation>
extends AbstractJavaNamedColumn<T>
implements JavaBaseColumn {
    protected String specifiedTable;
    protected String defaultTable;
    protected Boolean specifiedUnique;
    protected Boolean specifiedNullable;
    protected Boolean specifiedInsertable;
    protected Boolean specifiedUpdatable;

    protected AbstractJavaBaseColumn(JavaJpaContextNode parent, JavaBaseColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    protected void initialize(T column) {
        super.initialize(column);
        this.defaultTable = this.defaultTable();
        this.specifiedTable = this.specifiedTable((BaseColumnAnnotation)column);
        this.specifiedUnique = this.specifiedUnique((BaseColumnAnnotation)column);
        this.specifiedNullable = this.specifiedNullable((BaseColumnAnnotation)column);
        this.specifiedInsertable = this.specifiedInsertable((BaseColumnAnnotation)column);
        this.specifiedUpdatable = this.specifiedUpdatable((BaseColumnAnnotation)column);
    }

    @Override
    public JavaBaseColumn.Owner getOwner() {
        return (JavaBaseColumn.Owner)super.getOwner();
    }

    @Override
    public String getTable() {
        return this.getSpecifiedTable() == null ? this.getDefaultTable() : this.getSpecifiedTable();
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        ((BaseColumnAnnotation)this.getResourceColumn()).setTable(newSpecifiedTable);
        this.firePropertyChanged("specifiedTable", oldSpecifiedTable, newSpecifiedTable);
    }

    protected void setSpecifiedTable_(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        this.firePropertyChanged("specifiedTable", oldSpecifiedTable, newSpecifiedTable);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String newDefaultTable) {
        String oldDefaultTable = this.defaultTable;
        this.defaultTable = newDefaultTable;
        this.firePropertyChanged("defaultTable", oldDefaultTable, newDefaultTable);
    }

    @Override
    public Boolean getUnique() {
        return this.getSpecifiedUnique() == null ? this.getDefaultUnique() : this.getSpecifiedUnique();
    }

    @Override
    public Boolean getDefaultUnique() {
        return BaseColumn.DEFAULT_UNIQUE;
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    @Override
    public void setSpecifiedUnique(Boolean newSpecifiedUnique) {
        Boolean oldSpecifiedUnique = this.specifiedUnique;
        this.specifiedUnique = newSpecifiedUnique;
        ((BaseColumnAnnotation)this.getResourceColumn()).setUnique(newSpecifiedUnique);
        this.firePropertyChanged("specifiedUnique", oldSpecifiedUnique, newSpecifiedUnique);
    }

    protected void setSpecifiedUnique_(Boolean newSpecifiedUnique) {
        Boolean oldSpecifiedUnique = this.specifiedUnique;
        this.specifiedUnique = newSpecifiedUnique;
        this.firePropertyChanged("specifiedUnique", oldSpecifiedUnique, newSpecifiedUnique);
    }

    @Override
    public Boolean getNullable() {
        return this.getSpecifiedNullable() == null ? this.getDefaultNullable() : this.getSpecifiedNullable();
    }

    @Override
    public Boolean getDefaultNullable() {
        return BaseColumn.DEFAULT_NULLABLE;
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    @Override
    public void setSpecifiedNullable(Boolean newSpecifiedNullable) {
        Boolean oldSpecifiedNullable = this.specifiedNullable;
        this.specifiedNullable = newSpecifiedNullable;
        ((BaseColumnAnnotation)this.getResourceColumn()).setNullable(newSpecifiedNullable);
        this.firePropertyChanged("specifiedNullable", oldSpecifiedNullable, newSpecifiedNullable);
    }

    protected void setSpecifiedNullable_(Boolean newSpecifiedNullable) {
        Boolean oldSpecifiedNullable = this.specifiedNullable;
        this.specifiedNullable = newSpecifiedNullable;
        this.firePropertyChanged("specifiedNullable", oldSpecifiedNullable, newSpecifiedNullable);
    }

    @Override
    public Boolean getInsertable() {
        return this.getSpecifiedInsertable() == null ? this.getDefaultInsertable() : this.getSpecifiedInsertable();
    }

    @Override
    public Boolean getDefaultInsertable() {
        return BaseColumn.DEFAULT_INSERTABLE;
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    @Override
    public void setSpecifiedInsertable(Boolean newSpecifiedInsertable) {
        Boolean oldSpecifiedInsertable = this.specifiedInsertable;
        this.specifiedInsertable = newSpecifiedInsertable;
        ((BaseColumnAnnotation)this.getResourceColumn()).setInsertable(newSpecifiedInsertable);
        this.firePropertyChanged("specifiedInsertable", oldSpecifiedInsertable, newSpecifiedInsertable);
    }

    protected void setSpecifiedInsertable_(Boolean newSpecifiedInsertable) {
        Boolean oldSpecifiedInsertable = this.specifiedInsertable;
        this.specifiedInsertable = newSpecifiedInsertable;
        this.firePropertyChanged("specifiedInsertable", oldSpecifiedInsertable, newSpecifiedInsertable);
    }

    @Override
    public Boolean getUpdatable() {
        return this.getSpecifiedUpdatable() == null ? this.getDefaultUpdatable() : this.getSpecifiedUpdatable();
    }

    @Override
    public Boolean getDefaultUpdatable() {
        return BaseColumn.DEFAULT_UPDATABLE;
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    @Override
    public void setSpecifiedUpdatable(Boolean newSpecifiedUpdatable) {
        Boolean oldSpecifiedUpdatable = this.specifiedUpdatable;
        this.specifiedUpdatable = newSpecifiedUpdatable;
        ((BaseColumnAnnotation)this.getResourceColumn()).setUpdatable(newSpecifiedUpdatable);
        this.firePropertyChanged("specifiedUpdatable", oldSpecifiedUpdatable, newSpecifiedUpdatable);
    }

    protected void setSpecifiedUpdatable_(Boolean newSpecifiedUpdatable) {
        Boolean oldSpecifiedUpdatable = this.specifiedUpdatable;
        this.specifiedUpdatable = newSpecifiedUpdatable;
        this.firePropertyChanged("specifiedUpdatable", oldSpecifiedUpdatable, newSpecifiedUpdatable);
    }

    @Override
    protected String getTableName() {
        return this.getTable();
    }

    @Override
    public TextRange getTableTextRange(CompilationUnit astRoot) {
        TextRange textRange = ((BaseColumnAnnotation)this.getResourceColumn()).getTableTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    public boolean tableTouches(int pos, CompilationUnit astRoot) {
        return ((BaseColumnAnnotation)this.getResourceColumn()).tableTouches(pos, astRoot);
    }

    private Iterator<String> candidateTableNames() {
        return this.tableIsAllowed() ? this.getOwner().getTypeMapping().associatedTableNamesIncludingInherited() : EmptyIterator.instance();
    }

    private Iterator<String> candidateTableNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateTableNames(), filter);
    }

    private Iterator<String> javaCandidateTableNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateTableNames(filter));
    }

    public abstract boolean tableIsAllowed();

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos, astRoot)) {
            return this.javaCandidateTableNames(filter);
        }
        return null;
    }

    @Override
    protected void update(T column) {
        super.update(column);
        this.setDefaultTable(this.defaultTable());
        this.setSpecifiedTable_(this.specifiedTable((BaseColumnAnnotation)column));
        this.setSpecifiedUnique_(this.specifiedUnique((BaseColumnAnnotation)column));
        this.setSpecifiedNullable_(this.specifiedNullable((BaseColumnAnnotation)column));
        this.setSpecifiedInsertable_(this.specifiedInsertable((BaseColumnAnnotation)column));
        this.setSpecifiedUpdatable_(this.specifiedUpdatable((BaseColumnAnnotation)column));
    }

    protected String defaultTable() {
        return this.getOwner().getDefaultTableName();
    }

    protected String specifiedTable(BaseColumnAnnotation column) {
        return column.getTable();
    }

    protected Boolean specifiedUnique(BaseColumnAnnotation column) {
        return column.getUnique();
    }

    protected Boolean specifiedNullable(BaseColumnAnnotation column) {
        return column.getNullable();
    }

    protected Boolean specifiedInsertable(BaseColumnAnnotation column) {
        return column.getInsertable();
    }

    protected Boolean specifiedUpdatable(BaseColumnAnnotation column) {
        return column.getUpdatable();
    }
}

