/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaGeneratedValue;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.GenericJavaNullConverter;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.core.resource.java.IdAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaIdMapping
extends AbstractJavaAttributeMapping<IdAnnotation>
implements JavaIdMapping,
PersistenceUnit.JavaGeneratorHolder,
PersistenceUnit.JavaGeneratedValueHolder {
    protected final JavaColumn column = this.createJavaColumn();
    protected JavaGeneratedValue generatedValue;
    protected JavaTableGenerator tableGenerator;
    protected JavaSequenceGenerator sequenceGenerator;
    protected final JavaConverter defaultConverter = new GenericJavaNullConverter(this);
    protected JavaConverter specifiedConverter;

    public GenericJavaIdMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected JavaColumn createJavaColumn() {
        return this.getJpaFactory().buildJavaColumn(this, this);
    }

    @Override
    public void initialize(JavaResourcePersistentAttribute jrpa) {
        super.initialize(jrpa);
        this.column.initialize(this.getResourceColumn());
        this.initializeTableGenerator(jrpa);
        this.initializeSequenceGenerator(jrpa);
        this.initializeGeneratedValue(jrpa);
        this.updatePersistenceUnitGenerators();
        this.specifiedConverter = this.buildSpecifiedConverter(this.specifiedConverterType(jrpa));
    }

    protected void initializeTableGenerator(JavaResourcePersistentAttribute jrpa) {
        TableGeneratorAnnotation resourceTableGenerator = this.getResourceTableGenerator(jrpa);
        if (resourceTableGenerator != null) {
            this.tableGenerator = this.buildTableGenerator(resourceTableGenerator);
        }
    }

    protected void initializeSequenceGenerator(JavaResourcePersistentAttribute jrpa) {
        SequenceGeneratorAnnotation resourceSequenceGenerator = this.getResourceSequenceGenerator(jrpa);
        if (resourceSequenceGenerator != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(resourceSequenceGenerator);
        }
    }

    protected void initializeGeneratedValue(JavaResourcePersistentAttribute jrpa) {
        GeneratedValueAnnotation resourceGeneratedValue = this.getResourceGeneratedValue(jrpa);
        if (resourceGeneratedValue != null) {
            this.generatedValue = this.buildGeneratedValue(resourceGeneratedValue);
        }
    }

    @Override
    public ColumnAnnotation getResourceColumn() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Id";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Column", "javax.persistence.GeneratedValue", "javax.persistence.Temporal", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public JavaGeneratedValue addGeneratedValue() {
        if (this.getGeneratedValue() != null) {
            throw new IllegalStateException("gemeratedValue already exists");
        }
        this.generatedValue = this.getJpaFactory().buildJavaGeneratedValue(this);
        GeneratedValueAnnotation generatedValueResource = (GeneratedValueAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.GeneratedValue");
        this.generatedValue.initialize(generatedValueResource);
        this.firePropertyChanged("generatedValueProperty", null, this.generatedValue);
        return this.generatedValue;
    }

    @Override
    public void removeGeneratedValue() {
        if (this.getGeneratedValue() == null) {
            throw new IllegalStateException("gemeratedValue does not exist, cannot be removed");
        }
        JavaGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = null;
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.GeneratedValue");
        this.firePropertyChanged("generatedValueProperty", oldGeneratedValue, null);
    }

    @Override
    public JavaGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    protected void setGeneratedValue(JavaGeneratedValue newGeneratedValue) {
        JavaGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = newGeneratedValue;
        this.firePropertyChanged("generatedValueProperty", oldGeneratedValue, newGeneratedValue);
    }

    @Override
    public JavaTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        this.tableGenerator = this.getJpaFactory().buildJavaTableGenerator(this);
        TableGeneratorAnnotation tableGeneratorResource = (TableGeneratorAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.TableGenerator");
        this.tableGenerator.initialize(tableGeneratorResource);
        this.firePropertyChanged("tableGenerator", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.TableGenerator");
        this.firePropertyChanged("tableGenerator", oldTableGenerator, null);
    }

    @Override
    public JavaTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(JavaTableGenerator newTableGenerator) {
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGenerator", oldTableGenerator, newTableGenerator);
    }

    @Override
    public JavaSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        this.sequenceGenerator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        SequenceGeneratorAnnotation sequenceGeneratorResource = (SequenceGeneratorAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.SequenceGenerator");
        this.sequenceGenerator.initialize(sequenceGeneratorResource);
        this.firePropertyChanged("sequenceGenerator", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.SequenceGenerator");
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, null);
    }

    @Override
    public JavaSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(JavaSequenceGenerator newSequenceGenerator) {
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, newSequenceGenerator);
    }

    @Override
    public Iterator<JavaGenerator> generators() {
        return new CompositeIterator(new Iterator[]{this.getSequenceGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getSequenceGenerator()), this.getTableGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getTableGenerator())});
    }

    @Override
    public JavaConverter getConverter() {
        return this.getSpecifiedConverter() == null ? this.getDefaultConverter() : this.getSpecifiedConverter();
    }

    @Override
    public JavaConverter getDefaultConverter() {
        return this.defaultConverter;
    }

    @Override
    public JavaConverter getSpecifiedConverter() {
        return this.specifiedConverter;
    }

    protected String getSpecifedConverterType() {
        if (this.specifiedConverter == null) {
            return "noConverter";
        }
        return this.specifiedConverter.getType();
    }

    @Override
    public void setSpecifiedConverter(String converterType) {
        if (this.getSpecifedConverterType() == converterType) {
            return;
        }
        JavaConverter oldConverter = this.specifiedConverter;
        JavaConverter newConverter = this.buildSpecifiedConverter(converterType);
        this.specifiedConverter = null;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.specifiedConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("specifiedConverterProperty", oldConverter, newConverter);
    }

    protected void setSpecifiedConverter(JavaConverter newConverter) {
        JavaConverter oldConverter = this.specifiedConverter;
        this.specifiedConverter = newConverter;
        this.firePropertyChanged("specifiedConverterProperty", oldConverter, newConverter);
    }

    @Override
    public void update(JavaResourcePersistentAttribute jrpa) {
        super.update(jrpa);
        this.column.update(this.getResourceColumn());
        this.updateTableGenerator(jrpa);
        this.updateSequenceGenerator(jrpa);
        this.updateGeneratedValue(jrpa);
        this.updatePersistenceUnitGenerators();
        if (this.specifiedConverterType(jrpa) == this.getSpecifedConverterType()) {
            this.getSpecifiedConverter().update(jrpa);
        } else {
            JavaConverter javaConverter = this.buildSpecifiedConverter(this.specifiedConverterType(jrpa));
            this.setSpecifiedConverter(javaConverter);
        }
    }

    protected void updateTableGenerator(JavaResourcePersistentAttribute jrpa) {
        TableGeneratorAnnotation resourceTableGenerator = this.getResourceTableGenerator(jrpa);
        if (resourceTableGenerator == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(resourceTableGenerator));
        } else {
            this.getTableGenerator().update(resourceTableGenerator);
        }
    }

    protected JavaTableGenerator buildTableGenerator(TableGeneratorAnnotation resourceTableGenerator) {
        JavaTableGenerator generator = this.getJpaFactory().buildJavaTableGenerator(this);
        generator.initialize(resourceTableGenerator);
        return generator;
    }

    protected void updateSequenceGenerator(JavaResourcePersistentAttribute jrpa) {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.getResourceSequenceGenerator(jrpa);
        if (sequenceGeneratorResource == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(sequenceGeneratorResource));
        } else {
            this.getSequenceGenerator().update(sequenceGeneratorResource);
        }
    }

    protected JavaSequenceGenerator buildSequenceGenerator(SequenceGeneratorAnnotation resourceSequenceGenerator) {
        JavaSequenceGenerator generator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        generator.initialize(resourceSequenceGenerator);
        return generator;
    }

    protected void updateGeneratedValue(JavaResourcePersistentAttribute jrpa) {
        GeneratedValueAnnotation resourceGeneratedValue = this.getResourceGeneratedValue(jrpa);
        if (resourceGeneratedValue == null) {
            if (this.getGeneratedValue() != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.getGeneratedValue() == null) {
            this.setGeneratedValue(this.buildGeneratedValue(resourceGeneratedValue));
        } else {
            this.getGeneratedValue().update(resourceGeneratedValue);
        }
    }

    protected JavaGeneratedValue buildGeneratedValue(GeneratedValueAnnotation resourceGeneratedValue) {
        JavaGeneratedValue gv = this.getJpaFactory().buildJavaGeneratedValue(this);
        gv.initialize(resourceGeneratedValue);
        return gv;
    }

    protected TableGeneratorAnnotation getResourceTableGenerator(JavaResourcePersistentAttribute jrpa) {
        return (TableGeneratorAnnotation)jrpa.getAnnotation("javax.persistence.TableGenerator");
    }

    protected SequenceGeneratorAnnotation getResourceSequenceGenerator(JavaResourcePersistentAttribute jrpa) {
        return (SequenceGeneratorAnnotation)jrpa.getAnnotation("javax.persistence.SequenceGenerator");
    }

    protected GeneratedValueAnnotation getResourceGeneratedValue(JavaResourcePersistentAttribute jrpa) {
        return (GeneratedValueAnnotation)jrpa.getAnnotation("javax.persistence.GeneratedValue");
    }

    protected void updatePersistenceUnitGenerators() {
        if (this.getTableGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getTableGenerator());
        }
        if (this.getSequenceGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getSequenceGenerator());
        }
    }

    protected JavaConverter buildSpecifiedConverter(String converterType) {
        if (converterType == "temporalConverter") {
            return this.getJpaFactory().buildJavaTemporalConverter(this, this.resourcePersistentAttribute);
        }
        return null;
    }

    protected String specifiedConverterType(JavaResourcePersistentAttribute jrpa) {
        if (jrpa.getAnnotation("javax.persistence.Temporal") != null) {
            return "temporalConverter";
        }
        return null;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getColumn().getName();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public boolean isIdMapping() {
        return true;
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        if (this.ownerIsEntity() && this.connectionProfileIsActive()) {
            this.validateColumn(messages, astRoot);
        }
        this.getPersistenceUnit().validateGeneratedValue(this, messages, astRoot);
        this.getPersistenceUnit().validateGenerators(this, messages, astRoot);
    }

    protected void validateColumn(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTypeMapping().tableNameIsInvalid(this.column.getTable())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{this.column.getTable(), this.column.getName()}, this.column, this.column.getTableTextRange(astRoot)));
            return;
        }
        if (!this.column.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.column.getName()}, this.column, this.column.getNameTextRange(astRoot)));
        }
    }
}

