/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaLobConverter;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericJavaLobConverter
extends AbstractJavaJpaContextNode
implements JavaLobConverter {
    private JavaResourcePersistentAttribute resourcePersistentAttribute;

    public GenericJavaLobConverter(JavaAttributeMapping parent, JavaResourcePersistentAttribute jrpa) {
        super(parent);
        this.initialize(jrpa);
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    public String getType() {
        return "lobConverter";
    }

    protected String getAnnotationName() {
        return "javax.persistence.Lob";
    }

    public void addToResourceModel() {
        this.resourcePersistentAttribute.addAnnotation(this.getAnnotationName());
    }

    public void removeFromResourceModel() {
        this.resourcePersistentAttribute.removeAnnotation(this.getAnnotationName());
    }

    protected TemporalAnnotation getResourceLob() {
        return (TemporalAnnotation)this.resourcePersistentAttribute.getAnnotation(this.getAnnotationName());
    }

    protected void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceLob().getTextRange(astRoot);
    }
}

