/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaOneToOneMapping
extends AbstractJavaSingleRelationshipMapping<OneToOneAnnotation>
implements JavaOneToOneMapping {
    protected String mappedBy;
    protected final List<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns = new ArrayList<JavaPrimaryKeyJoinColumn>();

    public GenericJavaOneToOneMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        String old = this.mappedBy;
        this.mappedBy = mappedBy;
        ((OneToOneAnnotation)this.getResourceMapping()).setMappedBy(mappedBy);
        this.firePropertyChanged("mappedByProperty", old, mappedBy);
    }

    protected void setMappedBy_(String mappedBy) {
        String old = this.mappedBy;
        this.mappedBy = mappedBy;
        this.firePropertyChanged("mappedByProperty", old, mappedBy);
    }

    @Override
    public boolean mappedByIsValid(AttributeMapping mappedByMapping) {
        return mappedByMapping.getKey() == "oneToOne";
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return new CloneListIterator(this.primaryKeyJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.primaryKeyJoinColumns.size();
    }

    @Override
    public JavaPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn pkJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createJoinColumnOwner());
        this.primaryKeyJoinColumns.add(index, pkJoinColumn);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnAnnotation = (PrimaryKeyJoinColumnAnnotation)this.getResourcePersistentAttribute().addAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        pkJoinColumn.initialize(pkJoinColumnAnnotation);
        this.fireItemAdded("primaryKeyJoinColumnsList", index, pkJoinColumn);
        return pkJoinColumn;
    }

    protected void addPrimaryKeyJoinColumn(int index, JavaPrimaryKeyJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumnsList");
    }

    protected void addPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn joinColumn) {
        this.addPrimaryKeyJoinColumn(this.primaryKeyJoinColumns.size(), joinColumn);
    }

    @Override
    public void removePrimaryKeyJoinColumn(PrimaryKeyJoinColumn pkJoinColumn) {
        this.removePrimaryKeyJoinColumn(this.primaryKeyJoinColumns.indexOf(pkJoinColumn));
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn pkJoinColumn = this.primaryKeyJoinColumns.remove(index);
        this.getResourcePersistentAttribute().removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.fireItemRemoved("primaryKeyJoinColumnsList", index, pkJoinColumn);
    }

    protected void removePrimaryKeyJoinColumn_(JavaPrimaryKeyJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumnsList");
    }

    @Override
    public void movePrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.primaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourcePersistentAttribute().move(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumns");
        this.fireItemMoved("primaryKeyJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public boolean containsPrimaryKeyJoinColumns() {
        return !this.primaryKeyJoinColumns.isEmpty();
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns", "javax.persistence.JoinColumn", "javax.persistence.JoinColumns", "javax.persistence.JoinTable"});
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OneToOne";
    }

    @Override
    public String getKey() {
        return "oneToOne";
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    protected void setOptionalOnResourceModel(Boolean newOptional) {
        ((OneToOneAnnotation)this.getResourceMapping()).setOptional(newOptional);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.mappedByTouches(pos, astRoot)) {
            return this.javaCandidateMappedByAttributeNames(filter);
        }
        return null;
    }

    protected boolean mappedByTouches(int pos, CompilationUnit astRoot) {
        return ((OneToOneAnnotation)this.getResourceMapping()).mappedByTouches(pos, astRoot);
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return true;
    }

    @Override
    protected void initialize(OneToOneAnnotation resourceOneToOne) {
        super.initialize(resourceOneToOne);
        this.mappedBy = resourceOneToOne.getMappedBy();
    }

    @Override
    protected Boolean buildSpecifiedOptional(OneToOneAnnotation oneToOneResource) {
        return oneToOneResource.getOptional();
    }

    @Override
    public void initialize(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        super.initialize(javaResourcePersistentAttribute);
        this.initializePrimaryKeyJoinColumns(javaResourcePersistentAttribute);
    }

    protected void initializePrimaryKeyJoinColumns(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        ListIterator annotations = javaResourcePersistentAttribute.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (annotations.hasNext()) {
            this.primaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)annotations.next()));
        }
    }

    protected JavaPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnResource) {
        JavaPrimaryKeyJoinColumn pkJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createJoinColumnOwner());
        pkJoinColumn.initialize(primaryKeyJoinColumnResource);
        return pkJoinColumn;
    }

    @Override
    protected void update(OneToOneAnnotation resourceOneToOne) {
        super.update(resourceOneToOne);
        this.setMappedBy_(resourceOneToOne.getMappedBy());
    }

    @Override
    public void update(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        super.update(javaResourcePersistentAttribute);
        this.updatePrimaryKeyJoinColumns(javaResourcePersistentAttribute);
    }

    protected void updatePrimaryKeyJoinColumns(JavaResourcePersistentAttribute javaResourcePersistentAttribute) {
        ListIterator<JavaPrimaryKeyJoinColumn> contextPkJoinColumns = this.primaryKeyJoinColumns();
        ListIterator resourcePkJoinColumns = javaResourcePersistentAttribute.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (contextPkJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn pkJoinColumn = contextPkJoinColumns.next();
            if (resourcePkJoinColumns.hasNext()) {
                pkJoinColumn.update((PrimaryKeyJoinColumnAnnotation)resourcePkJoinColumns.next());
                continue;
            }
            this.removePrimaryKeyJoinColumn_(pkJoinColumn);
        }
        while (resourcePkJoinColumns.hasNext()) {
            this.addPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)resourcePkJoinColumns.next()));
        }
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        if (this.mappedBy != null) {
            this.validateMappedBy(messages, astRoot);
        }
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.primaryKeyJoinColumns.isEmpty() || this.containsSpecifiedJoinColumns()) {
            super.validateJoinColumns(messages, astRoot);
        }
    }

    protected void validateMappedBy(List<IMessage> messages, CompilationUnit astRoot) {
        Entity targetEntity = this.getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(this.mappedBy);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{this.mappedBy}, this, this.getMappedByTextRange(astRoot)));
            return;
        }
        AttributeMapping mappedByMapping = attribute.getMapping();
        if (!this.mappedByIsValid(mappedByMapping)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{this.mappedBy}, this, this.getMappedByTextRange(astRoot)));
            return;
        }
        if (mappedByMapping instanceof NonOwningMapping && ((NonOwningMapping)mappedByMapping).getMappedBy() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getMappedByTextRange(astRoot)));
        }
    }

    protected TextRange getMappedByTextRange(CompilationUnit astRoot) {
        return ((OneToOneAnnotation)this.getResourceMapping()).getMappedByTextRange(astRoot);
    }
}

