/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPersistentType
extends AbstractJavaJpaContextNode
implements JavaPersistentType {
    protected String name;
    protected JavaTypeMapping mapping;
    protected final List<JavaPersistentAttribute> attributes = new ArrayList<JavaPersistentAttribute>();
    protected AccessType access;
    protected PersistentType parentPersistentType;
    protected JavaResourcePersistentType resourcePersistentType;

    public GenericJavaPersistentType(JpaContextNode parent, JavaResourcePersistentType jrpt) {
        super(parent);
        this.initialize(jrpt);
    }

    @Override
    public IResource getResource() {
        return this.resourcePersistentType.getResourceModel().getJpaCompilationUnit().getCompilationUnit().getResource();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.java.persistentType";
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public void setMappingKey(String key) {
        JavaTypeMapping newMapping;
        if (key == this.getMapping().getKey()) {
            return;
        }
        JavaTypeMapping oldMapping = this.getMapping();
        this.mapping = newMapping = this.createJavaTypeMappingFromMappingKey(key);
        this.resourcePersistentType.setMappingAnnotation(newMapping.getAnnotationName());
        this.firePropertyChanged("mapping", oldMapping, newMapping);
        if (oldMapping != null) {
            Collection annotationsToRemove = (Collection)CollectionTools.collection(oldMapping.correspondingAnnotationNames());
            if (this.getMapping() != null) {
                CollectionTools.removeAll((Collection)annotationsToRemove, this.getMapping().correspondingAnnotationNames());
            }
            for (String annotationName : annotationsToRemove) {
                this.resourcePersistentType.removeAnnotation(annotationName);
            }
        }
    }

    protected void setMapping(JavaTypeMapping newMapping) {
        JavaTypeMapping oldMapping = this.mapping;
        this.mapping = newMapping;
        this.firePropertyChanged("mapping", oldMapping, newMapping);
    }

    @Override
    public boolean isMapped() {
        return this.getMapping().isMapped();
    }

    @Override
    public AccessType getAccess() {
        return this.access;
    }

    protected void setAccess(AccessType newAccess) {
        AccessType oldAccess = this.access;
        this.access = newAccess;
        this.firePropertyChanged("access", (Object)oldAccess, (Object)newAccess);
    }

    protected Iterator<JavaPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return attributeName.equals(o.getName());
            }
        };
    }

    @Override
    public JavaPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        if (stream.hasNext()) {
            JavaPersistentAttribute attribute = stream.next();
            return stream.hasNext() ? null : attribute;
        }
        return this.getParentPersistentType() == null ? null : this.getParentPersistentType().resolveAttribute(attributeName);
    }

    @Override
    public ListIterator<JavaPersistentAttribute> attributes() {
        return new CloneListIterator(this.attributes);
    }

    @Override
    public int attributesSize() {
        return this.attributes.size();
    }

    private void addAttribute(int index, JavaPersistentAttribute attribute) {
        this.addItemToList(index, attribute, this.attributes, "specifiedAttributes");
    }

    private void removeAttribute(JavaPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.attributes, "specifiedAttributes");
    }

    private void moveAttribute(int index, JavaPersistentAttribute attribute) {
        this.moveItemInList(index, this.attributes.indexOf(attribute), this.attributes, "specifiedAttributes");
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    protected Iterator<String> attributeNames(Iterator<? extends PersistentAttribute> attrs) {
        return new TransformationIterator<PersistentAttribute, String>(attrs){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public Iterator<PersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<PersistentType, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(PersistentType pt) {
                return pt.attributes();
            }
        });
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        Iterator values = this.mapping.javaCompletionProposals(pos, filter, astRoot);
        if (values != null) {
            return values;
        }
        ListIterator<JavaPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            values = ((JavaPersistentAttribute)stream.next()).javaCompletionProposals(pos, filter, astRoot);
            if (values == null) continue;
            return values;
        }
        return EmptyIterator.instance();
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        CompilationUnit astRoot = this.buildASTRoot();
        if (this.contains(offset, astRoot)) {
            ListIterator<JavaPersistentAttribute> stream = this.attributes();
            while (stream.hasNext()) {
                JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)stream.next();
                if (!persistentAttribute.contains(offset, astRoot)) continue;
                return persistentAttribute;
            }
            return this;
        }
        return null;
    }

    protected CompilationUnit buildASTRoot() {
        return JDTTools.buildASTRoot(this.resourcePersistentType.getJpaCompilationUnit().getCompilationUnit());
    }

    public boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getFullTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    protected TextRange getFullTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    public TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getNameTextRange(astRoot);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return new ChainIterator<PersistentType>((PersistentType)this){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return new ChainIterator<PersistentType>(this.getParentPersistentType()){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public PersistentType getParentPersistentType() {
        return this.parentPersistentType;
    }

    public void setParentPersistentType(PersistentType newParentPersistentType) {
        if (this.attributeValueHasNotChanged(this.parentPersistentType, newParentPersistentType)) {
            return;
        }
        PersistentType oldParentPersistentType = this.parentPersistentType;
        this.parentPersistentType = newParentPersistentType;
        this.firePropertyChanged("parentPersistentType", oldParentPersistentType, newParentPersistentType);
    }

    @Override
    public boolean hasAnyAttributeMappingAnnotations() {
        return this.resourcePersistentType.hasAnyAttributeAnnotations();
    }

    protected void initialize(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.parentPersistentType = this.parentPersistentType(jrpt);
        this.access = this.access(jrpt);
        this.name = this.name(jrpt);
        this.initializeMapping(jrpt);
        this.initializePersistentAttributes(jrpt);
    }

    protected void initializeMapping(JavaResourcePersistentType jrpt) {
        this.mapping = this.getJpaPlatform().buildJavaTypeMappingFromAnnotation(this.javaMappingAnnotationName(jrpt), this);
        this.mapping.initialize(jrpt);
    }

    protected void initializePersistentAttributes(JavaResourcePersistentType jrpt) {
        Iterator<JavaResourcePersistentAttribute> resourceAttributes = jrpt.fields();
        if (this.getAccess() == AccessType.PROPERTY) {
            resourceAttributes = jrpt.properties();
        }
        while (resourceAttributes.hasNext()) {
            this.attributes.add(this.createAttribute(resourceAttributes.next()));
        }
    }

    @Override
    public void update(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.getJpaFile(this.resourcePersistentType.getResourceModel()).addRootStructureNode(this.resourcePersistentType.getQualifiedName(), this);
        this.updateParentPersistentType(jrpt);
        this.updateAccess(jrpt);
        this.updateName(jrpt);
        this.updateMapping(jrpt);
        this.updatePersistentAttributes(jrpt);
    }

    protected void updateAccess(JavaResourcePersistentType jrpt) {
        this.setAccess(this.access(jrpt));
    }

    protected AccessType access(JavaResourcePersistentType jrpt) {
        AccessType javaAccess = null;
        boolean metadataComplete = false;
        if (this.getOrmPersistentType() != null) {
            javaAccess = this.getOrmPersistentType().getMapping().getSpecifiedAccess();
            metadataComplete = this.getOrmPersistentType().getMapping().isMetadataComplete();
        }
        if (javaAccess == null && !metadataComplete) {
            javaAccess = AccessType.fromJavaResourceModel(jrpt.getAccess());
        }
        if (javaAccess == null && this.getParentPersistentType() != null) {
            javaAccess = this.getParentPersistentType().getAccess();
        }
        if (javaAccess == null && this.getEntityMappings() != null) {
            javaAccess = this.getEntityMappings().getAccess();
        }
        if (javaAccess == null && this.getPersistenceUnit() != null) {
            javaAccess = this.getPersistenceUnit().getDefaultAccess();
        }
        if (javaAccess == null) {
            javaAccess = AccessType.FIELD;
        }
        return javaAccess;
    }

    protected void updateName(JavaResourcePersistentType jrpt) {
        this.setName(this.name(jrpt));
    }

    protected String name(JavaResourcePersistentType jrpt) {
        return jrpt.getQualifiedName();
    }

    protected void updateMapping(JavaResourcePersistentType jrpt) {
        String javaMappingAnnotationName = this.javaMappingAnnotationName(jrpt);
        if (this.getMapping().getAnnotationName() != javaMappingAnnotationName) {
            this.setMapping(this.createJavaTypeMappingFromAnnotation(javaMappingAnnotationName, jrpt));
        } else {
            this.getMapping().update(jrpt);
        }
    }

    protected JavaTypeMapping createJavaTypeMappingFromMappingKey(String key) {
        return this.getJpaPlatform().buildJavaTypeMappingFromMappingKey(key, this);
    }

    protected JavaTypeMapping createJavaTypeMappingFromAnnotation(String annotationName, JavaResourcePersistentType jrpt) {
        JavaTypeMapping typeMapping = this.getJpaPlatform().buildJavaTypeMappingFromAnnotation(annotationName, this);
        typeMapping.initialize(jrpt);
        return typeMapping;
    }

    protected String javaMappingAnnotationName(JavaResourcePersistentType jrpt) {
        Annotation mappingAnnotation = (Annotation)jrpt.getMappingAnnotation();
        if (mappingAnnotation != null) {
            return mappingAnnotation.getAnnotationName();
        }
        return null;
    }

    protected void updatePersistentAttributes(JavaResourcePersistentType jrpt) {
        Iterator<JavaResourcePersistentAttribute> resourceAttributes = jrpt.fields();
        if (this.getAccess() == AccessType.PROPERTY) {
            resourceAttributes = jrpt.properties();
        }
        Collection contextAttributesToRemove = (Collection)CollectionTools.collection(this.attributes());
        ArrayList<JavaPersistentAttribute> contextAttributesToUpdate = new ArrayList<JavaPersistentAttribute>();
        int resourceIndex = 0;
        while (resourceAttributes.hasNext()) {
            JavaResourcePersistentAttribute resourceAttribute = resourceAttributes.next();
            boolean contextAttributeFound = false;
            for (JavaPersistentAttribute contextAttribute : contextAttributesToRemove) {
                if (contextAttribute.getResourcePersistentAttribute() != resourceAttribute) continue;
                this.moveAttribute(resourceIndex, contextAttribute);
                contextAttributesToRemove.remove(contextAttribute);
                contextAttributesToUpdate.add(contextAttribute);
                contextAttributeFound = true;
                break;
            }
            if (!contextAttributeFound) {
                this.addAttribute(resourceIndex, this.createAttribute(resourceAttribute));
            }
            ++resourceIndex;
        }
        for (JavaPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeAttribute(contextAttribute);
        }
        for (JavaPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected JavaPersistentAttribute createAttribute(JavaResourcePersistentAttribute jrpa) {
        return this.getJpaFactory().buildJavaPersistentAttribute(this, jrpa);
    }

    public void updateParentPersistentType(JavaResourcePersistentType jrpt) {
        this.setParentPersistentType(this.parentPersistentType(jrpt));
    }

    protected PersistentType parentPersistentType(JavaResourcePersistentType jrpt) {
        return this.parentPersistentType(jrpt.getSuperClassQualifiedName());
    }

    protected PersistentType parentPersistentType(String fullyQualifiedTypeName) {
        PersistentType possibleParent = this.possibleParent(fullyQualifiedTypeName);
        if (possibleParent == null) {
            return null;
        }
        if (possibleParent.isMapped()) {
            return possibleParent;
        }
        return possibleParent.getParentPersistentType();
    }

    protected PersistentType possibleParent(String fullyQualifiedTypeName) {
        PersistentType possibleParent = this.getPersistentType(fullyQualifiedTypeName);
        if (possibleParent != null) {
            return possibleParent;
        }
        JavaResourcePersistentType jrpt = this.getJpaProject().getJavaResourcePersistentType(fullyQualifiedTypeName);
        return jrpt == null ? null : this.possibleParent(jrpt.getSuperClassQualifiedName());
    }

    protected PersistentType getPersistentType(String fullyQualifiedTypeName) {
        return this.getPersistenceUnit().getPersistentType(fullyQualifiedTypeName);
    }

    @Override
    public void validate(List<IMessage> messages) {
        this.validate(messages, this.buildASTRoot());
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        this.validateMapping(messages, astRoot);
        this.validateAttributes(messages, astRoot);
    }

    protected void validateMapping(List<IMessage> messages, CompilationUnit astRoot) {
        try {
            this.mapping.validate(messages, astRoot);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, CompilationUnit astRoot) {
        ListIterator<JavaPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            this.validateAttribute((JavaPersistentAttribute)stream.next(), messages, astRoot);
        }
    }

    protected void validateAttribute(JavaPersistentAttribute attribute, List<IMessage> messages, CompilationUnit astRoot) {
        try {
            attribute.validate(messages, astRoot);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    @Override
    public void dispose() {
        JpaFile jpaFile = this.getJpaFile(this.resourcePersistentType.getResourceModel());
        if (jpaFile != null) {
            jpaFile.removeRootStructureNode(this.resourcePersistentType.getQualifiedName());
        }
    }
}

