/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedIdMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmSingleRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmTransientMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmAttributeMapping<T extends XmlAttributeMapping>
extends AbstractOrmJpaContextNode
implements OrmAttributeMapping {
    protected String name;
    protected T attributeMapping;
    protected JavaPersistentAttribute javaPersistentAttribute;

    protected AbstractOrmAttributeMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    protected void setJavaPersistentAttribute(JavaPersistentAttribute javaPersistentAttribute) {
        JavaPersistentAttribute old = this.javaPersistentAttribute;
        this.javaPersistentAttribute = javaPersistentAttribute;
        this.firePropertyChanged("javaPersistentAttribute", old, javaPersistentAttribute);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.attributeMapping.setName(name);
        this.firePropertyChanged("name", old, name);
        this.getPersistentAttribute().nameChanged(old, name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
        this.getPersistentAttribute().nameChanged(old, name);
    }

    @Override
    public OrmPersistentAttribute getPersistentAttribute() {
        return (OrmPersistentAttribute)this.getParent();
    }

    public String getAttributeName() {
        return this.getPersistentAttribute().getName();
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public void initializeFromOrmAttributeMapping(OrmAttributeMapping oldMapping) {
        this.setName(oldMapping.getName());
    }

    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        this.initializeFromOrmAttributeMapping((OrmAttributeMapping)((Object)oldMapping));
    }

    public void initializeFromOrmNonOwningMapping(NonOwningMapping oldMapping) {
        this.initializeFromOrmAttributeMapping((OrmAttributeMapping)((Object)oldMapping));
    }

    @Override
    public void initializeFromOrmBasicMapping(OrmBasicMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmIdMapping(OrmIdMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmTransientMapping(OrmTransientMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    public void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedMapping(OrmEmbeddedMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedIdMapping(OrmEmbeddedIdMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmVersionMapping(OrmVersionMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    public void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    public void initializeFromOrmMulitRelationshipMapping(OrmMultiRelationshipMapping oldMapping) {
        this.initializeFromOrmRelationshipMapping(oldMapping);
    }

    public void initializeFromOrmSingleRelationshipMapping(OrmSingleRelationshipMapping oldMapping) {
        this.initializeFromOrmRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToManyMapping(OrmOneToManyMapping oldMapping) {
        this.initializeFromOrmNonOwningMapping(oldMapping);
        this.initializeFromOrmMulitRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToOneMapping(OrmManyToOneMapping oldMapping) {
        this.initializeFromOrmSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToOneMapping(OrmOneToOneMapping oldMapping) {
        this.initializeFromOrmNonOwningMapping(oldMapping);
        this.initializeFromOrmSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToManyMapping(OrmManyToManyMapping oldMapping) {
        this.initializeFromOrmNonOwningMapping(oldMapping);
        this.initializeFromOrmMulitRelationshipMapping(oldMapping);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public OrmTypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getTypeMapping();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isIdMapping() {
        return false;
    }

    protected T getAttributeMapping() {
        return this.attributeMapping;
    }

    public void initialize(T xmlAttributeMapping) {
        this.attributeMapping = xmlAttributeMapping;
        this.name = xmlAttributeMapping.getName();
        this.javaPersistentAttribute = this.findJavaPersistentAttribute();
    }

    public void update(T xmlAttributeMapping) {
        this.attributeMapping = xmlAttributeMapping;
        this.setName_(xmlAttributeMapping.getName());
        this.setJavaPersistentAttribute(this.findJavaPersistentAttribute());
    }

    protected JavaPersistentAttribute findJavaPersistentAttribute() {
        JavaPersistentType javaPersistentType = this.getPersistentAttribute().getPersistentType().getJavaPersistentType();
        if (javaPersistentType != null && this.getName() != null) {
            return javaPersistentType.getAttributeNamed(this.getName());
        }
        return null;
    }

    protected boolean ownerIsEntity() {
        return this.getTypeMapping().getKey() == "entity";
    }

    @Override
    public boolean contains(int textOffset) {
        return this.attributeMapping.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.attributeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getPersistentAttribute().isVirtual() ? this.getTypeMapping().getAttributesTextRange() : this.attributeMapping.getValidationTextRange();
    }

    public TextRange getNameTextRange() {
        return this.attributeMapping.getNameTextRange();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        this.validateAttribute(messages);
        this.validateModifiers(messages);
        this.validateMapping(messages);
    }

    protected void validateAttribute(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME", this, this.getValidationTextRange()));
            return;
        }
        if (this.findJavaPersistentAttribute() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME", new String[]{this.name, this.getPersistentAttribute().getPersistentType().getMapping().getClass_()}, this, this.getNameTextRange()));
        }
    }

    protected void validateModifiers(List<IMessage> messages) {
        if (this.getKey() == "transient") {
            return;
        }
        JavaPersistentAttribute jpa = this.getJavaPersistentAttribute();
        if (jpa == null) {
            return;
        }
        JavaResourcePersistentAttribute jrpa = jpa.getResourcePersistentAttribute();
        if (jrpa.isForField()) {
            if (jrpa.isFinal()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_FINAL_FIELD"));
            }
            if (jrpa.isPublic()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_PUBLIC_FIELD"));
            }
        }
    }

    protected IMessage buildAttributeMessage(String msgID) {
        OrmPersistentAttribute pa = this.getPersistentAttribute();
        return DefaultJpaValidationMessages.buildMessage(1, msgID, new String[]{this.name}, pa, pa.getValidationTextRange());
    }

    protected void validateMapping(List<IMessage> messages) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.name}, this, this.getValidationTextRange()));
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getAttributeName());
    }
}

