/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.XmlGenerator;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmGenerator<T extends XmlGenerator>
extends AbstractOrmJpaContextNode
implements OrmGenerator {
    protected String name;
    protected Integer specifiedInitialValue;
    protected Integer defaultInitialValue;
    protected Integer specifiedAllocationSize;
    protected Integer defaultAllocationSize;
    protected T resourceGenerator;

    protected AbstractOrmGenerator(OrmJpaContextNode parent) {
        super(parent);
    }

    protected T getResourceGenerator() {
        return this.resourceGenerator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.getResourceGenerator().setName(name);
        this.firePropertyChanged("name", old, name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public Integer getInitialValue() {
        return this.specifiedInitialValue != null ? this.specifiedInitialValue : this.defaultInitialValue;
    }

    @Override
    public Integer getSpecifiedInitialValue() {
        return this.specifiedInitialValue;
    }

    @Override
    public void setSpecifiedInitialValue(Integer specifiedInitialValue) {
        Integer old = this.specifiedInitialValue;
        this.specifiedInitialValue = specifiedInitialValue;
        this.getResourceGenerator().setInitialValue(specifiedInitialValue);
        this.firePropertyChanged("specifiedInitialValue", old, specifiedInitialValue);
    }

    protected void setSpecifiedInitialValue_(Integer specifiedInitialValue) {
        Integer old = this.specifiedInitialValue;
        this.specifiedInitialValue = specifiedInitialValue;
        this.firePropertyChanged("specifiedInitialValue", old, specifiedInitialValue);
    }

    @Override
    public Integer getDefaultInitialValue() {
        return this.defaultInitialValue;
    }

    protected void setDefaultInitialValue(Integer defaultInitialValue) {
        Integer old = this.defaultInitialValue;
        this.defaultInitialValue = defaultInitialValue;
        this.firePropertyChanged("defaultInitialValue", old, defaultInitialValue);
    }

    @Override
    public Integer getAllocationSize() {
        return this.specifiedAllocationSize != null ? this.specifiedAllocationSize : this.defaultAllocationSize;
    }

    @Override
    public Integer getSpecifiedAllocationSize() {
        return this.specifiedAllocationSize;
    }

    @Override
    public void setSpecifiedAllocationSize(Integer specifiedAllocationSize) {
        Integer old = this.specifiedAllocationSize;
        this.specifiedAllocationSize = specifiedAllocationSize;
        this.getResourceGenerator().setAllocationSize(specifiedAllocationSize);
        this.firePropertyChanged("specifiedAllocationSize", old, specifiedAllocationSize);
    }

    protected void setSpecifiedAllocationSize_(Integer specifiedAllocationSize) {
        Integer old = this.specifiedAllocationSize;
        this.specifiedAllocationSize = specifiedAllocationSize;
        this.firePropertyChanged("specifiedAllocationSize", old, specifiedAllocationSize);
    }

    @Override
    public Integer getDefaultAllocationSize() {
        return this.defaultAllocationSize;
    }

    protected void setDefaultAllocationSize(Integer defaultAllocationSize) {
        Integer old = this.defaultAllocationSize;
        this.defaultAllocationSize = defaultAllocationSize;
        this.firePropertyChanged("defaultAllocationSize", old, defaultAllocationSize);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange validationTextRange = this.getResourceGenerator().getValidationTextRange();
        return validationTextRange != null ? validationTextRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        TextRange nameTextRange = this.getResourceGenerator().getNameTextRange();
        return nameTextRange != null ? nameTextRange : this.getValidationTextRange();
    }

    protected void initialize(T xmlResourceGenerator) {
        this.resourceGenerator = xmlResourceGenerator;
        this.name = xmlResourceGenerator.getName();
        this.specifiedInitialValue = xmlResourceGenerator.getInitialValue();
        this.specifiedAllocationSize = xmlResourceGenerator.getAllocationSize();
    }

    protected void update(T xmlResourceGenerator) {
        this.resourceGenerator = xmlResourceGenerator;
        this.setName_(xmlResourceGenerator.getName());
        this.setSpecifiedInitialValue_(xmlResourceGenerator.getInitialValue());
        this.setSpecifiedAllocationSize_(xmlResourceGenerator.getAllocationSize());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    protected abstract String getSchema();

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return this.getDbCatalog(catalog);
    }

    protected abstract String getCatalog();

    @Override
    public boolean isVirtual() {
        return this.getResourceGenerator().isVirtual();
    }

    @Override
    public OrmJpaContextNode getParent() {
        return (OrmJpaContextNode)super.getParent();
    }

    @Override
    public boolean overrides(Generator generator) {
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equals(generator.getName()) && generator instanceof JavaGenerator;
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }
}

