/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.QueryHint;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlQuery;
import org.eclipse.jpt.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmQuery<E extends XmlQuery>
extends AbstractOrmJpaContextNode
implements OrmQuery {
    protected String name;
    protected String query;
    protected final List<OrmQueryHint> hints = new ArrayList<OrmQueryHint>();
    protected E resourceQuery;

    protected AbstractOrmQuery(OrmJpaContextNode parent, E resourceQuery) {
        super(parent);
        this.initialize(resourceQuery);
    }

    protected E getResourceQuery() {
        return this.resourceQuery;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.getResourceQuery().setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        this.getResourceQuery().setQuery(newQuery);
        this.firePropertyChanged("queryProperty", oldQuery, newQuery);
    }

    @Override
    public ListIterator<OrmQueryHint> hints() {
        return new CloneListIterator(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public OrmQueryHint addHint(int index) {
        XmlQueryHint resourceQueryHint = OrmFactory.eINSTANCE.createXmlQueryHint();
        OrmQueryHint contextQueryHint = this.buildQueryHint(resourceQueryHint);
        this.hints.add(index, contextQueryHint);
        this.getResourceQuery().getHints().add(index, (Object)resourceQueryHint);
        this.fireItemAdded("hintsList", index, contextQueryHint);
        return contextQueryHint;
    }

    protected void addHint(int index, OrmQueryHint queryHint) {
        this.addItemToList(index, queryHint, this.hints, "hintsList");
    }

    protected void addHint(OrmQueryHint queryHint) {
        this.addHint(this.hints.size(), queryHint);
    }

    @Override
    public void removeHint(QueryHint queryHint) {
        this.removeHint(this.hints.indexOf(queryHint));
    }

    @Override
    public void removeHint(int index) {
        OrmQueryHint queryHint = this.hints.remove(index);
        this.getResourceQuery().getHints().remove(index);
        this.fireItemRemoved("hintsList", index, queryHint);
    }

    protected void removeHint_(OrmQueryHint queryHint) {
        this.removeItemFromList(queryHint, this.hints, "hintsList");
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.getResourceQuery().getHints().move(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.hints, "hintsList");
    }

    protected void initialize(E resourceQuery) {
        this.resourceQuery = resourceQuery;
        this.name = resourceQuery.getName();
        this.query = resourceQuery.getQuery();
        this.initializeHints(resourceQuery);
    }

    protected void initializeHints(E resourceQuery) {
        for (XmlQueryHint resourceQueryHint : resourceQuery.getHints()) {
            this.hints.add(this.buildQueryHint(resourceQueryHint));
        }
    }

    protected OrmQueryHint buildQueryHint(XmlQueryHint resourceQueryHint) {
        return this.getJpaFactory().buildOrmQueryHint(this, resourceQueryHint);
    }

    public void update(E resourceQuery) {
        this.resourceQuery = resourceQuery;
        this.setName(resourceQuery.getName());
        this.setQuery(resourceQuery.getQuery());
        this.updateHints(resourceQuery);
    }

    protected void updateHints(E resourceQuery) {
        ListIterator<OrmQueryHint> contextHints = this.hints();
        CloneListIterator resourceHints = new CloneListIterator(resourceQuery.getHints());
        while (contextHints.hasNext()) {
            OrmQueryHint contextHint = contextHints.next();
            if (resourceHints.hasNext()) {
                contextHint.update((XmlQueryHint)resourceHints.next());
                continue;
            }
            this.removeHint_(contextHint);
        }
        while (resourceHints.hasNext()) {
            this.addHint(this.buildQueryHint((XmlQueryHint)resourceHints.next()));
        }
    }

    @Override
    public boolean overrides(Query query) {
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equals(query.getName()) && query instanceof JavaQuery;
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getResourceQuery().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getResourceQuery().getNameTextRange();
    }
}

