/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmAssociationOverride
extends AbstractOrmJpaContextNode
implements OrmAssociationOverride {
    protected String name;
    protected final List<OrmJoinColumn> specifiedJoinColumns;
    protected final List<OrmJoinColumn> defaultJoinColumns;
    private final AssociationOverride.Owner owner;
    protected XmlAssociationOverride resourceAssociationOverride;

    public GenericOrmAssociationOverride(OrmJpaContextNode parent, AssociationOverride.Owner owner, XmlAssociationOverride resourceAssociationOverride) {
        super(parent);
        this.owner = owner;
        this.specifiedJoinColumns = new ArrayList<OrmJoinColumn>();
        this.defaultJoinColumns = new ArrayList<OrmJoinColumn>();
        this.initialize(resourceAssociationOverride);
    }

    @Override
    public OrmAssociationOverride setVirtual(boolean virtual) {
        return (OrmAssociationOverride)this.getOwner().setVirtual(virtual, this);
    }

    @Override
    public AssociationOverride.Owner getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.resourceAssociationOverride.setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.specifiedJoinColumns.isEmpty() ? this.defaultJoinColumns() : this.specifiedJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.specifiedJoinColumns.isEmpty() ? this.defaultJoinColumnsSize() : this.specifiedJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmJoinColumn> defaultJoinColumns() {
        return new CloneListIterator(this.defaultJoinColumns);
    }

    @Override
    public int defaultJoinColumnsSize() {
        return this.defaultJoinColumns.size();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        XmlJoinColumnImpl resourceJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumnImpl();
        OrmJoinColumn contextJoinColumn = this.buildJoinColumn(resourceJoinColumn);
        this.specifiedJoinColumns.add(index, contextJoinColumn);
        this.resourceAssociationOverride.getJoinColumns().add(index, (Object)resourceJoinColumn);
        this.fireItemAdded("specifiedJoinColumnsList", index, contextJoinColumn);
        return contextJoinColumn;
    }

    protected OrmJoinColumn.Owner createJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected void addSpecifiedJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    protected void addSpecifiedJoinColumn(OrmJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        this.resourceAssociationOverride.getJoinColumns().remove(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumns", index, removedJoinColumn);
    }

    protected void removeSpecifiedJoinColumn(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.resourceAssociationOverride.getJoinColumns().move(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    protected void initialize(XmlAssociationOverride resourceAssociationOverride) {
        this.resourceAssociationOverride = resourceAssociationOverride;
        this.name = resourceAssociationOverride.getName();
        this.initializeSpecifiedJoinColumns(resourceAssociationOverride);
    }

    protected void initializeSpecifiedJoinColumns(XmlAssociationOverride resourceAssociationOverride) {
        for (XmlJoinColumn joinColumn : resourceAssociationOverride.getJoinColumns()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(joinColumn));
        }
    }

    @Override
    public void update(XmlAssociationOverride resourceAssociationOverride) {
        this.resourceAssociationOverride = resourceAssociationOverride;
        this.setName(resourceAssociationOverride.getName());
        this.updateSpecifiedJoinColumns(resourceAssociationOverride);
    }

    protected void updateSpecifiedJoinColumns(XmlAssociationOverride resourceAssociationOverride) {
        ListIterator<OrmJoinColumn> contextJoinColumns = this.specifiedJoinColumns();
        CloneListIterator resourceJoinColumns = new CloneListIterator(resourceAssociationOverride.getJoinColumns());
        while (contextJoinColumns.hasNext()) {
            OrmJoinColumn contextJoinColumn = contextJoinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                contextJoinColumn.update((XmlJoinColumn)resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn(contextJoinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn((XmlJoinColumn)resourceJoinColumns.next()));
        }
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn resourceJoinColumn) {
        return this.getJpaFactory().buildOrmJoinColumn(this, new JoinColumnOwner(), resourceJoinColumn);
    }

    @Override
    public TextRange getValidationTextRange() {
        return null;
    }

    class JoinColumnOwner
    implements OrmJoinColumn.Owner {
        public String getDefaultTableName() {
            return GenericOrmAssociationOverride.this.owner.getTypeMapping().getPrimaryTableName();
        }

        public String getDefaultColumnName() {
            return null;
        }

        public Entity getTargetEntity() {
            RelationshipMapping relationshipMapping = this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return GenericOrmAssociationOverride.this.getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericOrmAssociationOverride.this.owner.getRelationshipMapping(GenericOrmAssociationOverride.this.getName());
        }

        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmAssociationOverride.this.owner.getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmAssociationOverride.this.defaultJoinColumns.contains(joinColumn);
        }

        public int joinColumnsSize() {
            return GenericOrmAssociationOverride.this.joinColumnsSize();
        }

        public TextRange getValidationTextRange() {
            return null;
        }
    }
}

