/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmAttributeOverride
extends AbstractOrmJpaContextNode
implements OrmAttributeOverride,
OrmColumn.Owner {
    protected String name;
    private final AttributeOverride.Owner owner;
    protected XmlAttributeOverride resourceAttributeOverride;
    protected final OrmColumn column;

    public GenericOrmAttributeOverride(OrmJpaContextNode parent, AttributeOverride.Owner owner, XmlAttributeOverride resourceAttributeOverride) {
        super(parent);
        this.owner = owner;
        this.column = this.getJpaFactory().buildOrmColumn(this, this);
        this.initialize(resourceAttributeOverride);
    }

    @Override
    public OrmJpaContextNode getParent() {
        return (OrmJpaContextNode)super.getParent();
    }

    @Override
    public OrmAttributeOverride setVirtual(boolean virtual) {
        return (OrmAttributeOverride)this.getOwner().setVirtual(virtual, this);
    }

    @Override
    public AttributeOverride.Owner getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.resourceAttributeOverride.setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getOwner().getTypeMapping();
    }

    @Override
    public Table getDbTable(String tablename) {
        return this.getTypeMapping().getDbTable(this.getColumn().getTable());
    }

    @Override
    public String getDefaultColumnName() {
        ColumnMapping columnMapping = this.getColumnMapping();
        if (columnMapping == null) {
            return null;
        }
        return columnMapping.getColumn().getName();
    }

    @Override
    public String getDefaultTableName() {
        ColumnMapping columnMapping = this.getColumnMapping();
        if (columnMapping == null) {
            return null;
        }
        String tableName = columnMapping.getColumn().getSpecifiedTable();
        if (tableName != null) {
            return tableName;
        }
        return this.getOwner().getTypeMapping().getPrimaryTableName();
    }

    protected ColumnMapping getColumnMapping() {
        return this.getOwner().getColumnMapping(this.getName());
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.resourceAttributeOverride.getValidationTextRange();
        return textRange == null ? this.getParent().getValidationTextRange() : textRange;
    }

    @Override
    public XmlColumn getResourceColumn() {
        return this.resourceAttributeOverride.getColumn();
    }

    @Override
    public void addResourceColumn() {
        this.resourceAttributeOverride.setColumn(OrmFactory.eINSTANCE.createXmlColumnImpl());
    }

    @Override
    public void removeResourceColumn() {
        this.resourceAttributeOverride.setColumn(null);
    }

    protected void initialize(XmlAttributeOverride xmlAttributeOverride) {
        this.resourceAttributeOverride = xmlAttributeOverride;
        this.name = xmlAttributeOverride.getName();
        this.column.initialize(xmlAttributeOverride.getColumn());
    }

    @Override
    public void update(XmlAttributeOverride xmlAttributeOverride) {
        this.resourceAttributeOverride = xmlAttributeOverride;
        this.setName_(xmlAttributeOverride.getName());
        this.column.update(xmlAttributeOverride.getColumn());
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.connectionProfileIsActive()) {
            this.validateColumn(messages);
        }
    }

    protected void validateColumn(List<IMessage> messages) {
        String tableName = this.column.getTable();
        if (this.getTypeMapping().tableNameIsInvalid(tableName)) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_TABLE", new String[]{this.getName(), tableName, this.column.getName()}, this.column, this.column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{tableName, this.column.getName()}, this.column, this.column.getTableTextRange()));
            }
            return;
        }
        if (!this.column.isResolved()) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), this.column.getName()}, this.column, this.column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.column.getName()}, this.column, this.column.getNameTextRange()));
            }
        }
    }
}

