/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmConverter;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmEnumeratedConverter;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmLobConverter;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmNullConverter;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmTemporalConverter;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlBasic;
import org.eclipse.jpt.core.resource.orm.XmlBasicImpl;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmBasicMapping
extends AbstractOrmAttributeMapping<XmlBasic>
implements OrmBasicMapping {
    protected final OrmColumn column = this.getJpaFactory().buildOrmColumn(this, this);
    protected FetchType specifiedFetch;
    protected Boolean specifiedOptional;
    protected OrmConverter defaultConverter;
    protected OrmConverter specifiedConverter;

    public GenericOrmBasicMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getDefaultFetch() {
        return BasicMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((XmlBasic)this.getAttributeMapping()).setFetch(FetchType.toOrmResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    @Override
    public Boolean getOptional() {
        return this.getSpecifiedOptional() == null ? this.getDefaultOptional() : this.getSpecifiedOptional();
    }

    @Override
    public Boolean getDefaultOptional() {
        return Nullable.DEFAULT_OPTIONAL;
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        ((XmlBasic)this.getAttributeMapping()).setOptional(newSpecifiedOptional);
        this.firePropertyChanged("specifiedOptionalProperty", oldOptional, newSpecifiedOptional);
    }

    protected void setSpecifiedOptional_(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.firePropertyChanged("specifiedOptionalProperty", oldOptional, newSpecifiedOptional);
    }

    @Override
    public OrmConverter getConverter() {
        return this.getSpecifiedConverter() == null ? this.getDefaultConverter() : this.getSpecifiedConverter();
    }

    @Override
    public OrmConverter getDefaultConverter() {
        return this.defaultConverter;
    }

    @Override
    public OrmConverter getSpecifiedConverter() {
        return this.specifiedConverter;
    }

    protected String getSpecifedConverterType() {
        if (this.specifiedConverter == null) {
            return "noConverter";
        }
        return this.specifiedConverter.getType();
    }

    @Override
    public void setSpecifiedConverter(String converterType) {
        if (this.getSpecifedConverterType() == converterType) {
            return;
        }
        OrmConverter oldConverter = this.specifiedConverter;
        OrmConverter newConverter = this.buildSpecifiedConverter(converterType);
        this.specifiedConverter = null;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.specifiedConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("specifiedConverterProperty", oldConverter, newConverter);
    }

    protected void setSpecifiedConverter(OrmConverter newConverter) {
        OrmConverter oldConverter = this.specifiedConverter;
        this.specifiedConverter = newConverter;
        this.firePropertyChanged("specifiedConverterProperty", oldConverter, newConverter);
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmBasicMapping(this);
    }

    @Override
    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public int getXmlSequence() {
        return 2;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public void initialize(XmlBasic basic) {
        super.initialize(basic);
        this.specifiedFetch = this.specifiedFetch(basic);
        this.specifiedOptional = this.specifiedOptional(basic);
        this.column.initialize(basic.getColumn());
        this.defaultConverter = new GenericOrmNullConverter(this);
        this.specifiedConverter = this.buildSpecifiedConverter(this.specifiedConverterType(basic));
    }

    @Override
    public void update(XmlBasic basic) {
        super.update(basic);
        this.setSpecifiedFetch_(this.specifiedFetch(basic));
        this.setSpecifiedOptional_(this.specifiedOptional(basic));
        this.column.update(basic.getColumn());
        if (this.specifiedConverterType(basic) == this.getSpecifedConverterType()) {
            this.getSpecifiedConverter().update(basic);
        } else {
            this.setSpecifiedConverter(this.buildSpecifiedConverter(this.specifiedConverterType(basic)));
        }
    }

    protected Boolean specifiedOptional(XmlBasic basic) {
        return basic.getOptional();
    }

    protected FetchType specifiedFetch(XmlBasic basic) {
        return FetchType.fromOrmResourceModel(basic.getFetch());
    }

    protected OrmConverter buildSpecifiedConverter(String converterType) {
        if (converterType == "enumeratedConverter") {
            return new GenericOrmEnumeratedConverter(this, (XmlBasic)this.attributeMapping);
        }
        if (converterType == "temporalConverter") {
            return new GenericOrmTemporalConverter(this, (XmlConvertibleMapping)((Object)this.attributeMapping));
        }
        if (converterType == "lobConverter") {
            return new GenericOrmLobConverter(this, (XmlBasic)this.attributeMapping);
        }
        return null;
    }

    protected String specifiedConverterType(XmlBasic xmlBasic) {
        if (xmlBasic.getEnumerated() != null) {
            return "enumeratedConverter";
        }
        if (xmlBasic.getTemporal() != null) {
            return "temporalConverter";
        }
        if (xmlBasic.isLob()) {
            return "lobConverter";
        }
        return null;
    }

    @Override
    public XmlBasic addToResourceModel(AbstractXmlTypeMapping typeMapping) {
        XmlBasicImpl basic = OrmFactory.eINSTANCE.createXmlBasicImpl();
        this.getPersistentAttribute().initialize(basic);
        typeMapping.getAttributes().getBasics().add((Object)basic);
        return basic;
    }

    @Override
    public void removeFromResourceModel(AbstractXmlTypeMapping typeMapping) {
        typeMapping.getAttributes().getBasics().remove(this.getAttributeMapping());
        if (typeMapping.getAttributes().isAllFeaturesUnset()) {
            typeMapping.setAttributes(null);
        }
    }

    @Override
    public XmlColumn getResourceColumn() {
        return ((XmlBasic)this.getAttributeMapping()).getColumn();
    }

    @Override
    public void addResourceColumn() {
        ((XmlBasic)this.getAttributeMapping()).setColumn(OrmFactory.eINSTANCE.createXmlColumnImpl());
    }

    @Override
    public void removeResourceColumn() {
        ((XmlBasic)this.getAttributeMapping()).setColumn(null);
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.connectionProfileIsActive() && this.ownerIsEntity()) {
            this.validateColumn(messages);
        }
    }

    protected void validateColumn(List<IMessage> messages) {
        String tableName = this.column.getTable();
        if (this.getTypeMapping().tableNameIsInvalid(tableName)) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{this.getName(), tableName, this.column.getName()}, this.column, this.column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{tableName, this.column.getName()}, this.column, this.column.getTableTextRange()));
            }
            return;
        }
        if (!this.column.isResolved()) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), this.column.getName()}, this.column, this.column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.column.getName()}, this.column, this.column.getNameTextRange()));
            }
        }
    }
}

