/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.orm.OrmDiscriminatorColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmNamedColumn;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlDiscriminatorColumn;
import org.eclipse.jpt.core.resource.orm.XmlEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmDiscriminatorColumn
extends AbstractOrmNamedColumn<XmlDiscriminatorColumn>
implements OrmDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType;
    protected DiscriminatorType defaultDiscriminatorType;
    protected Integer specifiedLength;
    protected XmlEntity entity;

    public GenericOrmDiscriminatorColumn(OrmJpaContextNode parent, OrmNamedColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.getSpecifiedDiscriminatorType() == null ? this.getDefaultDiscriminatorType() : this.getSpecifiedDiscriminatorType();
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE;
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        if (oldDiscriminatorType != newSpecifiedDiscriminatorType) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setDiscriminatorType(DiscriminatorType.toOrmResourceModel(newSpecifiedDiscriminatorType));
                if (this.getResourceColumn().isAllFeaturesUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedDiscriminatorType != null) {
                this.addResourceColumn();
                this.getResourceColumn().setDiscriminatorType(DiscriminatorType.toOrmResourceModel(newSpecifiedDiscriminatorType));
            }
        }
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    @Override
    public Integer getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength();
    }

    @Override
    public Integer getDefaultLength() {
        return DiscriminatorColumn.DEFAULT_LENGTH;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        if (oldSpecifiedLength != newSpecifiedLength) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setLength(newSpecifiedLength);
                if (this.getResourceColumn().isAllFeaturesUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedLength != null) {
                this.addResourceColumn();
                this.getResourceColumn().setLength(newSpecifiedLength);
            }
        }
        this.firePropertyChanged("spcifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("spcifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    @Override
    protected String tableName() {
        return this.getOwner().getTypeMapping().getPrimaryTableName();
    }

    @Override
    protected XmlDiscriminatorColumn getResourceColumn() {
        return this.entity.getDiscriminatorColumn();
    }

    @Override
    protected void addResourceColumn() {
        this.entity.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
    }

    @Override
    protected void removeResourceColumn() {
        this.entity.setDiscriminatorColumn(null);
    }

    @Override
    public void initialize(XmlEntity entity) {
        this.entity = entity;
        this.initialize(this.getResourceColumn());
    }

    @Override
    public void update(XmlEntity entity) {
        this.entity = entity;
        this.update(this.getResourceColumn());
    }

    @Override
    protected void initialize(XmlDiscriminatorColumn column) {
        super.initialize(column);
        this.specifiedLength = this.specifiedLength(column);
        this.specifiedDiscriminatorType = this.specifiedDiscriminatorType(column);
    }

    @Override
    protected void update(XmlDiscriminatorColumn column) {
        super.update(column);
        this.setSpecifiedLength_(this.specifiedLength(column));
        this.setSpecifiedDiscriminatorType_(this.specifiedDiscriminatorType(column));
    }

    protected Integer specifiedLength(XmlDiscriminatorColumn column) {
        return column == null ? null : column.getLength();
    }

    protected DiscriminatorType specifiedDiscriminatorType(XmlDiscriminatorColumn column) {
        return column == null ? null : DiscriminatorType.fromOrmResourceModel(column.getDiscriminatorType());
    }
}

