/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmBaseJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmDiscriminatorColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmNamedColumn;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTable;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeOverride;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlSecondaryTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.Inheritance;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverrideImpl;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlIdClass;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTableImpl;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGeneratorImpl;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGeneratorImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.DatabaseObject;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmEntity
extends AbstractOrmTypeMapping<XmlEntity>
implements OrmEntity,
PersistenceUnit.OrmGeneratorHolder,
PersistenceUnit.OrmQueryHolder {
    protected String specifiedName;
    protected String defaultName;
    protected String idClass;
    protected final OrmTable table = this.getJpaFactory().buildOrmTable(this);
    protected final List<OrmSecondaryTable> specifiedSecondaryTables = new ArrayList<OrmSecondaryTable>();
    protected final List<OrmSecondaryTable> virtualSecondaryTables = new ArrayList<OrmSecondaryTable>();
    protected final List<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected final List<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String defaultDiscriminatorValue;
    protected String specifiedDiscriminatorValue;
    protected boolean discriminatorValueAllowed;
    protected final OrmDiscriminatorColumn discriminatorColumn = this.buildDiscriminatorColumn();
    protected OrmSequenceGenerator sequenceGenerator;
    protected OrmTableGenerator tableGenerator;
    protected final List<OrmAttributeOverride> specifiedAttributeOverrides;
    protected final List<OrmAttributeOverride> virtualAttributeOverrides;
    protected final List<OrmAssociationOverride> specifiedAssociationOverrides;
    protected final List<OrmAssociationOverride> virtualAssociationOverrides;
    protected final List<OrmNamedQuery> namedQueries;
    protected final List<OrmNamedNativeQuery> namedNativeQueries;
    private static final org.eclipse.jpt.db.Table[] EMPTY_DB_TABLE_ARRAY = new org.eclipse.jpt.db.Table[0];

    public GenericOrmEntity(OrmPersistentType parent) {
        super(parent);
        this.specifiedPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
        this.defaultPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
        this.specifiedAttributeOverrides = new ArrayList<OrmAttributeOverride>();
        this.virtualAttributeOverrides = new ArrayList<OrmAttributeOverride>();
        this.specifiedAssociationOverrides = new ArrayList<OrmAssociationOverride>();
        this.virtualAssociationOverrides = new ArrayList<OrmAssociationOverride>();
        this.namedQueries = new ArrayList<OrmNamedQuery>();
        this.namedNativeQueries = new ArrayList<OrmNamedNativeQuery>();
    }

    protected OrmDiscriminatorColumn buildDiscriminatorColumn() {
        return this.getJpaFactory().buildOrmDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected OrmNamedColumn.Owner buildDiscriminatorColumnOwner() {
        return new OrmNamedColumn.Owner(){

            public org.eclipse.jpt.db.Table getDbTable(String tableName) {
                return GenericOrmEntity.this.getDbTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return GenericOrmEntity.this;
            }

            public String getDefaultColumnName() {
                return "DTYPE";
            }

            public TextRange getValidationTextRange() {
                return null;
            }
        };
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public String getPrimaryTableName() {
        return this.table.getName();
    }

    @Override
    public org.eclipse.jpt.db.Table getPrimaryDbTable() {
        return this.table.getDbTable();
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable(String tableName) {
        return (org.eclipse.jpt.db.Table)this.getDataSource().selectDatabaseObjectForIdentifier((DatabaseObject[])((org.eclipse.jpt.db.Table[])CollectionTools.array(this.associatedDbTablesIncludingInherited(), (Object[])EMPTY_DB_TABLE_ARRAY)), tableName);
    }

    private Iterator<org.eclipse.jpt.db.Table> associatedDbTablesIncludingInherited() {
        return new FilteringIterator<org.eclipse.jpt.db.Table, org.eclipse.jpt.db.Table>(this.associatedDbTablesIncludingInherited_()){

            protected boolean accept(org.eclipse.jpt.db.Table t) {
                return t != null;
            }
        };
    }

    private Iterator<org.eclipse.jpt.db.Table> associatedDbTablesIncludingInherited_() {
        return new TransformationIterator<Table, org.eclipse.jpt.db.Table>(this.associatedTablesIncludingInherited()){

            protected org.eclipse.jpt.db.Table transform(Table t) {
                return t.getDbTable();
            }
        };
    }

    @Override
    public Schema getDbSchema() {
        return this.table.getDbSchema();
    }

    @Override
    public JavaEntity getJavaEntity() {
        if (this.javaPersistentType != null && this.javaPersistentType.getMappingKey() == "entity") {
            return (JavaEntity)this.javaPersistentType.getMapping();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        ((XmlEntity)this.getTypeMappingResource()).setName(newSpecifiedName);
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultName", oldDefaultName, newDefaultName);
    }

    @Override
    public OrmTable getTable() {
        return this.table;
    }

    @Override
    public ListIterator<OrmSecondaryTable> secondaryTables() {
        if (this.specifiedSecondaryTablesSize() > 0) {
            return this.specifiedSecondaryTables();
        }
        return this.virtualSecondaryTables();
    }

    @Override
    public int secondaryTablesSize() {
        if (this.specifiedSecondaryTablesSize() > 0) {
            return this.specifiedSecondaryTablesSize();
        }
        return this.virtualSecondaryTablesSize();
    }

    @Override
    public ListIterator<OrmSecondaryTable> virtualSecondaryTables() {
        return new CloneListIterator(this.virtualSecondaryTables);
    }

    @Override
    public int virtualSecondaryTablesSize() {
        return this.virtualSecondaryTables.size();
    }

    protected void addVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.addItemToList(secondaryTable, this.virtualSecondaryTables, "virtualSecondaryTablesList");
    }

    protected void removeVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.virtualSecondaryTables, "virtualSecondaryTablesList");
    }

    @Override
    public ListIterator<OrmSecondaryTable> specifiedSecondaryTables() {
        return new CloneListIterator(this.specifiedSecondaryTables);
    }

    @Override
    public int specifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTables.size();
    }

    @Override
    public OrmSecondaryTable addSpecifiedSecondaryTable(int index) {
        if (!this.secondaryTablesDefinedInXml()) {
            throw new IllegalStateException("Virtual secondary tables exist, must first call setSecondaryTablesDefinedInXml(true)");
        }
        XmlSecondaryTableImpl secondaryTableResource = OrmFactory.eINSTANCE.createXmlSecondaryTableImpl();
        OrmSecondaryTable secondaryTable = this.buildSecondaryTable(secondaryTableResource);
        this.specifiedSecondaryTables.add(index, secondaryTable);
        ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().add(index, (Object)secondaryTableResource);
        this.fireItemAdded("specifiedSecondaryTables", index, secondaryTable);
        return secondaryTable;
    }

    @Override
    public OrmSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size());
    }

    protected void addSpecifiedSecondaryTable(int index, OrmSecondaryTable secondaryTable) {
        this.addItemToList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    protected void addSpecifiedSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size(), secondaryTable);
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        OrmSecondaryTable removedSecondaryTable = this.specifiedSecondaryTables.remove(index);
        ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().remove(index);
        this.fireItemRemoved("specifiedSecondaryTables", index, removedSecondaryTable);
    }

    protected void removeSpecifiedSecondaryTable_(OrmSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedSecondaryTables, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedSecondaryTables", targetIndex, sourceIndex);
    }

    public boolean containsSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.secondaryTables());
    }

    public boolean containsSpecifiedSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.specifiedSecondaryTables());
    }

    public boolean containsVirtualSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.virtualSecondaryTables());
    }

    @Override
    public boolean containsVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        return this.virtualSecondaryTables.contains(secondaryTable);
    }

    protected boolean containsSecondaryTable(String name, ListIterator<OrmSecondaryTable> secondaryTables) {
        for (OrmSecondaryTable secondaryTable : CollectionTools.iterable(secondaryTables)) {
            String secondaryTableName = secondaryTable.getName();
            if (secondaryTableName == null || !secondaryTableName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean secondaryTablesDefinedInXml() {
        return this.virtualSecondaryTablesSize() == 0;
    }

    @Override
    public void setSecondaryTablesDefinedInXml(boolean defineInXml) {
        if (defineInXml == this.secondaryTablesDefinedInXml()) {
            return;
        }
        if (defineInXml) {
            this.specifySecondaryTablesInXml();
        } else {
            this.removeSecondaryTablesFromXml();
        }
    }

    protected void specifySecondaryTablesInXml() {
        if (this.virtualSecondaryTablesSize() != 0) {
            List virtualSecondaryTables1 = CollectionTools.list(this.virtualSecondaryTables());
            List virtualSecondaryTables2 = CollectionTools.list(this.virtualSecondaryTables());
            for (OrmSecondaryTable virtualSecondaryTable : CollectionTools.iterable(this.virtualSecondaryTables())) {
                this.virtualSecondaryTables.remove(virtualSecondaryTable);
            }
            for (OrmSecondaryTable virtualSecondaryTable : virtualSecondaryTables2) {
                XmlSecondaryTableImpl secondaryTableResource = OrmFactory.eINSTANCE.createXmlSecondaryTableImpl();
                OrmSecondaryTable specifiedSecondaryTable = this.buildSecondaryTable(secondaryTableResource);
                this.specifiedSecondaryTables.add(specifiedSecondaryTable);
                ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().add((Object)secondaryTableResource);
                specifiedSecondaryTable.initializeFrom(virtualSecondaryTable);
            }
            this.fireItemsRemoved("virtualSecondaryTablesList", 0, virtualSecondaryTables1);
            this.fireItemsAdded("specifiedSecondaryTables", 0, this.specifiedSecondaryTables);
        }
    }

    protected void removeSecondaryTablesFromXml() {
        if (this.specifiedSecondaryTablesSize() != 0) {
            List specifiedSecondaryTablesCopy = CollectionTools.list(this.specifiedSecondaryTables());
            for (OrmSecondaryTable specifiedSecondaryTable : CollectionTools.iterable(this.specifiedSecondaryTables())) {
                int index = this.specifiedSecondaryTables.indexOf(specifiedSecondaryTable);
                this.specifiedSecondaryTables.remove(specifiedSecondaryTable);
                if (this.specifiedSecondaryTables.size() == 0) {
                    this.initializeVirtualSecondaryTables();
                }
                ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().remove(index);
            }
            this.fireItemsRemoved("specifiedSecondaryTables", 0, specifiedSecondaryTablesCopy);
            if (this.virtualSecondaryTables.size() != 0) {
                this.fireItemsAdded("virtualSecondaryTablesList", 0, this.virtualSecondaryTables);
            }
        }
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                return t.getName();
            }
        };
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return this.nonNullTableNames(this.associatedTablesIncludingInherited());
    }

    protected Iterator<String> nonNullTableNames(Iterator<Table> tables) {
        return new FilteringIterator<String, String>(this.tableNames(tables)){

            protected boolean accept(String o) {
                return o != null;
            }
        };
    }

    @Override
    public Iterator<Table> associatedTables() {
        return new CompositeIterator((Object)this.table, this.secondaryTables());
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<Table>>(this.inheritanceHierarchy()){

            protected Iterator<Table> transform(TypeMapping mapping) {
                return new FilteringIterator<Table, Table>(mapping.associatedTables()){

                    protected boolean accept(Table o) {
                        return true;
                    }
                };
            }
        });
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !CollectionTools.contains(this.associatedTableNamesIncludingInherited(), (Object)tableName);
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.getSpecifiedInheritanceStrategy() == null ? this.getDefaultInheritanceStrategy() : this.getSpecifiedInheritanceStrategy();
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        if (oldInheritanceType != newInheritanceType) {
            if (this.inheritanceResource() != null) {
                this.inheritanceResource().setStrategy(InheritanceType.toOrmResourceModel(newInheritanceType));
                if (this.inheritanceResource().isAllFeaturesUnset()) {
                    this.removeInheritanceResource();
                }
            } else if (newInheritanceType != null) {
                this.addInheritanceResource();
                this.inheritanceResource().setStrategy(InheritanceType.toOrmResourceModel(newInheritanceType));
            }
        }
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected Inheritance inheritanceResource() {
        return ((XmlEntity)this.getTypeMappingResource()).getInheritance();
    }

    protected void addInheritanceResource() {
        ((XmlEntity)this.getTypeMappingResource()).setInheritance(OrmFactory.eINSTANCE.createInheritance());
    }

    protected void removeInheritanceResource() {
        ((XmlEntity)this.getTypeMappingResource()).setInheritance(null);
    }

    @Override
    public OrmDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        XmlSequenceGeneratorImpl resourceSequenceGenerator = OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl();
        this.sequenceGenerator = this.buildSequenceGenerator(resourceSequenceGenerator);
        ((XmlEntity)this.getTypeMappingResource()).setSequenceGenerator(resourceSequenceGenerator);
        this.firePropertyChanged("sequenceGenerator", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        ((XmlEntity)this.getTypeMappingResource()).setSequenceGenerator(null);
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, null);
    }

    @Override
    public OrmSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(OrmSequenceGenerator newSequenceGenerator) {
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, newSequenceGenerator);
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        XmlTableGeneratorImpl resourceTableGenerator = OrmFactory.eINSTANCE.createXmlTableGeneratorImpl();
        this.tableGenerator = this.buildTableGenerator(resourceTableGenerator);
        ((XmlEntity)this.getTypeMappingResource()).setTableGenerator(resourceTableGenerator);
        this.firePropertyChanged("tableGenerator", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        ((XmlEntity)this.getTypeMappingResource()).setTableGenerator(null);
        this.firePropertyChanged("tableGenerator", oldTableGenerator, null);
    }

    @Override
    public OrmTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(OrmTableGenerator newTableGenerator) {
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGenerator", oldTableGenerator, newTableGenerator);
    }

    @Override
    public Iterator<OrmGenerator> generators() {
        ArrayList<OrmGenerator> generators = new ArrayList<OrmGenerator>();
        this.addGeneratorsTo(generators);
        return generators.iterator();
    }

    protected void addGeneratorsTo(ArrayList<OrmGenerator> generators) {
        if (this.sequenceGenerator != null) {
            generators.add(this.sequenceGenerator);
        }
        if (this.tableGenerator != null) {
            generators.add(this.tableGenerator);
        }
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String newDefaultDiscriminatorValue) {
        String oldDefaultDiscriminatorValue = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = newDefaultDiscriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", oldDefaultDiscriminatorValue, newDefaultDiscriminatorValue);
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        ((XmlEntity)this.getTypeMappingResource()).setDiscriminatorValue(newSpecifiedDiscriminatorValue);
        this.firePropertyChanged("specifiedDiscriminatorValue", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getSpecifiedDiscriminatorValue() == null ? this.getDefaultDiscriminatorValue() : this.getSpecifiedDiscriminatorValue();
    }

    @Override
    public boolean isDiscriminatorValueAllowed() {
        return this.discriminatorValueAllowed;
    }

    protected void setDiscriminatorValueAllowed(boolean newDiscriminatorValueAllowed) {
        boolean oldDiscriminatorValueAllowed = this.discriminatorValueAllowed;
        this.discriminatorValueAllowed = newDiscriminatorValueAllowed;
        this.firePropertyChanged("discriminatorValueAllowed", oldDiscriminatorValueAllowed, newDiscriminatorValueAllowed);
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.defaultPrimaryKeyJoinColumns);
    }

    public int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumns.size();
    }

    @Override
    public OrmPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        throw new UnsupportedOperationException("use defaultPrimaryKeyJoinColumns() instead");
    }

    protected void addDefaultPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn defaultPkJoinColumn) {
        this.addItemToList(defaultPkJoinColumn, this.defaultPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumnsList");
    }

    protected void removeDefaultPrimaryKeyJoinColumn(PrimaryKeyJoinColumn defaultPkJoinColumn) {
        this.removeItemFromList(defaultPkJoinColumn, this.defaultPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumnsList");
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumns.isEmpty() ? this.defaultPrimaryKeyJoinColumns() : this.specifiedPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.isEmpty() ? this.defaultPrimaryKeyJoinColumnsSize() : this.specifiedPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        if (!this.defaultPrimaryKeyJoinColumns.isEmpty()) {
            this.defaultPrimaryKeyJoinColumns.clear();
        }
        XmlPrimaryKeyJoinColumnImpl resourcePkJoinColumn = OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumnImpl();
        OrmPrimaryKeyJoinColumn contextPkJoinColumn = this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn);
        this.specifiedPrimaryKeyJoinColumns.add(index, contextPkJoinColumn);
        ((XmlEntity)this.getTypeMappingResource()).getPrimaryKeyJoinColumns().add(index, (Object)resourcePkJoinColumn);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumns", index, contextPkJoinColumn);
        this.fireListCleared("defaultPrimaryKeyJoinColumnsList");
        return contextPkJoinColumn;
    }

    protected OrmBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.size(), primaryKeyJoinColumn);
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.initializeDefaultPrimaryKeyJoinColumns();
        }
        ((XmlEntity)this.getTypeMappingResource()).getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumns", index, removedPrimaryKeyJoinColumn);
        if (!this.defaultPrimaryKeyJoinColumns.isEmpty()) {
            this.fireListChanged("defaultPrimaryKeyJoinColumnsList");
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedPrimaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedPrimaryKeyJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<OrmAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    protected void addVirtualAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.addItemToList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    protected void removeVirtualAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    protected OrmAttributeOverride setAttributeOverrideVirtual(boolean virtual, OrmAttributeOverride attributeOverride) {
        if (virtual) {
            return this.setAttributeOverrideVirtual(attributeOverride);
        }
        return this.setAttributeOverrideSpecified(attributeOverride);
    }

    protected OrmAttributeOverride setAttributeOverrideVirtual(OrmAttributeOverride attributeOverride) {
        int index = this.specifiedAttributeOverrides.indexOf(attributeOverride);
        this.specifiedAttributeOverrides.remove(index);
        String attributeOverrideName = attributeOverride.getName();
        OrmAttributeOverride virtualAttributeOverride = null;
        if (attributeOverrideName != null) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
                if (!persistentAttribute.getName().equals(attributeOverrideName)) continue;
                JavaAttributeOverride javaAttributeOverride = null;
                if (this.getJavaEntity() != null) {
                    javaAttributeOverride = this.getJavaEntity().getAttributeOverrideNamed(attributeOverrideName);
                }
                virtualAttributeOverride = this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride);
                this.virtualAttributeOverrides.add(virtualAttributeOverride);
            }
        }
        ((XmlEntity)this.getTypeMappingResource()).getAttributeOverrides().remove(index);
        this.fireItemRemoved("specifiedAttributeOverrides", index, attributeOverride);
        if (virtualAttributeOverride != null) {
            this.fireItemAdded("virtualAttributeOverrides", this.virtualAttributeOverridesSize() - 1, virtualAttributeOverride);
        }
        return virtualAttributeOverride;
    }

    protected OrmAttributeOverride setAttributeOverrideSpecified(OrmAttributeOverride oldAttributeOverride) {
        int index = this.specifiedAttributeOverridesSize();
        XmlAttributeOverrideImpl xmlAttributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl();
        OrmAttributeOverride newAttributeOverride = this.getJpaFactory().buildOrmAttributeOverride(this, this.createAttributeOverrideOwner(), xmlAttributeOverride);
        this.specifiedAttributeOverrides.add(index, newAttributeOverride);
        ((XmlEntity)this.getTypeMappingResource()).getAttributeOverrides().add((Object)xmlAttributeOverride);
        int defaultIndex = this.virtualAttributeOverrides.indexOf(oldAttributeOverride);
        this.virtualAttributeOverrides.remove(defaultIndex);
        newAttributeOverride.setName(oldAttributeOverride.getName());
        newAttributeOverride.getColumn().setSpecifiedName(oldAttributeOverride.getColumn().getName());
        this.fireItemRemoved("virtualAttributeOverrides", defaultIndex, oldAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverrides", index, newAttributeOverride);
        return newAttributeOverride;
    }

    @Override
    public ListIterator<OrmAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected void addSpecifiedAttributeOverride(int index, OrmAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    protected void addSpecifiedAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.addSpecifiedAttributeOverride(this.specifiedAttributeOverrides.size(), attributeOverride);
    }

    protected void removeSpecifiedAttributeOverride_(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getAttributeOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAttributeOverrides", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmAssociationOverride> associationOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAssociationOverrides(), this.virtualAssociationOverrides()});
    }

    @Override
    public int associationOverridesSize() {
        return this.specifiedAssociationOverridesSize() + this.virtualAssociationOverridesSize();
    }

    @Override
    public ListIterator<OrmAssociationOverride> virtualAssociationOverrides() {
        return new CloneListIterator(this.virtualAssociationOverrides);
    }

    @Override
    public int virtualAssociationOverridesSize() {
        return this.virtualAssociationOverrides.size();
    }

    @Override
    public ListIterator<OrmAssociationOverride> specifiedAssociationOverrides() {
        return new CloneListIterator(this.specifiedAssociationOverrides);
    }

    @Override
    public int specifiedAssociationOverridesSize() {
        return this.specifiedAssociationOverrides.size();
    }

    protected void addSpecifiedAssociationOverride(int index, OrmAssociationOverride associationOverride) {
        this.addItemToList(index, associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    protected void addSpecifiedAssociationOverride(OrmAssociationOverride associationOverride) {
        this.addSpecifiedAssociationOverride(this.specifiedAssociationOverrides.size(), associationOverride);
    }

    protected void removeSpecifiedAssociationOverride_(OrmAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    @Override
    public void moveSpecifiedAssociationOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAssociationOverrides, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getAssociationOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAssociationOverrides", targetIndex, sourceIndex);
    }

    @Override
    public OrmAttributeOverride getAttributeOverrideNamed(String name) {
        return (OrmAttributeOverride)this.getOverrideNamed(name, this.attributeOverrides());
    }

    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, this.attributeOverrides());
    }

    public boolean containsDefaultAttributeOverride(String name) {
        return this.containsOverride(name, this.virtualAttributeOverrides());
    }

    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, this.specifiedAttributeOverrides());
    }

    public OrmAssociationOverride getAssociationOverrideNamed(String name) {
        return (OrmAssociationOverride)this.getOverrideNamed(name, this.associationOverrides());
    }

    public boolean containsAssociationOverride(String name) {
        return this.containsOverride(name, this.associationOverrides());
    }

    public boolean containsSpecifiedAssociationOverride(String name) {
        return this.containsOverride(name, this.specifiedAssociationOverrides());
    }

    public boolean containsDefaultAssociationOverride(String name) {
        return this.containsOverride(name, this.virtualAssociationOverrides());
    }

    private BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    private boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.getOverrideNamed(name, overrides) != null;
    }

    @Override
    public ListIterator<OrmNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public OrmNamedQuery addNamedQuery(int index) {
        XmlNamedQuery resourceNamedQuery = OrmFactory.eINSTANCE.createXmlNamedQuery();
        OrmNamedQuery contextNamedQuery = this.buildNamedQuery(resourceNamedQuery);
        this.namedQueries.add(index, contextNamedQuery);
        ((XmlEntity)this.getTypeMappingResource()).getNamedQueries().add(index, (Object)resourceNamedQuery);
        this.fireItemAdded("namedQueriesList", index, contextNamedQuery);
        return contextNamedQuery;
    }

    protected void addNamedQuery(int index, OrmNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueriesList");
    }

    protected void addNamedQuery(OrmNamedQuery namedQuery) {
        this.addNamedQuery(this.namedQueries.size(), namedQuery);
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        OrmNamedQuery namedQuery = this.namedQueries.remove(index);
        ((XmlEntity)this.getTypeMappingResource()).getNamedQueries().remove(index);
        this.fireItemRemoved("namedQueriesList", index, namedQuery);
    }

    protected void removeNamedQuery_(OrmNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueriesList");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedQueries, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getNamedQueries().move(targetIndex, sourceIndex);
        this.fireItemMoved("namedQueriesList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public OrmNamedNativeQuery addNamedNativeQuery(int index) {
        XmlNamedNativeQuery resourceNamedNativeQuery = OrmFactory.eINSTANCE.createXmlNamedNativeQuery();
        OrmNamedNativeQuery contextNamedNativeQuery = this.buildNamedNativeQuery(resourceNamedNativeQuery);
        this.namedNativeQueries.add(index, contextNamedNativeQuery);
        ((XmlEntity)this.getTypeMappingResource()).getNamedNativeQueries().add(index, (Object)resourceNamedNativeQuery);
        this.fireItemAdded("namedNativeQueriesList", index, contextNamedNativeQuery);
        return contextNamedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, OrmNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    protected void addNamedNativeQuery(OrmNamedNativeQuery namedNativeQuery) {
        this.addNamedNativeQuery(this.namedNativeQueries.size(), namedNativeQuery);
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        OrmNamedNativeQuery namedNativeQuery = this.namedNativeQueries.remove(index);
        ((XmlEntity)this.getTypeMappingResource()).getNamedNativeQueries().remove(index);
        this.fireItemRemoved("namedNativeQueriesList", index, namedNativeQuery);
    }

    protected void removeNamedNativeQuery_(OrmNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedNativeQueries, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getNamedNativeQueries().move(targetIndex, sourceIndex);
        this.fireItemMoved("namedNativeQueriesList", targetIndex, sourceIndex);
    }

    @Override
    public Iterator<OrmQuery> queries() {
        return new CompositeIterator(new Iterator[]{this.namedQueries(), this.namedNativeQueries()});
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (oldIdClass != newIdClass) {
            if (this.idClassResource() != null) {
                this.idClassResource().setClassName(newIdClass);
                if (this.idClassResource().isAllFeaturesUnset()) {
                    this.removeIdClassResource();
                }
            } else if (newIdClass != null) {
                this.addIdClassResource();
                this.idClassResource().setClassName(newIdClass);
            }
        }
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected void setIdClass_(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected XmlIdClass idClassResource() {
        return ((XmlEntity)this.getTypeMappingResource()).getIdClass();
    }

    protected void addIdClassResource() {
        ((XmlEntity)this.getTypeMappingResource()).setIdClass(OrmFactory.eINSTANCE.createXmlIdClass());
    }

    protected void removeIdClassResource() {
        ((XmlEntity)this.getTypeMappingResource()).setIdClass(null);
    }

    @Override
    public Entity getParentEntity() {
        Iterator<PersistentType> stream = this.getPersistentType().ancestors();
        while (stream.hasNext()) {
            TypeMapping tm = stream.next().getMapping();
            if (!(tm instanceof Entity)) continue;
            return (Entity)tm;
        }
        return this;
    }

    @Override
    public Entity getRootEntity() {
        Entity rootEntity = null;
        Iterator<PersistentType> stream = this.getPersistentType().inheritanceHierarchy();
        while (stream.hasNext()) {
            PersistentType persistentType = stream.next();
            if (!(persistentType.getMapping() instanceof Entity)) continue;
            rootEntity = (Entity)persistentType.getMapping();
        }
        return rootEntity;
    }

    @Override
    public String getDefaultTableName() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            JavaTable javaTable = javaEntity.getTable();
            if (!this.isMetadataComplete() && !this.table.hasSpecifiedResourceTable() && javaTable.getSpecifiedName() != null) {
                return javaTable.getSpecifiedName();
            }
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getName() : this.getName();
    }

    @Override
    public String getDefaultSchema() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            if (this.isMetadataComplete() || this.table.hasSpecifiedResourceTable()) {
                return javaEntity.getTable().getDefaultSchema();
            }
            return javaEntity.getTable().getSchema();
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getSchema() : this.getContextDefaultSchema();
    }

    @Override
    public String getDefaultCatalog() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            if (this.isMetadataComplete() || this.table.hasSpecifiedResourceTable()) {
                return javaEntity.getTable().getDefaultCatalog();
            }
            return javaEntity.getTable().getCatalog();
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getCatalog() : this.getContextDefaultCatalog();
    }

    protected boolean isSingleTableDescendant() {
        return this.isDescendant() && this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE;
    }

    protected boolean isDescendant() {
        return !this.isRoot();
    }

    protected boolean isRoot() {
        return this == this.getRootEntity();
    }

    @Override
    public int getXmlSequence() {
        return 1;
    }

    protected Iterator<TypeMapping> inheritanceHierarchy() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().inheritanceHierarchy()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(TypeMapping mapping) {
                return mapping.overridableAttributes();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAttributeNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAssociationNames();
            }
        });
    }

    @Override
    public void initialize(XmlEntity entity) {
        super.initialize(entity);
        this.specifiedName = entity.getName();
        this.defaultName = this.buildDefaultName();
        this.initializeInheritance(this.inheritanceResource());
        this.discriminatorColumn.initialize(entity);
        this.specifiedDiscriminatorValue = entity.getDiscriminatorValue();
        this.defaultDiscriminatorValue = this.defaultDiscriminatorValue();
        this.discriminatorValueAllowed = this.discriminatorValueIsAllowed();
        this.table.initialize(entity);
        this.initializeSpecifiedSecondaryTables(entity);
        this.initializeVirtualSecondaryTables();
        this.initializeSequenceGenerator(entity);
        this.initializeTableGenerator(entity);
        this.initializeSpecifiedPrimaryKeyJoinColumns(entity);
        this.initializeDefaultPrimaryKeyJoinColumns();
        this.initializeSpecifiedAttributeOverrides(entity);
        this.initializeVirtualAttributeOverrides();
        this.initializeSpecifiedAssociationOverrides(entity);
        this.initializeNamedQueries(entity);
        this.initializeNamedNativeQueries(entity);
        this.initializeIdClass(this.idClassResource());
        this.updatePersistenceUnitGeneratorsAndQueries();
    }

    protected void initializeInheritance(Inheritance inheritanceResource) {
        this.specifiedInheritanceStrategy = this.specifiedInheritanceStrategy(inheritanceResource);
        this.defaultInheritanceStrategy = this.defaultInheritanceStrategy();
    }

    protected void initializeSpecifiedSecondaryTables(XmlEntity entity) {
        for (XmlSecondaryTable secondaryTable : entity.getSecondaryTables()) {
            this.specifiedSecondaryTables.add(this.buildSecondaryTable(secondaryTable));
        }
    }

    protected void initializeVirtualSecondaryTables() {
        if (this.isMetadataComplete()) {
            return;
        }
        if (this.getJavaEntity() == null) {
            return;
        }
        if (this.specifiedSecondaryTablesSize() > 0) {
            return;
        }
        ListIterator<JavaSecondaryTable> javaSecondaryTables = this.getJavaEntity().secondaryTables();
        while (javaSecondaryTables.hasNext()) {
            JavaSecondaryTable javaSecondaryTable = javaSecondaryTables.next();
            if (javaSecondaryTable.getName() == null) continue;
            this.virtualSecondaryTables.add(this.buildVirtualSecondaryTable(javaSecondaryTable));
        }
    }

    protected void initializeDefaultPrimaryKeyJoinColumns() {
        if (this.isMetadataComplete()) {
            return;
        }
        if (this.getJavaEntity() == null) {
            this.defaultPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(null));
            return;
        }
        if (this.specifiedPrimaryKeyJoinColumnsSize() > 0) {
            return;
        }
        ListIterator<JavaPrimaryKeyJoinColumn> javaPkJoinColumns = this.getJavaEntity().primaryKeyJoinColumns();
        while (javaPkJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn javaPkJoinColumn = javaPkJoinColumns.next();
            if (javaPkJoinColumn.getName() == null) continue;
            this.defaultPrimaryKeyJoinColumns.add(this.buildVirtualPrimaryKeyJoinColumn(javaPkJoinColumn));
        }
    }

    protected void initializeTableGenerator(XmlEntity entity) {
        if (entity.getTableGenerator() != null) {
            this.tableGenerator = this.buildTableGenerator(entity.getTableGenerator());
        }
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator resourceTableGenerator) {
        return this.getJpaFactory().buildOrmTableGenerator(this, resourceTableGenerator);
    }

    protected void initializeSequenceGenerator(XmlEntity entity) {
        if (entity.getSequenceGenerator() != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(entity.getSequenceGenerator());
        }
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator resourceSequenceGenerator) {
        return this.getJpaFactory().buildOrmSequenceGenerator(this, resourceSequenceGenerator);
    }

    protected void initializeSpecifiedPrimaryKeyJoinColumns(XmlEntity entity) {
        for (XmlPrimaryKeyJoinColumn resourcePkJoinColumn : entity.getPrimaryKeyJoinColumns()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn));
        }
    }

    protected void initializeSpecifiedAttributeOverrides(XmlEntity entity) {
        for (XmlAttributeOverride attributeOverride : entity.getAttributeOverrides()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride(attributeOverride));
        }
    }

    protected void initializeVirtualAttributeOverrides() {
        for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
            OrmAttributeOverride attributeOverride = this.getAttributeOverrideNamed(persistentAttribute.getName());
            if (attributeOverride != null) continue;
            JavaAttributeOverride javaAttributeOverride = null;
            if (this.getJavaEntity() != null) {
                javaAttributeOverride = this.getJavaEntity().getAttributeOverrideNamed(persistentAttribute.getName());
            }
            this.virtualAttributeOverrides.add(this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride));
        }
    }

    protected OrmAttributeOverride buildVirtualAttributeOverride(PersistentAttribute persistentAttribute, JavaAttributeOverride javaAttributeOverride) {
        return this.buildAttributeOverride(this.buildVirtualXmlAttributeOverride(persistentAttribute, javaAttributeOverride));
    }

    protected XmlAttributeOverride buildVirtualXmlAttributeOverride(PersistentAttribute persistentAttribute, JavaAttributeOverride javaAttributeOverride) {
        VirtualXmlColumn xmlColumn;
        if (javaAttributeOverride == null) {
            ColumnMapping columnMapping = (ColumnMapping)((Object)persistentAttribute.getMapping());
            xmlColumn = new VirtualXmlColumn(this, columnMapping.getColumn(), false);
        } else {
            xmlColumn = new VirtualXmlColumn(this, javaAttributeOverride.getColumn(), this.isMetadataComplete());
        }
        return new VirtualXmlAttributeOverride(persistentAttribute.getName(), xmlColumn);
    }

    protected void initializeSpecifiedAssociationOverrides(XmlEntity entity) {
        for (XmlAssociationOverride associationOverride : entity.getAssociationOverrides()) {
            this.specifiedAssociationOverrides.add(this.buildAssociationOverride(associationOverride));
        }
    }

    protected void initializeNamedQueries(XmlEntity entity) {
        for (XmlNamedQuery namedQuery : entity.getNamedQueries()) {
            this.namedQueries.add(this.buildNamedQuery(namedQuery));
        }
    }

    protected void initializeNamedNativeQueries(XmlEntity entity) {
        for (XmlNamedNativeQuery namedNativeQuery : entity.getNamedNativeQueries()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery(namedNativeQuery));
        }
    }

    protected void initializeIdClass(XmlIdClass idClassResource) {
        this.idClass = this.idClass(idClassResource);
    }

    protected String idClass(XmlIdClass idClassResource) {
        return idClassResource == null ? null : idClassResource.getClassName();
    }

    @Override
    public void update(XmlEntity entity) {
        super.update(entity);
        this.setSpecifiedName(entity.getName());
        this.setDefaultName(this.buildDefaultName());
        this.updateInheritance(this.inheritanceResource());
        this.discriminatorColumn.update(entity);
        this.setSpecifiedDiscriminatorValue(entity.getDiscriminatorValue());
        this.setDefaultDiscriminatorValue(this.defaultDiscriminatorValue());
        this.setDiscriminatorValueAllowed(this.discriminatorValueIsAllowed());
        this.table.update(entity);
        this.updateSpecifiedSecondaryTables(entity);
        this.updateVirtualSecondaryTables();
        this.updateSequenceGenerator(entity);
        this.updateTableGenerator(entity);
        this.updateSpecifiedPrimaryKeyJoinColumns(entity);
        this.updateDefaultPrimaryKeyJoinColumns();
        this.updateSpecifiedAttributeOverrides(entity);
        this.updateVirtualAttributeOverrides();
        this.updateSpecifiedAssociationOverrides(entity);
        this.updateNamedQueries(entity);
        this.updateNamedNativeQueries(entity);
        this.updateIdClass(this.idClassResource());
        this.updatePersistenceUnitGeneratorsAndQueries();
    }

    protected String buildDefaultName() {
        JavaEntity javaEntity;
        if (!this.isMetadataComplete() && (javaEntity = this.getJavaEntity()) != null) {
            return javaEntity.getName();
        }
        String className = this.getClass_();
        if (className != null) {
            return ClassTools.shortNameForClassNamed((String)className);
        }
        return null;
    }

    protected String defaultDiscriminatorValue() {
        return null;
    }

    protected boolean discriminatorValueIsAllowed() {
        JavaResourcePersistentType javaResourcePersistentType = this.getJavaResourcePersistentType();
        return javaResourcePersistentType == null ? false : !javaResourcePersistentType.isAbstract();
    }

    protected void updateInheritance(Inheritance inheritanceResource) {
        this.setSpecifiedInheritanceStrategy_(this.specifiedInheritanceStrategy(inheritanceResource));
        this.setDefaultInheritanceStrategy(this.defaultInheritanceStrategy());
    }

    protected void updateSpecifiedSecondaryTables(XmlEntity entity) {
        ListIterator<OrmSecondaryTable> secondaryTables = this.specifiedSecondaryTables();
        CloneListIterator resourceSecondaryTables = new CloneListIterator(entity.getSecondaryTables());
        while (secondaryTables.hasNext()) {
            OrmSecondaryTable secondaryTable = secondaryTables.next();
            if (resourceSecondaryTables.hasNext()) {
                secondaryTable.update((XmlSecondaryTable)resourceSecondaryTables.next());
                continue;
            }
            this.removeSpecifiedSecondaryTable_(secondaryTable);
        }
        while (resourceSecondaryTables.hasNext()) {
            this.addSpecifiedSecondaryTable(this.buildSecondaryTable((XmlSecondaryTable)resourceSecondaryTables.next()));
        }
    }

    protected void updateVirtualSecondaryTables() {
        ListIterator<OrmSecondaryTable> secondaryTables = this.virtualSecondaryTables();
        ListIterator<JavaSecondaryTable> javaSecondaryTables = EmptyListIterator.instance();
        if (this.getJavaEntity() != null && !this.isMetadataComplete() && this.specifiedSecondaryTablesSize() == 0) {
            javaSecondaryTables = this.getJavaEntity().secondaryTables();
        }
        while (secondaryTables.hasNext()) {
            OrmSecondaryTable virtualSecondaryTable = secondaryTables.next();
            if (javaSecondaryTables.hasNext()) {
                JavaSecondaryTable javaSecondaryTable = javaSecondaryTables.next();
                virtualSecondaryTable.update(new VirtualXmlSecondaryTable(javaSecondaryTable));
                continue;
            }
            this.removeVirtualSecondaryTable(virtualSecondaryTable);
        }
        while (javaSecondaryTables.hasNext()) {
            JavaSecondaryTable javaSecondaryTable = (JavaSecondaryTable)javaSecondaryTables.next();
            this.addVirtualSecondaryTable(this.buildVirtualSecondaryTable(javaSecondaryTable));
        }
    }

    protected OrmSecondaryTable buildSecondaryTable(XmlSecondaryTable xmlSecondaryTable) {
        return this.getJpaFactory().buildOrmSecondaryTable(this, xmlSecondaryTable);
    }

    protected OrmSecondaryTable buildVirtualSecondaryTable(JavaSecondaryTable javaSecondaryTable) {
        return this.buildSecondaryTable(new VirtualXmlSecondaryTable(javaSecondaryTable));
    }

    protected void updateTableGenerator(XmlEntity resourceEntity) {
        if (resourceEntity.getTableGenerator() == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(resourceEntity.getTableGenerator()));
        } else {
            this.getTableGenerator().update(resourceEntity.getTableGenerator());
        }
    }

    protected void updateSequenceGenerator(XmlEntity resourceEntity) {
        if (resourceEntity.getSequenceGenerator() == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(resourceEntity.getSequenceGenerator()));
        } else {
            this.getSequenceGenerator().update(resourceEntity.getSequenceGenerator());
        }
    }

    protected InheritanceType specifiedInheritanceStrategy(Inheritance inheritanceResource) {
        if (inheritanceResource == null) {
            return null;
        }
        return InheritanceType.fromOrmResourceModel(inheritanceResource.getStrategy());
    }

    protected InheritanceType defaultInheritanceStrategy() {
        if (this.inheritanceResource() == null && !this.isMetadataComplete() && this.getJavaEntity() != null) {
            return this.getJavaEntity().getInheritanceStrategy();
        }
        return this.isRoot() ? InheritanceType.SINGLE_TABLE : this.getRootEntity().getInheritanceStrategy();
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns(XmlEntity entity) {
        ListIterator<OrmPrimaryKeyJoinColumn> contextPkJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        CloneListIterator resourcePkJoinColumns = new CloneListIterator(entity.getPrimaryKeyJoinColumns());
        while (contextPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn contextPkJoinColumn = contextPkJoinColumns.next();
            if (resourcePkJoinColumns.hasNext()) {
                contextPkJoinColumn.update((XmlPrimaryKeyJoinColumn)resourcePkJoinColumns.next());
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(contextPkJoinColumn);
        }
        while (resourcePkJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)resourcePkJoinColumns.next()));
        }
    }

    protected void updateDefaultPrimaryKeyJoinColumns() {
        ListIterator<OrmPrimaryKeyJoinColumn> defaultPkJoinColumns = this.defaultPrimaryKeyJoinColumns();
        ListIterator<JavaPrimaryKeyJoinColumn> javaPkJoinColumns = EmptyListIterator.instance();
        if (this.getJavaEntity() != null && !this.isMetadataComplete() && this.specifiedPrimaryKeyJoinColumnsSize() == 0) {
            javaPkJoinColumns = this.getJavaEntity().primaryKeyJoinColumns();
        }
        while (defaultPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn defaultPkJoinColumn = defaultPkJoinColumns.next();
            if (javaPkJoinColumns.hasNext()) {
                JavaPrimaryKeyJoinColumn javaPkJoinColumn = javaPkJoinColumns.next();
                defaultPkJoinColumn.update(new VirtualXmlPrimaryKeyJoinColumn(javaPkJoinColumn));
                continue;
            }
            if (this.defaultPrimaryKeyJoinColumnsSize() == 1) {
                defaultPkJoinColumn.update(null);
                continue;
            }
            this.removeDefaultPrimaryKeyJoinColumn(defaultPkJoinColumn);
        }
        while (javaPkJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn javaPkJoinColumn = (JavaPrimaryKeyJoinColumn)javaPkJoinColumns.next();
            this.addDefaultPrimaryKeyJoinColumn(this.buildVirtualPrimaryKeyJoinColumn(javaPkJoinColumn));
        }
        if (this.defaultPrimaryKeyJoinColumnsSize() == 0 && this.specifiedPrimaryKeyJoinColumnsSize() == 0) {
            this.addDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(null));
        }
    }

    protected OrmPrimaryKeyJoinColumn buildVirtualPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn javaSecondaryTable) {
        return this.buildPrimaryKeyJoinColumn(new VirtualXmlPrimaryKeyJoinColumn(javaSecondaryTable));
    }

    protected OrmPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn resourcePkJoinColumn) {
        return this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner(), resourcePkJoinColumn);
    }

    protected void updateSpecifiedAttributeOverrides(XmlEntity entity) {
        ListIterator<OrmAttributeOverride> attributeOverrides = this.specifiedAttributeOverrides();
        CloneListIterator resourceAttributeOverrides = new CloneListIterator(entity.getAttributeOverrides());
        while (attributeOverrides.hasNext()) {
            OrmAttributeOverride attributeOverride = attributeOverrides.next();
            if (resourceAttributeOverrides.hasNext()) {
                attributeOverride.update((XmlAttributeOverride)resourceAttributeOverrides.next());
                continue;
            }
            this.removeSpecifiedAttributeOverride_(attributeOverride);
        }
        while (resourceAttributeOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.buildAttributeOverride((XmlAttributeOverride)resourceAttributeOverrides.next()));
        }
    }

    protected void updateVirtualAttributeOverrides() {
        Iterator<PersistentAttribute> overridableAttributes = this.allOverridableAttributes();
        ListIterator<OrmAttributeOverride> virtualAttributeOverridesCopy = this.virtualAttributeOverrides();
        for (PersistentAttribute persistentAttribute : CollectionTools.iterable(overridableAttributes)) {
            OrmAttributeOverride ormAttributeOverride = this.getAttributeOverrideNamed(persistentAttribute.getName());
            if (ormAttributeOverride != null && !ormAttributeOverride.isVirtual()) continue;
            JavaAttributeOverride javaAttributeOverride = null;
            if (this.getJavaEntity() != null) {
                javaAttributeOverride = this.getJavaEntity().getAttributeOverrideNamed(persistentAttribute.getName());
            }
            if (ormAttributeOverride != null) {
                if (virtualAttributeOverridesCopy.hasNext()) {
                    OrmAttributeOverride virtualAttributeOverride = virtualAttributeOverridesCopy.next();
                    virtualAttributeOverride.update(this.buildVirtualXmlAttributeOverride(persistentAttribute, javaAttributeOverride));
                    continue;
                }
                this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride));
                continue;
            }
            this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride));
        }
        for (OrmAttributeOverride virtualAttributeOverride : CollectionTools.iterable(virtualAttributeOverridesCopy)) {
            this.removeVirtualAttributeOverride(virtualAttributeOverride);
        }
    }

    protected OrmAttributeOverride buildAttributeOverride(XmlAttributeOverride attributeOverride) {
        return this.getJpaFactory().buildOrmAttributeOverride(this, this.createAttributeOverrideOwner(), attributeOverride);
    }

    protected AttributeOverride.Owner createAttributeOverrideOwner() {
        return new AttributeOverrideOwner();
    }

    protected void updateSpecifiedAssociationOverrides(XmlEntity entity) {
        ListIterator<OrmAssociationOverride> associationOverrides = this.specifiedAssociationOverrides();
        CloneListIterator resourceAssociationOverrides = new CloneListIterator(entity.getAssociationOverrides());
        while (associationOverrides.hasNext()) {
            OrmAssociationOverride associationOverride = associationOverrides.next();
            if (resourceAssociationOverrides.hasNext()) {
                associationOverride.update((XmlAssociationOverride)resourceAssociationOverrides.next());
                continue;
            }
            this.removeSpecifiedAssociationOverride_(associationOverride);
        }
        while (resourceAssociationOverrides.hasNext()) {
            this.addSpecifiedAssociationOverride(this.buildAssociationOverride((XmlAssociationOverride)resourceAssociationOverrides.next()));
        }
    }

    protected OrmAssociationOverride buildAssociationOverride(XmlAssociationOverride associationOverride) {
        return this.getJpaFactory().buildOrmAssociationOverride(this, this.createAssociationOverrideOwner(), associationOverride);
    }

    protected AssociationOverride.Owner createAssociationOverrideOwner() {
        return new AssociationOverrideOwner();
    }

    protected void updateNamedQueries(XmlEntity entity) {
        ListIterator<OrmNamedQuery> queries = this.namedQueries();
        CloneListIterator resourceNamedQueries = new CloneListIterator(entity.getNamedQueries());
        while (queries.hasNext()) {
            OrmNamedQuery namedQuery = queries.next();
            if (resourceNamedQueries.hasNext()) {
                namedQuery.update((XmlNamedQuery)resourceNamedQueries.next());
                continue;
            }
            this.removeNamedQuery_(namedQuery);
        }
        while (resourceNamedQueries.hasNext()) {
            this.addNamedQuery(this.buildNamedQuery((XmlNamedQuery)resourceNamedQueries.next()));
        }
    }

    protected OrmNamedQuery buildNamedQuery(XmlNamedQuery resourceNamedQuery) {
        return this.getJpaFactory().buildOrmNamedQuery(this, resourceNamedQuery);
    }

    protected void updateNamedNativeQueries(XmlEntity entity) {
        ListIterator<OrmNamedNativeQuery> queries = this.namedNativeQueries();
        CloneListIterator resourceNamedNativeQueries = new CloneListIterator(entity.getNamedNativeQueries());
        while (queries.hasNext()) {
            OrmNamedNativeQuery namedQuery = queries.next();
            if (resourceNamedNativeQueries.hasNext()) {
                namedQuery.update((XmlNamedNativeQuery)resourceNamedNativeQueries.next());
                continue;
            }
            this.removeNamedNativeQuery_(namedQuery);
        }
        while (resourceNamedNativeQueries.hasNext()) {
            this.addNamedNativeQuery(this.buildNamedNativeQuery((XmlNamedNativeQuery)resourceNamedNativeQueries.next()));
        }
    }

    protected OrmNamedNativeQuery buildNamedNativeQuery(XmlNamedNativeQuery resourceNamedNativeQuery) {
        return this.getJpaFactory().buildOrmNamedNativeQuery(this, resourceNamedNativeQuery);
    }

    protected void updateIdClass(XmlIdClass idClassResource) {
        this.setIdClass_(this.idClass(idClassResource));
    }

    protected void updatePersistenceUnitGeneratorsAndQueries() {
        if (this.getTableGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getTableGenerator());
        }
        if (this.getSequenceGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getSequenceGenerator());
        }
        for (Query query : CollectionTools.iterable(this.namedQueries())) {
            this.getPersistenceUnit().addQuery(query);
        }
        for (Query query : CollectionTools.iterable(this.namedNativeQueries())) {
            this.getPersistenceUnit().addQuery(query);
        }
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getPrimaryKeyColumnName(this.getPersistentType().allAttributes());
    }

    public String getPrimaryKeyColumnName(Iterator<PersistentAttribute> attributes) {
        String pkColumnName = null;
        Iterator<PersistentAttribute> stream = attributes;
        while (stream.hasNext()) {
            OrmAttributeOverride attributeOverride;
            PersistentAttribute attribute = stream.next();
            String name = attribute.getPrimaryKeyColumnName();
            if (name != null && (attributeOverride = this.getAttributeOverrideNamed(attribute.getName())) != null) {
                name = attributeOverride.getColumn().getName();
            }
            if (pkColumnName == null) {
                pkColumnName = name;
                continue;
            }
            if (name == null) continue;
            return null;
        }
        return pkColumnName;
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        this.table.validate(messages);
        this.validateId(messages);
        this.getPersistenceUnit().validateGenerators(this, messages);
        this.getPersistenceUnit().validateQueries(this, messages);
        ListIterator<OrmJpaContextNode> stream = this.secondaryTables();
        while (stream.hasNext()) {
            ((OrmSecondaryTable)stream.next()).validate(messages);
        }
        stream = this.attributeOverrides();
        while (stream.hasNext()) {
            ((OrmAttributeOverride)stream.next()).validate(messages);
        }
        stream = this.associationOverrides();
        while (stream.hasNext()) {
            ((OrmAssociationOverride)stream.next()).validate(messages);
        }
    }

    protected void validateId(List<IMessage> messages) {
        if (this.entityHasNoId()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NO_ID", new String[]{this.getName()}, this, this.getValidationTextRange()));
        }
    }

    private boolean entityHasNoId() {
        return !this.entityHasId();
    }

    private boolean entityHasId() {
        Iterator<PersistentAttribute> stream = this.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isIdAttribute()) continue;
            return true;
        }
        return false;
    }

    public TypeMapping typeMapping() {
        return this;
    }

    @Override
    public void removeFromResourceModel(XmlEntityMappings entityMappings) {
        entityMappings.getEntities().remove(this.getTypeMappingResource());
    }

    @Override
    public XmlEntity addToResourceModel(XmlEntityMappings entityMappings) {
        XmlEntity entity = OrmFactory.eINSTANCE.createXmlEntity();
        this.getPersistentType().initialize(entity);
        entityMappings.getEntities().add((Object)entity);
        return entity;
    }

    @Override
    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getName());
    }

    class AssociationOverrideOwner
    implements AssociationOverride.Owner {
        AssociationOverrideOwner() {
        }

        public RelationshipMapping getRelationshipMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = GenericOrmEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof RelationshipMapping)) continue;
                return (RelationshipMapping)persAttribute.getMapping();
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return GenericOrmEntity.this.virtualAssociationOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
            return null;
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmEntity.this;
        }
    }

    class AttributeOverrideOwner
    implements AttributeOverride.Owner {
        AttributeOverrideOwner() {
        }

        public ColumnMapping getColumnMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = GenericOrmEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
                return (ColumnMapping)((Object)persAttribute.getMapping());
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return GenericOrmEntity.this.virtualAttributeOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
            return GenericOrmEntity.this.setAttributeOverrideVirtual(virtual, (OrmAttributeOverride)override);
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmEntity.this;
        }
    }

    class PrimaryKeyJoinColumnOwner
    implements OrmBaseJoinColumn.Owner {
        PrimaryKeyJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmEntity.this;
        }

        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return GenericOrmEntity.this.getDbTable(tableName);
        }

        public org.eclipse.jpt.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = GenericOrmEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return GenericOrmEntity.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmEntity.this.defaultPrimaryKeyJoinColumns.contains(joinColumn);
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            return GenericOrmEntity.this.getParentEntity().getPrimaryKeyColumnName();
        }

        public TextRange getValidationTextRange() {
            return null;
        }
    }
}

